/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.report.loader;

import br.com.elotech.tributos.domain.Cidade;
import br.com.elotech.tributos.domain.Entidade;
import br.com.elotech.tributos.repository.EntidadeRepository;
import br.com.elotech.tributos.service.ExercicioService;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class LivroDividaAtivaParamLoader {
    private final EntidadeRepository entidadeRepository;
    private final ExercicioService exercicioService;
    private static final String PARAM_FORMAT = "%s=%s%n";

    public LivroDividaAtivaParamLoader(EntidadeRepository entidadeRepository, ExercicioService exercicioService) {
        this.entidadeRepository = entidadeRepository;
        this.exercicioService = exercicioService;
    }

    public String load(Boolean folhaUnica) {
        Entidade entidadeprincipal = this.entidadeRepository.findByEntidadeprincipal();
        String unidadeFederacaoDescr = this.entidadeRepository.findDescricaoUfEntidadeprincipal();
        Long exercicio = this.exercicioService.getExercicio();
        return String.format(PARAM_FORMAT, "PNomeEntidade", entidadeprincipal.getNome()).concat(String.format(PARAM_FORMAT, "PDescUF", unidadeFederacaoDescr)).concat(String.format(PARAM_FORMAT, "PExercicio", exercicio)).concat(String.format(PARAM_FORMAT, "PMascara_CEP", "XXXXX-XXX")).concat(String.format(PARAM_FORMAT, "PEndereco", "")).concat(String.format(PARAM_FORMAT, "PBairro", "")).concat(String.format(PARAM_FORMAT, "PCEP", StringUtils.defaultString((String)entidadeprincipal.getCep(), (String)""))).concat(String.format(PARAM_FORMAT, "PCidade", this.getCidadeDescricao(entidadeprincipal.getCidade()))).concat(String.format(PARAM_FORMAT, "PCNPJ", StringUtils.defaultString((String)entidadeprincipal.getCnpj(), (String)""))).concat(String.format(PARAM_FORMAT, "PCPF", "")).concat(String.format(PARAM_FORMAT, "PMask_CNPJ", "XX.XXX.XXX/XXXX-XX")).concat(String.format(PARAM_FORMAT, "PMask_CPF", "XXX.XXX.XXX-XX")).concat(String.format(PARAM_FORMAT, "PFolhaUnica", folhaUnica != false ? "S" : "N"));
    }

    private String getCidadeDescricao(Cidade cidade) {
        if (!Optional.ofNullable(cidade).isPresent()) {
            return "";
        }
        return cidade.getDescricao();
    }
}

