/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.report.loader;

import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.fluent.dataset.ReportDatasets;
import br.com.elotech.fluent.dataset.loader.DatasetLoaders;
import br.com.elotech.fluent.dataset.loader.ResultSetLoader;
import br.com.elotech.fluent.param.Param;
import br.com.elotech.fluent.param.ParamLoader;
import br.com.elotech.tributos.domain.Entidade;
import br.com.elotech.tributos.repository.EntidadeRepository;
import br.com.elotech.tributos.service.ExercicioService;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.sql.DataSource;
import org.springframework.stereotype.Component;

@Component
public class CabecalhoParamLoader
implements ParamLoader {
    public static final String PARAM_NOME_ENTIDADE = "PNomeEntidade";
    public static final String PARAM_EXERCICIO = "PExercicio";
    public static final String PARAM_DESC_UF = "PDescUF";
    public static final String PARAM_MASK_CNPJ = "PMaskCNPJ";
    public static final String PARAM_MASK_FONE = "PMaskFone";
    public static final String DATASET_CABECALHO = "Cabecalho";
    private static final String CABECALHO = "sql/cabecalho.sql";
    private final EntidadeRepository entidadeRepository;
    private final ExercicioService exercicioService;

    public CabecalhoParamLoader(EntidadeRepository entidadeRepository, ExercicioService exercicioService) {
        this.entidadeRepository = entidadeRepository;
        this.exercicioService = exercicioService;
    }

    public Set<Param> load(ReportDatasets datasets) {
        HashSet params = Sets.newHashSet();
        Entidade entidadeprincipal = this.entidadeRepository.findByEntidadeprincipal();
        String unidadeFederacaoDescr = this.entidadeRepository.findDescricaoUfEntidadeprincipal();
        params.add(Param.of((String)PARAM_NOME_ENTIDADE, (Object)entidadeprincipal.getNome()));
        params.add(Param.of((String)PARAM_EXERCICIO, (Object)this.exercicioService.getExercicio()));
        params.add(Param.of((String)PARAM_DESC_UF, (Object)("Estado do " + unidadeFederacaoDescr)));
        params.add(Param.of((String)PARAM_MASK_CNPJ, (Object)"XX.XXX.XXX/XXXX-XX"));
        params.add(Param.of((String)PARAM_MASK_FONE, (Object)"(XX)XXXX-XXXX"));
        return params;
    }

    public ResultSetLoader datasetLoader(DataSource dataSource) {
        HashMap<String, Long> paramsCabecalho = new HashMap<String, Long>();
        paramsCabecalho.put("entidade", this.entidadeRepository.findByEntidadeprincipal().getId());
        paramsCabecalho.put("exercicio", this.exercicioService.getExercicio());
        return DatasetLoaders.jdbc((String)FileUtils.readResourceAsString((String)CABECALHO), paramsCabecalho, (DataSource)dataSource);
    }
}

