/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto.parcelamento;

import br.com.elotech.tributos.dto.DebitoDTO;
import br.com.elotech.tributos.dto.parcelamento.AiseParcelamentoDTO;
import br.com.elotech.tributos.dto.parcelamento.ParcelaParcelamentoDTO;
import br.com.elotech.tributos.dto.parcelamento.ParcelamentoHandler;
import br.com.elotech.tributos.dto.parcelamento.TributoParcelamentoDTO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;

public class SimulacaoEstornoParcelamentoDTO {
    private List<DebitoDTO> debitosParcelamento = new ArrayList();
    private List<ParcelaParcelamentoDTO> parcelas = new ArrayList();
    private List<TributoParcelamentoDTO> tributos = new ArrayList();
    private BigDecimal valorTotalParcelas;
    private BigDecimal valorTotalTributos;

    public static SimulacaoEstornoParcelamentoDTO from(AiseParcelamentoDTO parcelamentoDTO, List<DebitoDTO> parcelasParcelamento) {
        SimulacaoEstornoParcelamentoDTO simulacao = new SimulacaoEstornoParcelamentoDTO();
        simulacao.setDebitosParcelamento(parcelasParcelamento);
        simulacao.getParcelas().addAll(ParcelamentoHandler.agruparPorDebitoParcela((List)parcelamentoDTO.getDebitos()));
        simulacao.getTributos().addAll(ParcelamentoHandler.agruparPorDebitoTributo((List)parcelamentoDTO.getDebitos()));
        simulacao.calculateValorTotal();
        return simulacao;
    }

    private void calculateValorTotal() {
        this.valorTotalParcelas = this.parcelas.stream().map(ParcelaParcelamentoDTO::getValorTotal).reduce(BigDecimal.ZERO, (parcela1, parcela2) -> parcela1.add((BigDecimal)parcela2));
        this.valorTotalTributos = this.tributos.stream().map(TributoParcelamentoDTO::getValorTotal).reduce(BigDecimal.ZERO, (tributo1, tributo2) -> tributo1.add((BigDecimal)tributo2));
    }

    @Generated
    public SimulacaoEstornoParcelamentoDTO() {
    }

    @Generated
    public List<DebitoDTO> getDebitosParcelamento() {
        return this.debitosParcelamento;
    }

    @Generated
    public List<ParcelaParcelamentoDTO> getParcelas() {
        return this.parcelas;
    }

    @Generated
    public List<TributoParcelamentoDTO> getTributos() {
        return this.tributos;
    }

    @Generated
    public BigDecimal getValorTotalParcelas() {
        return this.valorTotalParcelas;
    }

    @Generated
    public BigDecimal getValorTotalTributos() {
        return this.valorTotalTributos;
    }

    @Generated
    public void setDebitosParcelamento(List<DebitoDTO> debitosParcelamento) {
        this.debitosParcelamento = debitosParcelamento;
    }

    @Generated
    public void setParcelas(List<ParcelaParcelamentoDTO> parcelas) {
        this.parcelas = parcelas;
    }

    @Generated
    public void setTributos(List<TributoParcelamentoDTO> tributos) {
        this.tributos = tributos;
    }

    @Generated
    public void setValorTotalParcelas(BigDecimal valorTotalParcelas) {
        this.valorTotalParcelas = valorTotalParcelas;
    }

    @Generated
    public void setValorTotalTributos(BigDecimal valorTotalTributos) {
        this.valorTotalTributos = valorTotalTributos;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SimulacaoEstornoParcelamentoDTO)) {
            return false;
        }
        SimulacaoEstornoParcelamentoDTO other = (SimulacaoEstornoParcelamentoDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        List this$debitosParcelamento = this.getDebitosParcelamento();
        List other$debitosParcelamento = other.getDebitosParcelamento();
        if (this$debitosParcelamento == null ? other$debitosParcelamento != null : !((Object)this$debitosParcelamento).equals(other$debitosParcelamento)) {
            return false;
        }
        List this$parcelas = this.getParcelas();
        List other$parcelas = other.getParcelas();
        if (this$parcelas == null ? other$parcelas != null : !((Object)this$parcelas).equals(other$parcelas)) {
            return false;
        }
        List this$tributos = this.getTributos();
        List other$tributos = other.getTributos();
        if (this$tributos == null ? other$tributos != null : !((Object)this$tributos).equals(other$tributos)) {
            return false;
        }
        BigDecimal this$valorTotalParcelas = this.getValorTotalParcelas();
        BigDecimal other$valorTotalParcelas = other.getValorTotalParcelas();
        if (this$valorTotalParcelas == null ? other$valorTotalParcelas != null : !((Object)this$valorTotalParcelas).equals(other$valorTotalParcelas)) {
            return false;
        }
        BigDecimal this$valorTotalTributos = this.getValorTotalTributos();
        BigDecimal other$valorTotalTributos = other.getValorTotalTributos();
        return !(this$valorTotalTributos == null ? other$valorTotalTributos != null : !((Object)this$valorTotalTributos).equals(other$valorTotalTributos));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SimulacaoEstornoParcelamentoDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List $debitosParcelamento = this.getDebitosParcelamento();
        result = result * 59 + ($debitosParcelamento == null ? 43 : ((Object)$debitosParcelamento).hashCode());
        List $parcelas = this.getParcelas();
        result = result * 59 + ($parcelas == null ? 43 : ((Object)$parcelas).hashCode());
        List $tributos = this.getTributos();
        result = result * 59 + ($tributos == null ? 43 : ((Object)$tributos).hashCode());
        BigDecimal $valorTotalParcelas = this.getValorTotalParcelas();
        result = result * 59 + ($valorTotalParcelas == null ? 43 : ((Object)$valorTotalParcelas).hashCode());
        BigDecimal $valorTotalTributos = this.getValorTotalTributos();
        result = result * 59 + ($valorTotalTributos == null ? 43 : ((Object)$valorTotalTributos).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SimulacaoEstornoParcelamentoDTO(debitosParcelamento=" + this.getDebitosParcelamento() + ", parcelas=" + this.getParcelas() + ", tributos=" + this.getTributos() + ", valorTotalParcelas=" + this.getValorTotalParcelas() + ", valorTotalTributos=" + this.getValorTotalTributos() + ")";
    }
}

