/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto.parcelamento;

import br.com.elotech.core.utils.FileUtils;
import java.sql.Date;
import java.time.LocalDate;
import java.util.Objects;
import lombok.Generated;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;

public class FiltroEstornoParcelamentoEmLoteDTO {
    private static final String START_AND_FILTER = " and (";
    private static final String FILTRO_NOVENTA_DIAS = "br/com/elotech/tributos/repository/filtro-debito-desfazer-parcelamento.sql";
    private static final String PARCELA_A_VENCER = "br/com/elotech/tributos/repository/filtro-boleto-a-vencer.sql";
    private LocalDate dataDoInicioDoParcelamento;
    private LocalDate dataDoFimDoParcelamento;
    private LocalDate vencimentoParcela;
    private Boolean parcelaVencidaNoventaDias;
    private Boolean boletosVencidos;

    public String buildFiltroEstornoParcelamentoEmLoteDTO() {
        StringBuilder dtoParams = new StringBuilder();
        if (this.dataDoInicioDoParcelamento != null) {
            dtoParams.append(START_AND_FILTER).append("TRIBPARCELAMENTO.DATAPARCELAMENTO >= :DataInclusaoInicial").append(")");
        }
        if (this.dataDoFimDoParcelamento != null) {
            dtoParams.append(START_AND_FILTER).append("TRIBPARCELAMENTO.DATAPARCELAMENTO <= :DataInclusaoFinal").append(")");
        }
        return dtoParams.toString();
    }

    public String buildParcelaVencidaNoventaDias() {
        StringBuilder dtoParams = new StringBuilder();
        String sql = FileUtils.readResourceAsString((String)FILTRO_NOVENTA_DIAS);
        if (this.parcelaVencidaNoventaDias == Boolean.TRUE) {
            dtoParams.append(sql);
        } else {
            dtoParams.append("");
        }
        return dtoParams.toString();
    }

    public String buildParcelaAvencer() {
        StringBuilder dtoParams = new StringBuilder();
        String sql = FileUtils.readResourceAsString((String)PARCELA_A_VENCER);
        if (this.boletosVencidos == Boolean.TRUE) {
            dtoParams.append(sql);
        } else {
            dtoParams.append("");
        }
        return dtoParams.toString();
    }

    public MapSqlParameterSource getParameterSource(Long entidade, Long exercicio) {
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("entidade", (Object)entidade);
        params.addValue("exercicio", (Object)exercicio);
        if (Objects.nonNull(this.getDataDoInicioDoParcelamento())) {
            params.addValue("DataInclusaoInicial", (Object)Date.valueOf(this.getDataDoInicioDoParcelamento()));
        }
        if (Objects.nonNull(this.getDataDoFimDoParcelamento())) {
            params.addValue("DataInclusaoFinal", (Object)Date.valueOf(this.getDataDoFimDoParcelamento()));
        }
        if (Objects.nonNull(this.getVencimentoParcela())) {
            params.addValue("DataVencimento", (Object)Date.valueOf(this.getVencimentoParcela()));
        }
        return params;
    }

    @Generated
    public FiltroEstornoParcelamentoEmLoteDTO() {
    }

    @Generated
    public LocalDate getDataDoInicioDoParcelamento() {
        return this.dataDoInicioDoParcelamento;
    }

    @Generated
    public LocalDate getDataDoFimDoParcelamento() {
        return this.dataDoFimDoParcelamento;
    }

    @Generated
    public LocalDate getVencimentoParcela() {
        return this.vencimentoParcela;
    }

    @Generated
    public Boolean getParcelaVencidaNoventaDias() {
        return this.parcelaVencidaNoventaDias;
    }

    @Generated
    public Boolean getBoletosVencidos() {
        return this.boletosVencidos;
    }

    @Generated
    public void setDataDoInicioDoParcelamento(LocalDate dataDoInicioDoParcelamento) {
        this.dataDoInicioDoParcelamento = dataDoInicioDoParcelamento;
    }

    @Generated
    public void setDataDoFimDoParcelamento(LocalDate dataDoFimDoParcelamento) {
        this.dataDoFimDoParcelamento = dataDoFimDoParcelamento;
    }

    @Generated
    public void setVencimentoParcela(LocalDate vencimentoParcela) {
        this.vencimentoParcela = vencimentoParcela;
    }

    @Generated
    public void setParcelaVencidaNoventaDias(Boolean parcelaVencidaNoventaDias) {
        this.parcelaVencidaNoventaDias = parcelaVencidaNoventaDias;
    }

    @Generated
    public void setBoletosVencidos(Boolean boletosVencidos) {
        this.boletosVencidos = boletosVencidos;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FiltroEstornoParcelamentoEmLoteDTO)) {
            return false;
        }
        FiltroEstornoParcelamentoEmLoteDTO other = (FiltroEstornoParcelamentoEmLoteDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        LocalDate this$dataDoInicioDoParcelamento = this.getDataDoInicioDoParcelamento();
        LocalDate other$dataDoInicioDoParcelamento = other.getDataDoInicioDoParcelamento();
        if (this$dataDoInicioDoParcelamento == null ? other$dataDoInicioDoParcelamento != null : !((Object)this$dataDoInicioDoParcelamento).equals(other$dataDoInicioDoParcelamento)) {
            return false;
        }
        LocalDate this$dataDoFimDoParcelamento = this.getDataDoFimDoParcelamento();
        LocalDate other$dataDoFimDoParcelamento = other.getDataDoFimDoParcelamento();
        if (this$dataDoFimDoParcelamento == null ? other$dataDoFimDoParcelamento != null : !((Object)this$dataDoFimDoParcelamento).equals(other$dataDoFimDoParcelamento)) {
            return false;
        }
        LocalDate this$vencimentoParcela = this.getVencimentoParcela();
        LocalDate other$vencimentoParcela = other.getVencimentoParcela();
        if (this$vencimentoParcela == null ? other$vencimentoParcela != null : !((Object)this$vencimentoParcela).equals(other$vencimentoParcela)) {
            return false;
        }
        Boolean this$parcelaVencidaNoventaDias = this.getParcelaVencidaNoventaDias();
        Boolean other$parcelaVencidaNoventaDias = other.getParcelaVencidaNoventaDias();
        if (this$parcelaVencidaNoventaDias == null ? other$parcelaVencidaNoventaDias != null : !((Object)this$parcelaVencidaNoventaDias).equals(other$parcelaVencidaNoventaDias)) {
            return false;
        }
        Boolean this$boletosVencidos = this.getBoletosVencidos();
        Boolean other$boletosVencidos = other.getBoletosVencidos();
        return !(this$boletosVencidos == null ? other$boletosVencidos != null : !((Object)this$boletosVencidos).equals(other$boletosVencidos));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FiltroEstornoParcelamentoEmLoteDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        LocalDate $dataDoInicioDoParcelamento = this.getDataDoInicioDoParcelamento();
        result = result * 59 + ($dataDoInicioDoParcelamento == null ? 43 : ((Object)$dataDoInicioDoParcelamento).hashCode());
        LocalDate $dataDoFimDoParcelamento = this.getDataDoFimDoParcelamento();
        result = result * 59 + ($dataDoFimDoParcelamento == null ? 43 : ((Object)$dataDoFimDoParcelamento).hashCode());
        LocalDate $vencimentoParcela = this.getVencimentoParcela();
        result = result * 59 + ($vencimentoParcela == null ? 43 : ((Object)$vencimentoParcela).hashCode());
        Boolean $parcelaVencidaNoventaDias = this.getParcelaVencidaNoventaDias();
        result = result * 59 + ($parcelaVencidaNoventaDias == null ? 43 : ((Object)$parcelaVencidaNoventaDias).hashCode());
        Boolean $boletosVencidos = this.getBoletosVencidos();
        result = result * 59 + ($boletosVencidos == null ? 43 : ((Object)$boletosVencidos).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "FiltroEstornoParcelamentoEmLoteDTO(dataDoInicioDoParcelamento=" + this.getDataDoInicioDoParcelamento() + ", dataDoFimDoParcelamento=" + this.getDataDoFimDoParcelamento() + ", vencimentoParcela=" + this.getVencimentoParcela() + ", parcelaVencidaNoventaDias=" + this.getParcelaVencidaNoventaDias() + ", boletosVencidos=" + this.getBoletosVencidos() + ")";
    }
}

