/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto.integracaogeomais;

import br.com.elotech.tributos.domain.Pessoa;
import br.com.elotech.tributos.domain.Proprietario;
import br.com.elotech.tributos.domain.Vinculo;
import br.com.elotech.tributos.dto.integracaogeomais.PessoaGeomaisDTO;
import br.com.elotech.tributos.dto.integracaogeomais.ProprietarioGeomaisDTO;
import br.com.elotech.tributos.dto.integracaogeomais.VinculoGeomaisDTO;
import br.com.elotech.tributos.util.BooleanToStringUtils;
import java.math.BigDecimal;
import java.util.Optional;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import lombok.Generated;

/*
 * Exception performing whole class analysis ignored.
 */
public class ProprietarioGeomaisDTO {
    private Long codigo;
    @NotNull
    private String principal;
    @NotNull
    private BigDecimal percentual = BigDecimal.ZERO;
    @NotNull
    private String coResponsavelPrincipal;
    @NotNull
    @Valid
    private PessoaGeomaisDTO pessoa;
    @NotNull
    @Valid
    private VinculoGeomaisDTO vinculo;

    public static Builder builder() {
        return new Builder();
    }

    public static ProprietarioGeomaisDTO from(Proprietario entity) {
        return ProprietarioGeomaisDTO.builder().codigo(entity.getId()).principal(entity.getPrincipal().booleanValue()).percentual(entity.getPercentual()).coResponsavelPrincipal(entity.getCoResponsavelPrincipal().booleanValue()).pessoa(PessoaGeomaisDTO.from((Pessoa)entity.getPessoa())).vinculo(VinculoGeomaisDTO.from((Vinculo)entity.getVinculo())).build();
    }

    public Proprietario toEntity(Pessoa pessoa, Vinculo vinculo) {
        Proprietario entity = new Proprietario();
        entity.setId(this.getCodigo());
        Optional.ofNullable(this.getPrincipal()).ifPresent(principal -> entity.setPrincipal(BooleanToStringUtils.getStringAsBoolean((String)principal)));
        entity.setPercentual(this.getPercentual());
        Optional.ofNullable(this.getCoResponsavelPrincipal()).ifPresent(coResp -> entity.setCoResponsavelPrincipal(BooleanToStringUtils.getStringAsBoolean((String)coResp)));
        entity.setPessoa(pessoa);
        entity.setVinculo(vinculo);
        return entity;
    }

    @Generated
    public ProprietarioGeomaisDTO() {
    }

    @Generated
    public Long getCodigo() {
        return this.codigo;
    }

    @Generated
    public String getPrincipal() {
        return this.principal;
    }

    @Generated
    public BigDecimal getPercentual() {
        return this.percentual;
    }

    @Generated
    public String getCoResponsavelPrincipal() {
        return this.coResponsavelPrincipal;
    }

    @Generated
    public PessoaGeomaisDTO getPessoa() {
        return this.pessoa;
    }

    @Generated
    public VinculoGeomaisDTO getVinculo() {
        return this.vinculo;
    }

    @Generated
    public void setCodigo(Long codigo) {
        this.codigo = codigo;
    }

    @Generated
    public void setPrincipal(String principal) {
        this.principal = principal;
    }

    @Generated
    public void setPercentual(BigDecimal percentual) {
        this.percentual = percentual;
    }

    @Generated
    public void setCoResponsavelPrincipal(String coResponsavelPrincipal) {
        this.coResponsavelPrincipal = coResponsavelPrincipal;
    }

    @Generated
    public void setPessoa(PessoaGeomaisDTO pessoa) {
        this.pessoa = pessoa;
    }

    @Generated
    public void setVinculo(VinculoGeomaisDTO vinculo) {
        this.vinculo = vinculo;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProprietarioGeomaisDTO)) {
            return false;
        }
        ProprietarioGeomaisDTO other = (ProprietarioGeomaisDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$codigo = this.getCodigo();
        Long other$codigo = other.getCodigo();
        if (this$codigo == null ? other$codigo != null : !((Object)this$codigo).equals(other$codigo)) {
            return false;
        }
        String this$principal = this.getPrincipal();
        String other$principal = other.getPrincipal();
        if (this$principal == null ? other$principal != null : !this$principal.equals(other$principal)) {
            return false;
        }
        BigDecimal this$percentual = this.getPercentual();
        BigDecimal other$percentual = other.getPercentual();
        if (this$percentual == null ? other$percentual != null : !((Object)this$percentual).equals(other$percentual)) {
            return false;
        }
        String this$coResponsavelPrincipal = this.getCoResponsavelPrincipal();
        String other$coResponsavelPrincipal = other.getCoResponsavelPrincipal();
        if (this$coResponsavelPrincipal == null ? other$coResponsavelPrincipal != null : !this$coResponsavelPrincipal.equals(other$coResponsavelPrincipal)) {
            return false;
        }
        PessoaGeomaisDTO this$pessoa = this.getPessoa();
        PessoaGeomaisDTO other$pessoa = other.getPessoa();
        if (this$pessoa == null ? other$pessoa != null : !this$pessoa.equals(other$pessoa)) {
            return false;
        }
        VinculoGeomaisDTO this$vinculo = this.getVinculo();
        VinculoGeomaisDTO other$vinculo = other.getVinculo();
        return !(this$vinculo == null ? other$vinculo != null : !this$vinculo.equals(other$vinculo));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ProprietarioGeomaisDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $codigo = this.getCodigo();
        result = result * 59 + ($codigo == null ? 43 : ((Object)$codigo).hashCode());
        String $principal = this.getPrincipal();
        result = result * 59 + ($principal == null ? 43 : $principal.hashCode());
        BigDecimal $percentual = this.getPercentual();
        result = result * 59 + ($percentual == null ? 43 : ((Object)$percentual).hashCode());
        String $coResponsavelPrincipal = this.getCoResponsavelPrincipal();
        result = result * 59 + ($coResponsavelPrincipal == null ? 43 : $coResponsavelPrincipal.hashCode());
        PessoaGeomaisDTO $pessoa = this.getPessoa();
        result = result * 59 + ($pessoa == null ? 43 : $pessoa.hashCode());
        VinculoGeomaisDTO $vinculo = this.getVinculo();
        result = result * 59 + ($vinculo == null ? 43 : $vinculo.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ProprietarioGeomaisDTO(codigo=" + this.getCodigo() + ", principal=" + this.getPrincipal() + ", percentual=" + this.getPercentual() + ", coResponsavelPrincipal=" + this.getCoResponsavelPrincipal() + ", pessoa=" + this.getPessoa() + ", vinculo=" + this.getVinculo() + ")";
    }
}

