/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto.cadastrorural;

import br.com.elotech.tributos.domain.rural.CadastroRural;
import br.com.elotech.tributos.dto.cadastrorural.ProprietarioItbiDTO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;

public class CadastroRuralItbiDTO {
    private Long id;
    private Long cadastro;
    private String enderecoDescrito;
    private String nome;
    private String tipoLogradouro;
    private String logradouro;
    private String bairro;
    private String complemento;
    private String lote;
    private String distrito;
    private String setor;
    private Long numeroReceita;
    private String numeroIncra;
    private BigDecimal alqueires;
    private BigDecimal hectares;
    private BigDecimal areaTotal;
    private Boolean exclusaoLogica;
    private List<ProprietarioItbiDTO> proprietarios = new ArrayList();

    public static CadastroRuralItbiDTO from(CadastroRural cadastroRural) {
        CadastroRuralItbiDTO dto = new CadastroRuralItbiDTO();
        dto.id = cadastroRural.getId();
        dto.cadastro = cadastroRural.getCadastroGeral();
        dto.enderecoDescrito = cadastroRural.getEndereco();
        dto.nome = cadastroRural.getNomePropriedade();
        Optional.ofNullable(cadastroRural.getLogradouro()).ifPresent(logradouro -> {
            dto.tipoLogradouro = logradouro.getTipoLogradouroDescricao();
            dto.logradouro = logradouro.getDescricao();
        });
        Optional.ofNullable(cadastroRural.getBairro()).ifPresent(bairro -> {
            dto.bairro = bairro.getDescricao();
        });
        dto.complemento = cadastroRural.getComplemento();
        dto.lote = cadastroRural.getLote();
        Optional.ofNullable(cadastroRural.getDistrito()).ifPresent(distrito -> {
            dto.distrito = distrito.getDescricao();
        });
        Optional.ofNullable(cadastroRural.getSetor()).ifPresent(setor -> {
            dto.setor = setor.getApelido();
        });
        dto.numeroReceita = cadastroRural.getNumeroImovelReceita();
        dto.numeroIncra = cadastroRural.getCodigoIncra();
        dto.alqueires = cadastroRural.getQuantidadeAlqueires();
        dto.hectares = cadastroRural.getQuantidadeHectares();
        dto.areaTotal = cadastroRural.getAreaTotal();
        dto.exclusaoLogica = cadastroRural.getExclusaoLogica();
        dto.proprietarios = cadastroRural.getProprietarios().stream().map(ProprietarioItbiDTO::from).collect(Collectors.toList());
        return dto;
    }

    @Generated
    public CadastroRuralItbiDTO() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Long getCadastro() {
        return this.cadastro;
    }

    @Generated
    public String getEnderecoDescrito() {
        return this.enderecoDescrito;
    }

    @Generated
    public String getNome() {
        return this.nome;
    }

    @Generated
    public String getTipoLogradouro() {
        return this.tipoLogradouro;
    }

    @Generated
    public String getLogradouro() {
        return this.logradouro;
    }

    @Generated
    public String getBairro() {
        return this.bairro;
    }

    @Generated
    public String getComplemento() {
        return this.complemento;
    }

    @Generated
    public String getLote() {
        return this.lote;
    }

    @Generated
    public String getDistrito() {
        return this.distrito;
    }

    @Generated
    public String getSetor() {
        return this.setor;
    }

    @Generated
    public Long getNumeroReceita() {
        return this.numeroReceita;
    }

    @Generated
    public String getNumeroIncra() {
        return this.numeroIncra;
    }

    @Generated
    public BigDecimal getAlqueires() {
        return this.alqueires;
    }

    @Generated
    public BigDecimal getHectares() {
        return this.hectares;
    }

    @Generated
    public BigDecimal getAreaTotal() {
        return this.areaTotal;
    }

    @Generated
    public Boolean getExclusaoLogica() {
        return this.exclusaoLogica;
    }

    @Generated
    public List<ProprietarioItbiDTO> getProprietarios() {
        return this.proprietarios;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setCadastro(Long cadastro) {
        this.cadastro = cadastro;
    }

    @Generated
    public void setEnderecoDescrito(String enderecoDescrito) {
        this.enderecoDescrito = enderecoDescrito;
    }

    @Generated
    public void setNome(String nome) {
        this.nome = nome;
    }

    @Generated
    public void setTipoLogradouro(String tipoLogradouro) {
        this.tipoLogradouro = tipoLogradouro;
    }

    @Generated
    public void setLogradouro(String logradouro) {
        this.logradouro = logradouro;
    }

    @Generated
    public void setBairro(String bairro) {
        this.bairro = bairro;
    }

    @Generated
    public void setComplemento(String complemento) {
        this.complemento = complemento;
    }

    @Generated
    public void setLote(String lote) {
        this.lote = lote;
    }

    @Generated
    public void setDistrito(String distrito) {
        this.distrito = distrito;
    }

    @Generated
    public void setSetor(String setor) {
        this.setor = setor;
    }

    @Generated
    public void setNumeroReceita(Long numeroReceita) {
        this.numeroReceita = numeroReceita;
    }

    @Generated
    public void setNumeroIncra(String numeroIncra) {
        this.numeroIncra = numeroIncra;
    }

    @Generated
    public void setAlqueires(BigDecimal alqueires) {
        this.alqueires = alqueires;
    }

    @Generated
    public void setHectares(BigDecimal hectares) {
        this.hectares = hectares;
    }

    @Generated
    public void setAreaTotal(BigDecimal areaTotal) {
        this.areaTotal = areaTotal;
    }

    @Generated
    public void setExclusaoLogica(Boolean exclusaoLogica) {
        this.exclusaoLogica = exclusaoLogica;
    }

    @Generated
    public void setProprietarios(List<ProprietarioItbiDTO> proprietarios) {
        this.proprietarios = proprietarios;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CadastroRuralItbiDTO)) {
            return false;
        }
        CadastroRuralItbiDTO other = (CadastroRuralItbiDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$cadastro = this.getCadastro();
        Long other$cadastro = other.getCadastro();
        if (this$cadastro == null ? other$cadastro != null : !((Object)this$cadastro).equals(other$cadastro)) {
            return false;
        }
        String this$enderecoDescrito = this.getEnderecoDescrito();
        String other$enderecoDescrito = other.getEnderecoDescrito();
        if (this$enderecoDescrito == null ? other$enderecoDescrito != null : !this$enderecoDescrito.equals(other$enderecoDescrito)) {
            return false;
        }
        String this$nome = this.getNome();
        String other$nome = other.getNome();
        if (this$nome == null ? other$nome != null : !this$nome.equals(other$nome)) {
            return false;
        }
        String this$tipoLogradouro = this.getTipoLogradouro();
        String other$tipoLogradouro = other.getTipoLogradouro();
        if (this$tipoLogradouro == null ? other$tipoLogradouro != null : !this$tipoLogradouro.equals(other$tipoLogradouro)) {
            return false;
        }
        String this$logradouro = this.getLogradouro();
        String other$logradouro = other.getLogradouro();
        if (this$logradouro == null ? other$logradouro != null : !this$logradouro.equals(other$logradouro)) {
            return false;
        }
        String this$bairro = this.getBairro();
        String other$bairro = other.getBairro();
        if (this$bairro == null ? other$bairro != null : !this$bairro.equals(other$bairro)) {
            return false;
        }
        String this$complemento = this.getComplemento();
        String other$complemento = other.getComplemento();
        if (this$complemento == null ? other$complemento != null : !this$complemento.equals(other$complemento)) {
            return false;
        }
        String this$lote = this.getLote();
        String other$lote = other.getLote();
        if (this$lote == null ? other$lote != null : !this$lote.equals(other$lote)) {
            return false;
        }
        String this$distrito = this.getDistrito();
        String other$distrito = other.getDistrito();
        if (this$distrito == null ? other$distrito != null : !this$distrito.equals(other$distrito)) {
            return false;
        }
        String this$setor = this.getSetor();
        String other$setor = other.getSetor();
        if (this$setor == null ? other$setor != null : !this$setor.equals(other$setor)) {
            return false;
        }
        Long this$numeroReceita = this.getNumeroReceita();
        Long other$numeroReceita = other.getNumeroReceita();
        if (this$numeroReceita == null ? other$numeroReceita != null : !((Object)this$numeroReceita).equals(other$numeroReceita)) {
            return false;
        }
        String this$numeroIncra = this.getNumeroIncra();
        String other$numeroIncra = other.getNumeroIncra();
        if (this$numeroIncra == null ? other$numeroIncra != null : !this$numeroIncra.equals(other$numeroIncra)) {
            return false;
        }
        BigDecimal this$alqueires = this.getAlqueires();
        BigDecimal other$alqueires = other.getAlqueires();
        if (this$alqueires == null ? other$alqueires != null : !((Object)this$alqueires).equals(other$alqueires)) {
            return false;
        }
        BigDecimal this$hectares = this.getHectares();
        BigDecimal other$hectares = other.getHectares();
        if (this$hectares == null ? other$hectares != null : !((Object)this$hectares).equals(other$hectares)) {
            return false;
        }
        BigDecimal this$areaTotal = this.getAreaTotal();
        BigDecimal other$areaTotal = other.getAreaTotal();
        if (this$areaTotal == null ? other$areaTotal != null : !((Object)this$areaTotal).equals(other$areaTotal)) {
            return false;
        }
        Boolean this$exclusaoLogica = this.getExclusaoLogica();
        Boolean other$exclusaoLogica = other.getExclusaoLogica();
        if (this$exclusaoLogica == null ? other$exclusaoLogica != null : !((Object)this$exclusaoLogica).equals(other$exclusaoLogica)) {
            return false;
        }
        List this$proprietarios = this.getProprietarios();
        List other$proprietarios = other.getProprietarios();
        return !(this$proprietarios == null ? other$proprietarios != null : !((Object)this$proprietarios).equals(other$proprietarios));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CadastroRuralItbiDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $cadastro = this.getCadastro();
        result = result * 59 + ($cadastro == null ? 43 : ((Object)$cadastro).hashCode());
        String $enderecoDescrito = this.getEnderecoDescrito();
        result = result * 59 + ($enderecoDescrito == null ? 43 : $enderecoDescrito.hashCode());
        String $nome = this.getNome();
        result = result * 59 + ($nome == null ? 43 : $nome.hashCode());
        String $tipoLogradouro = this.getTipoLogradouro();
        result = result * 59 + ($tipoLogradouro == null ? 43 : $tipoLogradouro.hashCode());
        String $logradouro = this.getLogradouro();
        result = result * 59 + ($logradouro == null ? 43 : $logradouro.hashCode());
        String $bairro = this.getBairro();
        result = result * 59 + ($bairro == null ? 43 : $bairro.hashCode());
        String $complemento = this.getComplemento();
        result = result * 59 + ($complemento == null ? 43 : $complemento.hashCode());
        String $lote = this.getLote();
        result = result * 59 + ($lote == null ? 43 : $lote.hashCode());
        String $distrito = this.getDistrito();
        result = result * 59 + ($distrito == null ? 43 : $distrito.hashCode());
        String $setor = this.getSetor();
        result = result * 59 + ($setor == null ? 43 : $setor.hashCode());
        Long $numeroReceita = this.getNumeroReceita();
        result = result * 59 + ($numeroReceita == null ? 43 : ((Object)$numeroReceita).hashCode());
        String $numeroIncra = this.getNumeroIncra();
        result = result * 59 + ($numeroIncra == null ? 43 : $numeroIncra.hashCode());
        BigDecimal $alqueires = this.getAlqueires();
        result = result * 59 + ($alqueires == null ? 43 : ((Object)$alqueires).hashCode());
        BigDecimal $hectares = this.getHectares();
        result = result * 59 + ($hectares == null ? 43 : ((Object)$hectares).hashCode());
        BigDecimal $areaTotal = this.getAreaTotal();
        result = result * 59 + ($areaTotal == null ? 43 : ((Object)$areaTotal).hashCode());
        Boolean $exclusaoLogica = this.getExclusaoLogica();
        result = result * 59 + ($exclusaoLogica == null ? 43 : ((Object)$exclusaoLogica).hashCode());
        List $proprietarios = this.getProprietarios();
        result = result * 59 + ($proprietarios == null ? 43 : ((Object)$proprietarios).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "CadastroRuralItbiDTO(id=" + this.getId() + ", cadastro=" + this.getCadastro() + ", enderecoDescrito=" + this.getEnderecoDescrito() + ", nome=" + this.getNome() + ", tipoLogradouro=" + this.getTipoLogradouro() + ", logradouro=" + this.getLogradouro() + ", bairro=" + this.getBairro() + ", complemento=" + this.getComplemento() + ", lote=" + this.getLote() + ", distrito=" + this.getDistrito() + ", setor=" + this.getSetor() + ", numeroReceita=" + this.getNumeroReceita() + ", numeroIncra=" + this.getNumeroIncra() + ", alqueires=" + this.getAlqueires() + ", hectares=" + this.getHectares() + ", areaTotal=" + this.getAreaTotal() + ", exclusaoLogica=" + this.getExclusaoLogica() + ", proprietarios=" + this.getProprietarios() + ")";
    }
}

