/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto;

import br.com.elotech.fluent.dataset.DatasetRecord;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.domain.TipoExtratoDebitoEnum;
import br.com.elotech.tributos.domain.TipoSituacaoParcela;
import br.com.elotech.tributos.dto.TotalExtratoDebitoDTO;
import br.com.elotech.tributos.dto.acrescimo.CalculaAcrescimoBaseDTO;
import br.com.elotech.tributos.util.DateUtils;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;

public class ExtratoDebitoDTO
extends CalculaAcrescimoBaseDTO
implements DatasetRecord {
    private String nomeContribuinte;
    private String cnpjCpfContribuinte;
    private String numeroContribuinte;
    private String complementoContribuinte;
    private String logradouroContribuinte;
    private String tipoLogradouroContribuinte;
    private String cidadeContribuinte;
    private String unidadeFederacaoContribuinte;
    private String tipoLogradouro;
    private String logradouro;
    private String numero;
    private String complemento;
    private String inscricaoCadastral;
    private String quadricula;
    private String distrito;
    private String setor;
    private String quadra;
    private String loteInscricaoCadastral;
    private String unidade;
    private String inscricaoCadastralComMascara;
    private String complementoLote;
    private String situacaoDebitoSigla;
    private String descricaoDivida;
    private Long pagamento;
    private Long exercicioPagamento;
    private Long lote;
    private BigDecimal valorPago = BigDecimal.ZERO;
    private LocalDate dataMovimento;
    private BigDecimal valorJurosPagamento = BigDecimal.ZERO;
    private BigDecimal valorMultaPagamento = BigDecimal.ZERO;
    private BigDecimal valorCorrecaoPagamento = BigDecimal.ZERO;
    private BigDecimal valorDescontoPagamento = BigDecimal.ZERO;
    private Long numeroContrato;
    private Long anoContrato;

    public String getSituacaoSigla() {
        return this.situacaoDebitoSigla;
    }

    public String getDescricaoPagamento() {
        return Objects.nonNull(this.pagamento) ? String.format("%d/%d", this.pagamento, this.exercicioPagamento) : "";
    }

    public String getIdentificacao() {
        if (this.parcelado.booleanValue() || this.reparcelado.booleanValue()) {
            return String.format("Contrato (%d) de parcelamento - %d", this.numeroContrato, this.anoContrato);
        }
        return String.format("%d - %d - %s - %d", this.exercicio, this.divida, this.descricaoDivida, this.subDivida);
    }

    public BigDecimal getValorAcrescimosExtrato() {
        if (this.valorPago.compareTo(BigDecimal.ZERO) > 0) {
            return this.valorJurosPagamento.add(this.valorMultaPagamento).add(this.valorCorrecaoPagamento);
        }
        return this.valorJuros.add(this.valorMulta).add(this.valorCorrecao);
    }

    public BigDecimal getValorDescontosExtrato() {
        if (this.valorPago.compareTo(BigDecimal.ZERO) > 0) {
            return this.valorDescontoPagamento.add(this.valorDescontoJuros).add(this.valorDescontoMulta).add(this.valorDescontoCorrecao);
        }
        return this.valorDescontoPrincipal.add(this.valorDescontoJuros).add(this.valorDescontoMulta).add(this.valorDescontoCorrecao);
    }

    public String getContribuinte() {
        return String.format("%d - %s", this.pessoa, this.nomeContribuinte);
    }

    public String getEnderecoContribuinte() {
        return String.format("%s%s, %s, Complemento: %s, %s - %s", Optional.ofNullable(this.tipoLogradouroContribuinte).map(tipoLogradouro -> tipoLogradouro.toUpperCase() + " ").orElse(""), this.logradouroContribuinte, StringUtils.defaultIfEmpty((String)this.numeroContribuinte, (String)"S/N"), StringUtils.defaultIfEmpty((String)this.complementoContribuinte, (String)"Sem complemento"), this.cidadeContribuinte, this.unidadeFederacaoContribuinte);
    }

    public String getCadastro() {
        return String.format("%s - %d", TipoCadastro.fromValue((Long)this.tipoCadastro).getDescricao(), this.cadastroGeral);
    }

    public String getSituacaoExtrato() {
        return String.format("%s %s", this.situacaoDebitoDescricao, this.situacaoDebitoSigla);
    }

    public String getDataVencimentoExtrato() {
        return DateUtils.localDateToStringFormatoBrasileiro((LocalDate)this.dataVencimento);
    }

    public BigDecimal getValorTotalExtrato() {
        if (TipoSituacaoParcela.PAGO.getValue().equals(this.tipoSituacaoParcela)) {
            return this.valorPago;
        }
        return this.valorPrincipal.add(this.getValorAcrescimosExtrato()).subtract(this.getValorDescontosExtrato());
    }

    public String getEnderecoLocalizacao() {
        return String.format("%s %s, %s, Complemento: %s", this.tipoLogradouro, this.logradouro, StringUtils.defaultIfEmpty((String)this.numero, (String)"S/N"), StringUtils.defaultIfEmpty((String)this.complemento, (String)"Sem complemento"));
    }

    public Boolean isDevedorGeral() {
        return TipoSituacaoParcela.ABERTO.getValue().equals(this.tipoSituacaoParcela);
    }

    public Boolean isDevedorVencido() {
        return TipoSituacaoParcela.ABERTO.getValue().equals(this.tipoSituacaoParcela) && this.dataVencimento.isBefore(LocalDate.now());
    }

    public Boolean isDevedorAVencer() {
        return TipoSituacaoParcela.ABERTO.getValue().equals(this.tipoSituacaoParcela) && (this.dataVencimento.isAfter(LocalDate.now()) || this.dataVencimento.isEqual(LocalDate.now()));
    }

    public Boolean isDevedorParcelado() {
        return TipoSituacaoParcela.ABERTO.getValue().equals(this.tipoSituacaoParcela) && (this.parcelado != false || this.reparcelado != false);
    }

    public Boolean isPago() {
        return TipoSituacaoParcela.PAGO.getValue().equals(this.tipoSituacaoParcela);
    }

    public static Map<TipoExtratoDebitoEnum, TotalExtratoDebitoDTO> gerarTotalizador(List<ExtratoDebitoDTO> debitos) {
        TotalExtratoDebitoDTO totalDevedorGeral = new TotalExtratoDebitoDTO(TipoExtratoDebitoEnum.DEVEDOR_GERAL, BigDecimal.ZERO);
        TotalExtratoDebitoDTO totalDevedorVencido = new TotalExtratoDebitoDTO(TipoExtratoDebitoEnum.DEVEDOR_VENCIDO, BigDecimal.ZERO);
        TotalExtratoDebitoDTO totalDevedorAVencer = new TotalExtratoDebitoDTO(TipoExtratoDebitoEnum.DEVEDOR_A_VENCER, BigDecimal.ZERO);
        TotalExtratoDebitoDTO totalDevedorParcelado = new TotalExtratoDebitoDTO(TipoExtratoDebitoEnum.DEVEDOR_PARCELADO, BigDecimal.ZERO);
        TotalExtratoDebitoDTO totalPagos = new TotalExtratoDebitoDTO(TipoExtratoDebitoEnum.PAGOS, BigDecimal.ZERO);
        TotalExtratoDebitoDTO totalGeral = new TotalExtratoDebitoDTO(TipoExtratoDebitoEnum.TODOS, BigDecimal.ZERO);
        debitos.forEach(debito -> {
            totalGeral.add(debito.getValorTotal());
            if (debito.isDevedorGeral().booleanValue()) {
                totalDevedorGeral.add(debito.getValorTotal());
            }
            if (debito.isDevedorVencido().booleanValue()) {
                totalDevedorVencido.add(debito.getValorTotal());
            }
            if (debito.isDevedorAVencer().booleanValue()) {
                totalDevedorAVencer.add(debito.getValorTotal());
            }
            if (debito.isDevedorParcelado().booleanValue()) {
                totalDevedorParcelado.add(debito.getValorTotal());
            }
            if (debito.isPago().booleanValue()) {
                totalPagos.add(debito.getValorTotal());
            }
        });
        return Stream.of(totalDevedorGeral, totalDevedorVencido, totalDevedorAVencer, totalDevedorParcelado, totalPagos, totalGeral).collect(Collectors.toMap(TotalExtratoDebitoDTO::getIdentificador, Function.identity()));
    }

    public <T extends CalculaAcrescimoBaseDTO> T add(T dto) {
        ExtratoDebitoDTO dtoCasted = (ExtratoDebitoDTO)dto;
        this.setValorPago(this.getValorPago().add(dtoCasted.getValorPago()));
        this.setValorJurosPagamento(this.getValorJurosPagamento().add(dtoCasted.getValorJurosPagamento()));
        this.setValorMultaPagamento(this.getValorMultaPagamento().add(dtoCasted.getValorMultaPagamento()));
        this.setValorCorrecaoPagamento(this.getValorCorrecaoPagamento().add(dtoCasted.getValorCorrecaoPagamento()));
        this.setValorDescontoPagamento(this.getValorDescontoPagamento().add(dtoCasted.getValorDescontoPagamento()));
        return (T)super.internalAdd(dto);
    }

    @Generated
    public ExtratoDebitoDTO() {
    }

    @Generated
    public String getNomeContribuinte() {
        return this.nomeContribuinte;
    }

    @Generated
    public String getCnpjCpfContribuinte() {
        return this.cnpjCpfContribuinte;
    }

    @Generated
    public String getNumeroContribuinte() {
        return this.numeroContribuinte;
    }

    @Generated
    public String getComplementoContribuinte() {
        return this.complementoContribuinte;
    }

    @Generated
    public String getLogradouroContribuinte() {
        return this.logradouroContribuinte;
    }

    @Generated
    public String getTipoLogradouroContribuinte() {
        return this.tipoLogradouroContribuinte;
    }

    @Generated
    public String getCidadeContribuinte() {
        return this.cidadeContribuinte;
    }

    @Generated
    public String getUnidadeFederacaoContribuinte() {
        return this.unidadeFederacaoContribuinte;
    }

    @Generated
    public String getTipoLogradouro() {
        return this.tipoLogradouro;
    }

    @Generated
    public String getLogradouro() {
        return this.logradouro;
    }

    @Generated
    public String getNumero() {
        return this.numero;
    }

    @Generated
    public String getComplemento() {
        return this.complemento;
    }

    @Generated
    public String getInscricaoCadastral() {
        return this.inscricaoCadastral;
    }

    @Generated
    public String getQuadricula() {
        return this.quadricula;
    }

    @Generated
    public String getDistrito() {
        return this.distrito;
    }

    @Generated
    public String getSetor() {
        return this.setor;
    }

    @Generated
    public String getQuadra() {
        return this.quadra;
    }

    @Generated
    public String getLoteInscricaoCadastral() {
        return this.loteInscricaoCadastral;
    }

    @Generated
    public String getUnidade() {
        return this.unidade;
    }

    @Generated
    public String getInscricaoCadastralComMascara() {
        return this.inscricaoCadastralComMascara;
    }

    @Generated
    public String getComplementoLote() {
        return this.complementoLote;
    }

    @Generated
    public String getSituacaoDebitoSigla() {
        return this.situacaoDebitoSigla;
    }

    @Generated
    public String getDescricaoDivida() {
        return this.descricaoDivida;
    }

    @Generated
    public Long getPagamento() {
        return this.pagamento;
    }

    @Generated
    public Long getExercicioPagamento() {
        return this.exercicioPagamento;
    }

    @Generated
    public Long getLote() {
        return this.lote;
    }

    @Generated
    public BigDecimal getValorPago() {
        return this.valorPago;
    }

    @Generated
    public LocalDate getDataMovimento() {
        return this.dataMovimento;
    }

    @Generated
    public BigDecimal getValorJurosPagamento() {
        return this.valorJurosPagamento;
    }

    @Generated
    public BigDecimal getValorMultaPagamento() {
        return this.valorMultaPagamento;
    }

    @Generated
    public BigDecimal getValorCorrecaoPagamento() {
        return this.valorCorrecaoPagamento;
    }

    @Generated
    public BigDecimal getValorDescontoPagamento() {
        return this.valorDescontoPagamento;
    }

    @Generated
    public Long getNumeroContrato() {
        return this.numeroContrato;
    }

    @Generated
    public Long getAnoContrato() {
        return this.anoContrato;
    }

    @Generated
    public void setNomeContribuinte(String nomeContribuinte) {
        this.nomeContribuinte = nomeContribuinte;
    }

    @Generated
    public void setCnpjCpfContribuinte(String cnpjCpfContribuinte) {
        this.cnpjCpfContribuinte = cnpjCpfContribuinte;
    }

    @Generated
    public void setNumeroContribuinte(String numeroContribuinte) {
        this.numeroContribuinte = numeroContribuinte;
    }

    @Generated
    public void setComplementoContribuinte(String complementoContribuinte) {
        this.complementoContribuinte = complementoContribuinte;
    }

    @Generated
    public void setLogradouroContribuinte(String logradouroContribuinte) {
        this.logradouroContribuinte = logradouroContribuinte;
    }

    @Generated
    public void setTipoLogradouroContribuinte(String tipoLogradouroContribuinte) {
        this.tipoLogradouroContribuinte = tipoLogradouroContribuinte;
    }

    @Generated
    public void setCidadeContribuinte(String cidadeContribuinte) {
        this.cidadeContribuinte = cidadeContribuinte;
    }

    @Generated
    public void setUnidadeFederacaoContribuinte(String unidadeFederacaoContribuinte) {
        this.unidadeFederacaoContribuinte = unidadeFederacaoContribuinte;
    }

    @Generated
    public void setTipoLogradouro(String tipoLogradouro) {
        this.tipoLogradouro = tipoLogradouro;
    }

    @Generated
    public void setLogradouro(String logradouro) {
        this.logradouro = logradouro;
    }

    @Generated
    public void setNumero(String numero) {
        this.numero = numero;
    }

    @Generated
    public void setComplemento(String complemento) {
        this.complemento = complemento;
    }

    @Generated
    public void setInscricaoCadastral(String inscricaoCadastral) {
        this.inscricaoCadastral = inscricaoCadastral;
    }

    @Generated
    public void setQuadricula(String quadricula) {
        this.quadricula = quadricula;
    }

    @Generated
    public void setDistrito(String distrito) {
        this.distrito = distrito;
    }

    @Generated
    public void setSetor(String setor) {
        this.setor = setor;
    }

    @Generated
    public void setQuadra(String quadra) {
        this.quadra = quadra;
    }

    @Generated
    public void setLoteInscricaoCadastral(String loteInscricaoCadastral) {
        this.loteInscricaoCadastral = loteInscricaoCadastral;
    }

    @Generated
    public void setUnidade(String unidade) {
        this.unidade = unidade;
    }

    @Generated
    public void setInscricaoCadastralComMascara(String inscricaoCadastralComMascara) {
        this.inscricaoCadastralComMascara = inscricaoCadastralComMascara;
    }

    @Generated
    public void setComplementoLote(String complementoLote) {
        this.complementoLote = complementoLote;
    }

    @Generated
    public void setSituacaoDebitoSigla(String situacaoDebitoSigla) {
        this.situacaoDebitoSigla = situacaoDebitoSigla;
    }

    @Generated
    public void setDescricaoDivida(String descricaoDivida) {
        this.descricaoDivida = descricaoDivida;
    }

    @Generated
    public void setPagamento(Long pagamento) {
        this.pagamento = pagamento;
    }

    @Generated
    public void setExercicioPagamento(Long exercicioPagamento) {
        this.exercicioPagamento = exercicioPagamento;
    }

    @Generated
    public void setLote(Long lote) {
        this.lote = lote;
    }

    @Generated
    public void setValorPago(BigDecimal valorPago) {
        this.valorPago = valorPago;
    }

    @Generated
    public void setDataMovimento(LocalDate dataMovimento) {
        this.dataMovimento = dataMovimento;
    }

    @Generated
    public void setValorJurosPagamento(BigDecimal valorJurosPagamento) {
        this.valorJurosPagamento = valorJurosPagamento;
    }

    @Generated
    public void setValorMultaPagamento(BigDecimal valorMultaPagamento) {
        this.valorMultaPagamento = valorMultaPagamento;
    }

    @Generated
    public void setValorCorrecaoPagamento(BigDecimal valorCorrecaoPagamento) {
        this.valorCorrecaoPagamento = valorCorrecaoPagamento;
    }

    @Generated
    public void setValorDescontoPagamento(BigDecimal valorDescontoPagamento) {
        this.valorDescontoPagamento = valorDescontoPagamento;
    }

    @Generated
    public void setNumeroContrato(Long numeroContrato) {
        this.numeroContrato = numeroContrato;
    }

    @Generated
    public void setAnoContrato(Long anoContrato) {
        this.anoContrato = anoContrato;
    }

    @Generated
    public String toString() {
        return "ExtratoDebitoDTO(nomeContribuinte=" + this.getNomeContribuinte() + ", cnpjCpfContribuinte=" + this.getCnpjCpfContribuinte() + ", numeroContribuinte=" + this.getNumeroContribuinte() + ", complementoContribuinte=" + this.getComplementoContribuinte() + ", logradouroContribuinte=" + this.getLogradouroContribuinte() + ", tipoLogradouroContribuinte=" + this.getTipoLogradouroContribuinte() + ", cidadeContribuinte=" + this.getCidadeContribuinte() + ", unidadeFederacaoContribuinte=" + this.getUnidadeFederacaoContribuinte() + ", tipoLogradouro=" + this.getTipoLogradouro() + ", logradouro=" + this.getLogradouro() + ", numero=" + this.getNumero() + ", complemento=" + this.getComplemento() + ", inscricaoCadastral=" + this.getInscricaoCadastral() + ", quadricula=" + this.getQuadricula() + ", distrito=" + this.getDistrito() + ", setor=" + this.getSetor() + ", quadra=" + this.getQuadra() + ", loteInscricaoCadastral=" + this.getLoteInscricaoCadastral() + ", unidade=" + this.getUnidade() + ", inscricaoCadastralComMascara=" + this.getInscricaoCadastralComMascara() + ", complementoLote=" + this.getComplementoLote() + ", situacaoDebitoSigla=" + this.getSituacaoDebitoSigla() + ", descricaoDivida=" + this.getDescricaoDivida() + ", pagamento=" + this.getPagamento() + ", exercicioPagamento=" + this.getExercicioPagamento() + ", lote=" + this.getLote() + ", valorPago=" + this.getValorPago() + ", dataMovimento=" + this.getDataMovimento() + ", valorJurosPagamento=" + this.getValorJurosPagamento() + ", valorMultaPagamento=" + this.getValorMultaPagamento() + ", valorCorrecaoPagamento=" + this.getValorCorrecaoPagamento() + ", valorDescontoPagamento=" + this.getValorDescontoPagamento() + ", numeroContrato=" + this.getNumeroContrato() + ", anoContrato=" + this.getAnoContrato() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExtratoDebitoDTO)) {
            return false;
        }
        ExtratoDebitoDTO other = (ExtratoDebitoDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$nomeContribuinte = this.getNomeContribuinte();
        String other$nomeContribuinte = other.getNomeContribuinte();
        if (this$nomeContribuinte == null ? other$nomeContribuinte != null : !this$nomeContribuinte.equals(other$nomeContribuinte)) {
            return false;
        }
        String this$cnpjCpfContribuinte = this.getCnpjCpfContribuinte();
        String other$cnpjCpfContribuinte = other.getCnpjCpfContribuinte();
        if (this$cnpjCpfContribuinte == null ? other$cnpjCpfContribuinte != null : !this$cnpjCpfContribuinte.equals(other$cnpjCpfContribuinte)) {
            return false;
        }
        String this$numeroContribuinte = this.getNumeroContribuinte();
        String other$numeroContribuinte = other.getNumeroContribuinte();
        if (this$numeroContribuinte == null ? other$numeroContribuinte != null : !this$numeroContribuinte.equals(other$numeroContribuinte)) {
            return false;
        }
        String this$complementoContribuinte = this.getComplementoContribuinte();
        String other$complementoContribuinte = other.getComplementoContribuinte();
        if (this$complementoContribuinte == null ? other$complementoContribuinte != null : !this$complementoContribuinte.equals(other$complementoContribuinte)) {
            return false;
        }
        String this$logradouroContribuinte = this.getLogradouroContribuinte();
        String other$logradouroContribuinte = other.getLogradouroContribuinte();
        if (this$logradouroContribuinte == null ? other$logradouroContribuinte != null : !this$logradouroContribuinte.equals(other$logradouroContribuinte)) {
            return false;
        }
        String this$tipoLogradouroContribuinte = this.getTipoLogradouroContribuinte();
        String other$tipoLogradouroContribuinte = other.getTipoLogradouroContribuinte();
        if (this$tipoLogradouroContribuinte == null ? other$tipoLogradouroContribuinte != null : !this$tipoLogradouroContribuinte.equals(other$tipoLogradouroContribuinte)) {
            return false;
        }
        String this$cidadeContribuinte = this.getCidadeContribuinte();
        String other$cidadeContribuinte = other.getCidadeContribuinte();
        if (this$cidadeContribuinte == null ? other$cidadeContribuinte != null : !this$cidadeContribuinte.equals(other$cidadeContribuinte)) {
            return false;
        }
        String this$unidadeFederacaoContribuinte = this.getUnidadeFederacaoContribuinte();
        String other$unidadeFederacaoContribuinte = other.getUnidadeFederacaoContribuinte();
        if (this$unidadeFederacaoContribuinte == null ? other$unidadeFederacaoContribuinte != null : !this$unidadeFederacaoContribuinte.equals(other$unidadeFederacaoContribuinte)) {
            return false;
        }
        String this$tipoLogradouro = this.getTipoLogradouro();
        String other$tipoLogradouro = other.getTipoLogradouro();
        if (this$tipoLogradouro == null ? other$tipoLogradouro != null : !this$tipoLogradouro.equals(other$tipoLogradouro)) {
            return false;
        }
        String this$logradouro = this.getLogradouro();
        String other$logradouro = other.getLogradouro();
        if (this$logradouro == null ? other$logradouro != null : !this$logradouro.equals(other$logradouro)) {
            return false;
        }
        String this$numero = this.getNumero();
        String other$numero = other.getNumero();
        if (this$numero == null ? other$numero != null : !this$numero.equals(other$numero)) {
            return false;
        }
        String this$complemento = this.getComplemento();
        String other$complemento = other.getComplemento();
        if (this$complemento == null ? other$complemento != null : !this$complemento.equals(other$complemento)) {
            return false;
        }
        String this$inscricaoCadastral = this.getInscricaoCadastral();
        String other$inscricaoCadastral = other.getInscricaoCadastral();
        if (this$inscricaoCadastral == null ? other$inscricaoCadastral != null : !this$inscricaoCadastral.equals(other$inscricaoCadastral)) {
            return false;
        }
        String this$quadricula = this.getQuadricula();
        String other$quadricula = other.getQuadricula();
        if (this$quadricula == null ? other$quadricula != null : !this$quadricula.equals(other$quadricula)) {
            return false;
        }
        String this$distrito = this.getDistrito();
        String other$distrito = other.getDistrito();
        if (this$distrito == null ? other$distrito != null : !this$distrito.equals(other$distrito)) {
            return false;
        }
        String this$setor = this.getSetor();
        String other$setor = other.getSetor();
        if (this$setor == null ? other$setor != null : !this$setor.equals(other$setor)) {
            return false;
        }
        String this$quadra = this.getQuadra();
        String other$quadra = other.getQuadra();
        if (this$quadra == null ? other$quadra != null : !this$quadra.equals(other$quadra)) {
            return false;
        }
        String this$loteInscricaoCadastral = this.getLoteInscricaoCadastral();
        String other$loteInscricaoCadastral = other.getLoteInscricaoCadastral();
        if (this$loteInscricaoCadastral == null ? other$loteInscricaoCadastral != null : !this$loteInscricaoCadastral.equals(other$loteInscricaoCadastral)) {
            return false;
        }
        String this$unidade = this.getUnidade();
        String other$unidade = other.getUnidade();
        if (this$unidade == null ? other$unidade != null : !this$unidade.equals(other$unidade)) {
            return false;
        }
        String this$inscricaoCadastralComMascara = this.getInscricaoCadastralComMascara();
        String other$inscricaoCadastralComMascara = other.getInscricaoCadastralComMascara();
        if (this$inscricaoCadastralComMascara == null ? other$inscricaoCadastralComMascara != null : !this$inscricaoCadastralComMascara.equals(other$inscricaoCadastralComMascara)) {
            return false;
        }
        String this$complementoLote = this.getComplementoLote();
        String other$complementoLote = other.getComplementoLote();
        if (this$complementoLote == null ? other$complementoLote != null : !this$complementoLote.equals(other$complementoLote)) {
            return false;
        }
        String this$situacaoDebitoSigla = this.getSituacaoDebitoSigla();
        String other$situacaoDebitoSigla = other.getSituacaoDebitoSigla();
        if (this$situacaoDebitoSigla == null ? other$situacaoDebitoSigla != null : !this$situacaoDebitoSigla.equals(other$situacaoDebitoSigla)) {
            return false;
        }
        String this$descricaoDivida = this.getDescricaoDivida();
        String other$descricaoDivida = other.getDescricaoDivida();
        if (this$descricaoDivida == null ? other$descricaoDivida != null : !this$descricaoDivida.equals(other$descricaoDivida)) {
            return false;
        }
        Long this$pagamento = this.getPagamento();
        Long other$pagamento = other.getPagamento();
        if (this$pagamento == null ? other$pagamento != null : !((Object)this$pagamento).equals(other$pagamento)) {
            return false;
        }
        Long this$exercicioPagamento = this.getExercicioPagamento();
        Long other$exercicioPagamento = other.getExercicioPagamento();
        if (this$exercicioPagamento == null ? other$exercicioPagamento != null : !((Object)this$exercicioPagamento).equals(other$exercicioPagamento)) {
            return false;
        }
        Long this$lote = this.getLote();
        Long other$lote = other.getLote();
        if (this$lote == null ? other$lote != null : !((Object)this$lote).equals(other$lote)) {
            return false;
        }
        BigDecimal this$valorPago = this.getValorPago();
        BigDecimal other$valorPago = other.getValorPago();
        if (this$valorPago == null ? other$valorPago != null : !((Object)this$valorPago).equals(other$valorPago)) {
            return false;
        }
        LocalDate this$dataMovimento = this.getDataMovimento();
        LocalDate other$dataMovimento = other.getDataMovimento();
        if (this$dataMovimento == null ? other$dataMovimento != null : !((Object)this$dataMovimento).equals(other$dataMovimento)) {
            return false;
        }
        BigDecimal this$valorJurosPagamento = this.getValorJurosPagamento();
        BigDecimal other$valorJurosPagamento = other.getValorJurosPagamento();
        if (this$valorJurosPagamento == null ? other$valorJurosPagamento != null : !((Object)this$valorJurosPagamento).equals(other$valorJurosPagamento)) {
            return false;
        }
        BigDecimal this$valorMultaPagamento = this.getValorMultaPagamento();
        BigDecimal other$valorMultaPagamento = other.getValorMultaPagamento();
        if (this$valorMultaPagamento == null ? other$valorMultaPagamento != null : !((Object)this$valorMultaPagamento).equals(other$valorMultaPagamento)) {
            return false;
        }
        BigDecimal this$valorCorrecaoPagamento = this.getValorCorrecaoPagamento();
        BigDecimal other$valorCorrecaoPagamento = other.getValorCorrecaoPagamento();
        if (this$valorCorrecaoPagamento == null ? other$valorCorrecaoPagamento != null : !((Object)this$valorCorrecaoPagamento).equals(other$valorCorrecaoPagamento)) {
            return false;
        }
        BigDecimal this$valorDescontoPagamento = this.getValorDescontoPagamento();
        BigDecimal other$valorDescontoPagamento = other.getValorDescontoPagamento();
        if (this$valorDescontoPagamento == null ? other$valorDescontoPagamento != null : !((Object)this$valorDescontoPagamento).equals(other$valorDescontoPagamento)) {
            return false;
        }
        Long this$numeroContrato = this.getNumeroContrato();
        Long other$numeroContrato = other.getNumeroContrato();
        if (this$numeroContrato == null ? other$numeroContrato != null : !((Object)this$numeroContrato).equals(other$numeroContrato)) {
            return false;
        }
        Long this$anoContrato = this.getAnoContrato();
        Long other$anoContrato = other.getAnoContrato();
        return !(this$anoContrato == null ? other$anoContrato != null : !((Object)this$anoContrato).equals(other$anoContrato));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ExtratoDebitoDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $nomeContribuinte = this.getNomeContribuinte();
        result = result * 59 + ($nomeContribuinte == null ? 43 : $nomeContribuinte.hashCode());
        String $cnpjCpfContribuinte = this.getCnpjCpfContribuinte();
        result = result * 59 + ($cnpjCpfContribuinte == null ? 43 : $cnpjCpfContribuinte.hashCode());
        String $numeroContribuinte = this.getNumeroContribuinte();
        result = result * 59 + ($numeroContribuinte == null ? 43 : $numeroContribuinte.hashCode());
        String $complementoContribuinte = this.getComplementoContribuinte();
        result = result * 59 + ($complementoContribuinte == null ? 43 : $complementoContribuinte.hashCode());
        String $logradouroContribuinte = this.getLogradouroContribuinte();
        result = result * 59 + ($logradouroContribuinte == null ? 43 : $logradouroContribuinte.hashCode());
        String $tipoLogradouroContribuinte = this.getTipoLogradouroContribuinte();
        result = result * 59 + ($tipoLogradouroContribuinte == null ? 43 : $tipoLogradouroContribuinte.hashCode());
        String $cidadeContribuinte = this.getCidadeContribuinte();
        result = result * 59 + ($cidadeContribuinte == null ? 43 : $cidadeContribuinte.hashCode());
        String $unidadeFederacaoContribuinte = this.getUnidadeFederacaoContribuinte();
        result = result * 59 + ($unidadeFederacaoContribuinte == null ? 43 : $unidadeFederacaoContribuinte.hashCode());
        String $tipoLogradouro = this.getTipoLogradouro();
        result = result * 59 + ($tipoLogradouro == null ? 43 : $tipoLogradouro.hashCode());
        String $logradouro = this.getLogradouro();
        result = result * 59 + ($logradouro == null ? 43 : $logradouro.hashCode());
        String $numero = this.getNumero();
        result = result * 59 + ($numero == null ? 43 : $numero.hashCode());
        String $complemento = this.getComplemento();
        result = result * 59 + ($complemento == null ? 43 : $complemento.hashCode());
        String $inscricaoCadastral = this.getInscricaoCadastral();
        result = result * 59 + ($inscricaoCadastral == null ? 43 : $inscricaoCadastral.hashCode());
        String $quadricula = this.getQuadricula();
        result = result * 59 + ($quadricula == null ? 43 : $quadricula.hashCode());
        String $distrito = this.getDistrito();
        result = result * 59 + ($distrito == null ? 43 : $distrito.hashCode());
        String $setor = this.getSetor();
        result = result * 59 + ($setor == null ? 43 : $setor.hashCode());
        String $quadra = this.getQuadra();
        result = result * 59 + ($quadra == null ? 43 : $quadra.hashCode());
        String $loteInscricaoCadastral = this.getLoteInscricaoCadastral();
        result = result * 59 + ($loteInscricaoCadastral == null ? 43 : $loteInscricaoCadastral.hashCode());
        String $unidade = this.getUnidade();
        result = result * 59 + ($unidade == null ? 43 : $unidade.hashCode());
        String $inscricaoCadastralComMascara = this.getInscricaoCadastralComMascara();
        result = result * 59 + ($inscricaoCadastralComMascara == null ? 43 : $inscricaoCadastralComMascara.hashCode());
        String $complementoLote = this.getComplementoLote();
        result = result * 59 + ($complementoLote == null ? 43 : $complementoLote.hashCode());
        String $situacaoDebitoSigla = this.getSituacaoDebitoSigla();
        result = result * 59 + ($situacaoDebitoSigla == null ? 43 : $situacaoDebitoSigla.hashCode());
        String $descricaoDivida = this.getDescricaoDivida();
        result = result * 59 + ($descricaoDivida == null ? 43 : $descricaoDivida.hashCode());
        Long $pagamento = this.getPagamento();
        result = result * 59 + ($pagamento == null ? 43 : ((Object)$pagamento).hashCode());
        Long $exercicioPagamento = this.getExercicioPagamento();
        result = result * 59 + ($exercicioPagamento == null ? 43 : ((Object)$exercicioPagamento).hashCode());
        Long $lote = this.getLote();
        result = result * 59 + ($lote == null ? 43 : ((Object)$lote).hashCode());
        BigDecimal $valorPago = this.getValorPago();
        result = result * 59 + ($valorPago == null ? 43 : ((Object)$valorPago).hashCode());
        LocalDate $dataMovimento = this.getDataMovimento();
        result = result * 59 + ($dataMovimento == null ? 43 : ((Object)$dataMovimento).hashCode());
        BigDecimal $valorJurosPagamento = this.getValorJurosPagamento();
        result = result * 59 + ($valorJurosPagamento == null ? 43 : ((Object)$valorJurosPagamento).hashCode());
        BigDecimal $valorMultaPagamento = this.getValorMultaPagamento();
        result = result * 59 + ($valorMultaPagamento == null ? 43 : ((Object)$valorMultaPagamento).hashCode());
        BigDecimal $valorCorrecaoPagamento = this.getValorCorrecaoPagamento();
        result = result * 59 + ($valorCorrecaoPagamento == null ? 43 : ((Object)$valorCorrecaoPagamento).hashCode());
        BigDecimal $valorDescontoPagamento = this.getValorDescontoPagamento();
        result = result * 59 + ($valorDescontoPagamento == null ? 43 : ((Object)$valorDescontoPagamento).hashCode());
        Long $numeroContrato = this.getNumeroContrato();
        result = result * 59 + ($numeroContrato == null ? 43 : ((Object)$numeroContrato).hashCode());
        Long $anoContrato = this.getAnoContrato();
        result = result * 59 + ($anoContrato == null ? 43 : ((Object)$anoContrato).hashCode());
        return result;
    }
}

