/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain.mobiliario;

import br.com.elotech.audit.reader.DiffRevisionIgnoreProperties;
import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.converter.BooleanToStringConverter;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.metamodel.annotation.Caption;
import br.com.elotech.core.metamodel.annotation.MetaModelIgnore;
import br.com.elotech.tributos.domain.SituacaoMobiliario;
import br.com.elotech.tributos.domain.mobiliario.CadastroMobiliario;
import br.com.elotech.tributos.dto.CadastroMobiliarioSituacaoDTO;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.time.LocalDate;
import java.util.Objects;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import lombok.Generated;
import org.hibernate.envers.Audited;
import org.hibernate.envers.RelationTargetAuditMode;

@Entity
@Table(name="TRIBMOBILIARIOSITUACAO")
@Audited
public class CadastroMobiliarioSituacao
implements EloEntity<Long> {
    @Id
    @Column(name="idkey")
    @EloSequence(applyOnMerge=true, sequenceName="S_TRIBMOBILIARIOSITUACAO_ID")
    private Long id;
    @Caption(value="Sequ\u00eancia")
    private Long sequencia;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="TRIBCADASTROGERAL_IDKEY")
    @JsonIgnore
    @MetaModelIgnore
    private CadastroMobiliario cadastroMobiliario;
    @Convert(converter=BooleanToStringConverter.class)
    @Caption(value="Atual")
    private Boolean atual = Boolean.FALSE;
    @ManyToOne
    @Caption(value="Situa\u00e7\u00e3o")
    @Audited(targetAuditMode=RelationTargetAuditMode.NOT_AUDITED)
    @DiffRevisionIgnoreProperties(value={"tipoSituacaoMobiliario"})
    private SituacaoMobiliario situacaoMobiliario;
    @Column(length=1000)
    @Caption(value="Observa\u00e7\u00e3o")
    private String observacao;
    @Caption(value="Data Altera\u00e7\u00e3o")
    private LocalDate dataAlteracao;
    @Caption(value="Data Inclus\u00e3o")
    private LocalDate dataInclusao;
    @Column(length=250)
    @Caption(value="Usu\u00e1rio Inclus\u00e3o")
    private String usuarioInclusao;
    @Caption(value="Exerc\u00edcio Processo")
    private Long exercicioProcesso;
    @Caption(value="C\u00f3digo Processo")
    private Long idProcesso;
    @Caption(value="Data Encerramento")
    private LocalDate dataEncerramento;

    public static CadastroMobiliarioSituacao createNewSituacao(CadastroMobiliarioSituacaoDTO dto, CadastroMobiliario cadastroMobiliario, String usuario) {
        CadastroMobiliarioSituacao cadastroMobiliarioSituacao = new CadastroMobiliarioSituacao();
        cadastroMobiliarioSituacao.setAtual(Boolean.TRUE);
        cadastroMobiliarioSituacao.setUsuarioInclusao(usuario);
        cadastroMobiliarioSituacao.setDataInclusao(LocalDate.now());
        cadastroMobiliarioSituacao.setDataAlteracao(LocalDate.now());
        if (Objects.nonNull(cadastroMobiliario)) {
            cadastroMobiliarioSituacao.setCadastroMobiliario(cadastroMobiliario);
            cadastroMobiliarioSituacao.setSequencia(Long.valueOf(cadastroMobiliario.getLastSequenciaSituacao() + 1L));
        }
        if (Objects.nonNull(dto)) {
            cadastroMobiliarioSituacao.setSituacaoMobiliario(dto.getSituacaoMobiliario());
            cadastroMobiliarioSituacao.setObservacao(dto.getObservacao());
            cadastroMobiliarioSituacao.setExercicioProcesso(dto.getExercicioProcesso());
            cadastroMobiliarioSituacao.setIdProcesso(dto.getIdProcesso());
            cadastroMobiliarioSituacao.setDataEncerramento(dto.getDataEncerramento());
        }
        return cadastroMobiliarioSituacao;
    }

    @Generated
    public CadastroMobiliarioSituacao() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Long getSequencia() {
        return this.sequencia;
    }

    @Generated
    public CadastroMobiliario getCadastroMobiliario() {
        return this.cadastroMobiliario;
    }

    @Generated
    public Boolean getAtual() {
        return this.atual;
    }

    @Generated
    public SituacaoMobiliario getSituacaoMobiliario() {
        return this.situacaoMobiliario;
    }

    @Generated
    public String getObservacao() {
        return this.observacao;
    }

    @Generated
    public LocalDate getDataAlteracao() {
        return this.dataAlteracao;
    }

    @Generated
    public LocalDate getDataInclusao() {
        return this.dataInclusao;
    }

    @Generated
    public String getUsuarioInclusao() {
        return this.usuarioInclusao;
    }

    @Generated
    public Long getExercicioProcesso() {
        return this.exercicioProcesso;
    }

    @Generated
    public Long getIdProcesso() {
        return this.idProcesso;
    }

    @Generated
    public LocalDate getDataEncerramento() {
        return this.dataEncerramento;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setSequencia(Long sequencia) {
        this.sequencia = sequencia;
    }

    @Generated
    public void setCadastroMobiliario(CadastroMobiliario cadastroMobiliario) {
        this.cadastroMobiliario = cadastroMobiliario;
    }

    @Generated
    public void setAtual(Boolean atual) {
        this.atual = atual;
    }

    @Generated
    public void setSituacaoMobiliario(SituacaoMobiliario situacaoMobiliario) {
        this.situacaoMobiliario = situacaoMobiliario;
    }

    @Generated
    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    @Generated
    public void setDataAlteracao(LocalDate dataAlteracao) {
        this.dataAlteracao = dataAlteracao;
    }

    @Generated
    public void setDataInclusao(LocalDate dataInclusao) {
        this.dataInclusao = dataInclusao;
    }

    @Generated
    public void setUsuarioInclusao(String usuarioInclusao) {
        this.usuarioInclusao = usuarioInclusao;
    }

    @Generated
    public void setExercicioProcesso(Long exercicioProcesso) {
        this.exercicioProcesso = exercicioProcesso;
    }

    @Generated
    public void setIdProcesso(Long idProcesso) {
        this.idProcesso = idProcesso;
    }

    @Generated
    public void setDataEncerramento(LocalDate dataEncerramento) {
        this.dataEncerramento = dataEncerramento;
    }

    @Generated
    public String toString() {
        return "CadastroMobiliarioSituacao(id=" + this.getId() + ", sequencia=" + this.getSequencia() + ", cadastroMobiliario=" + this.getCadastroMobiliario() + ", atual=" + this.getAtual() + ", situacaoMobiliario=" + this.getSituacaoMobiliario() + ", observacao=" + this.getObservacao() + ", dataAlteracao=" + this.getDataAlteracao() + ", dataInclusao=" + this.getDataInclusao() + ", usuarioInclusao=" + this.getUsuarioInclusao() + ", exercicioProcesso=" + this.getExercicioProcesso() + ", idProcesso=" + this.getIdProcesso() + ", dataEncerramento=" + this.getDataEncerramento() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CadastroMobiliarioSituacao)) {
            return false;
        }
        CadastroMobiliarioSituacao other = (CadastroMobiliarioSituacao)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CadastroMobiliarioSituacao;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }
}

