/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain.integracaocontabil;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.metamodel.annotation.MetaModelIgnore;
import br.com.elotech.tributos.domain.ContaBancaria;
import br.com.elotech.tributos.domain.integracaocontabil.LoteItemIntegracaoContabil;
import br.com.elotech.tributos.domain.pagamento.PagamentoLote;
import br.com.elotech.tributos.dto.integracaocontabil.LoteIntegracaoContabilDTO;
import br.com.elotech.tributos.dto.integracaocontabil.SituacaoIntegracaoContabil;
import br.com.elotech.tributos.dto.integracaocontabil.TipoMovimento;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import lombok.Generated;

@Entity
@Table(name="loteintegracaocontabil")
public class LoteIntegracaoContabil
implements EloEntity<Long> {
    @Id
    @EloSequence(sequenceName="seq_loteintegracaocontabil")
    private Long id;
    @Enumerated(value=EnumType.STRING)
    private SituacaoIntegracaoContabil situacaoIntegracaoContabil;
    private LocalDate dataLote;
    @Enumerated(value=EnumType.STRING)
    private TipoMovimento tipoLote;
    @NotNull
    private Long entidade;
    @NotNull
    private Long exercicio;
    private Long lote;
    @MetaModelIgnore
    @JsonIgnore
    @OneToOne(fetch=FetchType.LAZY)
    @JoinColumns(value={@JoinColumn(name="entidade", referencedColumnName="entidade", insertable=false, updatable=false), @JoinColumn(name="exercicio", referencedColumnName="exercicio", insertable=false, updatable=false), @JoinColumn(name="lote", referencedColumnName="lote", insertable=false, updatable=false)})
    private PagamentoLote pagamentoLote;
    @ManyToOne
    @MetaModelIgnore
    @JsonIgnore
    @JoinColumn(name="idcontabancaria", referencedColumnName="id")
    private ContaBancaria contaBancaria;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.LAZY)
    @JoinColumn(name="idlote", updatable=false, nullable=false)
    private List<LoteItemIntegracaoContabil> loteItens = new ArrayList();

    public LoteIntegracaoContabilDTO toDTO() {
        LoteIntegracaoContabilDTO loteIntegracaoContabilDTO = new LoteIntegracaoContabilDTO();
        loteIntegracaoContabilDTO.setId(this.getId());
        loteIntegracaoContabilDTO.setData(this.getDataLote());
        loteIntegracaoContabilDTO.setEntidade(this.getEntidade());
        loteIntegracaoContabilDTO.setExercicio(this.getExercicio());
        loteIntegracaoContabilDTO.setSituacaoIntegracaoContabil(this.situacaoIntegracaoContabil);
        loteIntegracaoContabilDTO.setTipoLote(this.tipoLote);
        loteIntegracaoContabilDTO.setValor(this.getTotalValor());
        loteIntegracaoContabilDTO.setValorDeducao(this.getTotalValorDeducao());
        if (Objects.nonNull(this.getContaBancaria())) {
            loteIntegracaoContabilDTO.setContaBancaria(this.getContaBancaria().getLocalContabil());
            loteIntegracaoContabilDTO.setConta(this.getContaBancaria().getConta());
            loteIntegracaoContabilDTO.setContaDescricao(this.getContaBancaria().getDescricao());
        }
        if (Objects.nonNull(this.getPagamentoLote())) {
            loteIntegracaoContabilDTO.setNumero(this.getPagamentoLote().getId().getLote());
            loteIntegracaoContabilDTO.setDescricao(this.getPagamentoLote().getNomeArquivo());
            Optional.ofNullable(this.getPagamentoLote().getTipo()).ifPresent(tipo -> loteIntegracaoContabilDTO.setTipoPagamento(tipo.getDescricao()));
        }
        return loteIntegracaoContabilDTO;
    }

    public boolean getPagamentoIntegradoContabilidade() {
        return Objects.nonNull(this.getPagamentoLote()) && !SituacaoIntegracaoContabil.AGUARDANDO_CONTABILIZACAO.equals((Object)this.getSituacaoIntegracaoContabil()) && !SituacaoIntegracaoContabil.ESTORNADO_CONTABILIDADE.equals((Object)this.getSituacaoIntegracaoContabil());
    }

    @JsonIgnore
    private BigDecimal getTotalValor() {
        return this.loteItens.stream().map(LoteItemIntegracaoContabil::getValorTributo).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    @JsonIgnore
    private BigDecimal getTotalValorDeducao() {
        return this.loteItens.stream().map(LoteItemIntegracaoContabil::getValorDeducao).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LoteIntegracaoContabil)) {
            return false;
        }
        LoteIntegracaoContabil other = (LoteIntegracaoContabil)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LoteIntegracaoContabil;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }

    @Generated
    public LoteIntegracaoContabil() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public SituacaoIntegracaoContabil getSituacaoIntegracaoContabil() {
        return this.situacaoIntegracaoContabil;
    }

    @Generated
    public LocalDate getDataLote() {
        return this.dataLote;
    }

    @Generated
    public TipoMovimento getTipoLote() {
        return this.tipoLote;
    }

    @Generated
    public Long getEntidade() {
        return this.entidade;
    }

    @Generated
    public Long getExercicio() {
        return this.exercicio;
    }

    @Generated
    public Long getLote() {
        return this.lote;
    }

    @Generated
    public PagamentoLote getPagamentoLote() {
        return this.pagamentoLote;
    }

    @Generated
    public ContaBancaria getContaBancaria() {
        return this.contaBancaria;
    }

    @Generated
    public List<LoteItemIntegracaoContabil> getLoteItens() {
        return this.loteItens;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setSituacaoIntegracaoContabil(SituacaoIntegracaoContabil situacaoIntegracaoContabil) {
        this.situacaoIntegracaoContabil = situacaoIntegracaoContabil;
    }

    @Generated
    public void setDataLote(LocalDate dataLote) {
        this.dataLote = dataLote;
    }

    @Generated
    public void setTipoLote(TipoMovimento tipoLote) {
        this.tipoLote = tipoLote;
    }

    @Generated
    public void setEntidade(Long entidade) {
        this.entidade = entidade;
    }

    @Generated
    public void setExercicio(Long exercicio) {
        this.exercicio = exercicio;
    }

    @Generated
    public void setLote(Long lote) {
        this.lote = lote;
    }

    @Generated
    public void setPagamentoLote(PagamentoLote pagamentoLote) {
        this.pagamentoLote = pagamentoLote;
    }

    @Generated
    public void setContaBancaria(ContaBancaria contaBancaria) {
        this.contaBancaria = contaBancaria;
    }

    @Generated
    public void setLoteItens(List<LoteItemIntegracaoContabil> loteItens) {
        this.loteItens = loteItens;
    }

    @Generated
    public String toString() {
        return "LoteIntegracaoContabil(id=" + this.getId() + ", situacaoIntegracaoContabil=" + this.getSituacaoIntegracaoContabil() + ", dataLote=" + this.getDataLote() + ", tipoLote=" + this.getTipoLote() + ", entidade=" + this.getEntidade() + ", exercicio=" + this.getExercicio() + ", lote=" + this.getLote() + ", pagamentoLote=" + this.getPagamentoLote() + ", contaBancaria=" + this.getContaBancaria() + ", loteItens=" + this.getLoteItens() + ")";
    }
}

