/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain.acrescimo;

import br.com.elotech.core.enumerable.EnumConverter;
import br.com.elotech.core.enumerable.EnumValues;
import br.com.elotech.core.utils.EnumUtils;
import br.com.elotech.tributos.service.acrescimo.calculo.correcao.CalculoCorrecao;
import br.com.elotech.tributos.service.acrescimo.calculo.correcao.CalculoCorrecaoAtual;
import br.com.elotech.tributos.service.acrescimo.calculo.correcao.CalculoCorrecaoProgressivo;
import br.com.elotech.tributos.service.acrescimo.calculo.correcao.CalculoCorrecaoVariacao;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum FormaCalculo implements EnumConverter<FormaCalculo, String>
{
    PROGRESSIVO("P", "Progressivo", (CalculoCorrecao)new CalculoCorrecaoProgressivo()),
    VARIACAO("V", "Varia\u00e7\u00e3o", (CalculoCorrecao)new CalculoCorrecaoVariacao()),
    VALOR_ATUAL("A", "Valor Atual", (CalculoCorrecao)new CalculoCorrecaoAtual());

    private final String codigo;
    private final String descricao;
    private final CalculoCorrecao calculoCorrecao;
    public static final EnumValues<FormaCalculo, String> ENUM_VALUES;

    private FormaCalculo(String codigo, String descricao, CalculoCorrecao calculoCorrecao) {
        this.codigo = codigo;
        this.descricao = descricao;
        this.calculoCorrecao = calculoCorrecao;
    }

    @JsonCreator
    public static FormaCalculo fromValue(String codigo) {
        return (FormaCalculo)ENUM_VALUES.getEnum((Object)codigo);
    }

    @JsonValue
    public String getValue() {
        return this.codigo;
    }

    public String getCodigo() {
        return this.codigo;
    }

    public String getDescricao() {
        return this.descricao;
    }

    public CalculoCorrecao getCalculoCorrecao() {
        return this.calculoCorrecao;
    }

    static {
        ENUM_VALUES = EnumUtils.getEnumValuesMap(FormaCalculo.class);
    }
}

