/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.converter.BooleanToStringConverter;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.metamodel.annotation.Caption;
import br.com.elotech.core.metamodel.annotation.MetaModelIgnore;
import br.com.elotech.tributos.domain.Loteamento;
import br.com.elotech.tributos.domain.Setor;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.JoinColumnOrFormula;
import org.hibernate.annotations.JoinColumnsOrFormulas;
import org.hibernate.annotations.JoinFormula;
import org.hibernate.search.annotations.Analyze;
import org.hibernate.search.annotations.Facet;
import org.hibernate.search.annotations.Field;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="TribSetorQuadra")
@DynamicInsert
@DynamicUpdate
public class SetorQuadra
implements EloEntity<Long>,
Serializable {
    @Id
    @Column(name="idkey")
    @EloSequence(applyOnMerge=true, sequenceName="S_TRIBSETORQUADRA_ID")
    private Long id;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="TRIBSETOR_IDKEY", referencedColumnName="idkey", insertable=false, updatable=false)
    @JsonIgnoreProperties(value={"quadras"})
    @MetaModelIgnore
    private Setor setor;
    @Field(analyze=Analyze.NO)
    @Facet
    @Column
    @NotNull
    @Length(max=20)
    @Caption(value="Quadra")
    private @NotNull @Length(max=20) String quadra;
    @Convert(converter=BooleanToStringConverter.class)
    @Caption(value="Aprovada")
    private Boolean aprovada = Boolean.FALSE;
    @Length(max=15)
    @Caption(value="Quadra Fiscal")
    private @Length(max=15) String quadraFiscal;
    @Column(name="distrito")
    @Caption(value="C\u00f3digo do distrito")
    private String codigoDistrito;
    @Column(name="setor")
    @Caption(value="C\u00f3digo do setor")
    private String codigoSetor;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumnsOrFormulas(value={@JoinColumnOrFormula(formula=@JoinFormula(value="TRIBSETOR_IDKEY", referencedColumnName="TRIBSETOR_IDKEY")), @JoinColumnOrFormula(column=@JoinColumn(name="loteamento", referencedColumnName="loteamento"))})
    @Caption(value="Loteamento")
    private Loteamento loteamento;
    @Length(max=500)
    @Caption(value="Observa\u00e7\u00e3o")
    private @Length(max=500) String observacao;

    @Generated
    public SetorQuadra() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Setor getSetor() {
        return this.setor;
    }

    @Generated
    public String getQuadra() {
        return this.quadra;
    }

    @Generated
    public Boolean getAprovada() {
        return this.aprovada;
    }

    @Generated
    public String getQuadraFiscal() {
        return this.quadraFiscal;
    }

    @Generated
    public String getCodigoDistrito() {
        return this.codigoDistrito;
    }

    @Generated
    public String getCodigoSetor() {
        return this.codigoSetor;
    }

    @Generated
    public Loteamento getLoteamento() {
        return this.loteamento;
    }

    @Generated
    public String getObservacao() {
        return this.observacao;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setSetor(Setor setor) {
        this.setor = setor;
    }

    @Generated
    public void setQuadra(String quadra) {
        this.quadra = quadra;
    }

    @Generated
    public void setAprovada(Boolean aprovada) {
        this.aprovada = aprovada;
    }

    @Generated
    public void setQuadraFiscal(String quadraFiscal) {
        this.quadraFiscal = quadraFiscal;
    }

    @Generated
    public void setCodigoDistrito(String codigoDistrito) {
        this.codigoDistrito = codigoDistrito;
    }

    @Generated
    public void setCodigoSetor(String codigoSetor) {
        this.codigoSetor = codigoSetor;
    }

    @Generated
    public void setLoteamento(Loteamento loteamento) {
        this.loteamento = loteamento;
    }

    @Generated
    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    @Generated
    public String toString() {
        return "SetorQuadra(id=" + this.getId() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SetorQuadra)) {
            return false;
        }
        SetorQuadra other = (SetorQuadra)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SetorQuadra;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }
}

