/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.metamodel.annotation.Caption;
import br.com.elotech.tributos.domain.ServicoBaseCalculo;
import br.com.elotech.tributos.domain.ServicoLocalPrestacao;
import br.com.elotech.tributos.domain.ServicoPeriodo;
import br.com.elotech.tributos.domain.ServicoTipo;
import br.com.elotech.tributos.dto.ServicoDTO;
import java.math.BigDecimal;
import java.time.LocalDate;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import lombok.Generated;

@Entity
@Table(name="TRIBSERVICO")
public class Servico
implements EloEntity<Long> {
    @Id
    @Column(name="idkey")
    @EloSequence(sequenceName="S_TRIBSERVICO_ID")
    private Long id;
    private Long entidade;
    private Long exercicio;
    private Long servico;
    @Column(length=600)
    @Caption(value="Descri\u00e7\u00e3o")
    private String descricao;
    private BigDecimal aliquota = BigDecimal.ZERO;
    @Column(length=1)
    @Caption(value="Per\u00edodo")
    private ServicoPeriodo periodo;
    @Column(length=1)
    @Caption(value="Base C\u00e1lculo")
    private ServicoBaseCalculo baseCalculo;
    private BigDecimal aliquotaHomologada = BigDecimal.ZERO;
    private Long codigoLc116;
    private LocalDate dataLimite;
    @Column(length=1)
    @Caption(value="Tipo Servi\u00e7o")
    private ServicoTipo tipoServico;
    @Column(length=1)
    @Caption(value="Local Presta\u00e7\u00e3o")
    private ServicoLocalPrestacao localPrestacao;
    @Caption(value="Constru\u00e7\u00e3o Civil")
    private Boolean construcaoCivil = Boolean.FALSE;
    private Long idServico;
    @Caption(value="Vetado")
    private Boolean vetado = Boolean.FALSE;
    @Caption(value="Permite Dedu\u00e7\u00e3o")
    private Boolean permiteDeducao = Boolean.FALSE;
    @Caption(value="Permite Exporta\u00e7\u00e3o")
    private Boolean permiteExportacao = Boolean.FALSE;
    @Caption(value="Ret\u00e9m ISS")
    private Boolean retemISS = Boolean.FALSE;
    private Boolean ativo = Boolean.TRUE;

    public static Servico from(ServicoDTO dto) {
        Servico servico = new Servico();
        servico.setId(dto.getId());
        servico.setEntidade(dto.getEntidade());
        servico.setExercicio(dto.getExercicio());
        servico.setServico(dto.getServico());
        servico.setDescricao(dto.getDescricao());
        return servico;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Servico)) {
            return false;
        }
        Servico other = (Servico)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$entidade = this.getEntidade();
        Long other$entidade = other.getEntidade();
        if (this$entidade == null ? other$entidade != null : !((Object)this$entidade).equals(other$entidade)) {
            return false;
        }
        Long this$exercicio = this.getExercicio();
        Long other$exercicio = other.getExercicio();
        if (this$exercicio == null ? other$exercicio != null : !((Object)this$exercicio).equals(other$exercicio)) {
            return false;
        }
        Long this$servico = this.getServico();
        Long other$servico = other.getServico();
        if (this$servico == null ? other$servico != null : !((Object)this$servico).equals(other$servico)) {
            return false;
        }
        String this$descricao = this.getDescricao();
        String other$descricao = other.getDescricao();
        if (this$descricao == null ? other$descricao != null : !this$descricao.equals(other$descricao)) {
            return false;
        }
        BigDecimal this$aliquota = this.getAliquota();
        BigDecimal other$aliquota = other.getAliquota();
        if (this$aliquota == null ? other$aliquota != null : !((Object)this$aliquota).equals(other$aliquota)) {
            return false;
        }
        ServicoPeriodo this$periodo = this.getPeriodo();
        ServicoPeriodo other$periodo = other.getPeriodo();
        if (this$periodo == null ? other$periodo != null : !this$periodo.equals(other$periodo)) {
            return false;
        }
        ServicoBaseCalculo this$baseCalculo = this.getBaseCalculo();
        ServicoBaseCalculo other$baseCalculo = other.getBaseCalculo();
        if (this$baseCalculo == null ? other$baseCalculo != null : !this$baseCalculo.equals(other$baseCalculo)) {
            return false;
        }
        BigDecimal this$aliquotaHomologada = this.getAliquotaHomologada();
        BigDecimal other$aliquotaHomologada = other.getAliquotaHomologada();
        if (this$aliquotaHomologada == null ? other$aliquotaHomologada != null : !((Object)this$aliquotaHomologada).equals(other$aliquotaHomologada)) {
            return false;
        }
        Long this$codigoLc116 = this.getCodigoLc116();
        Long other$codigoLc116 = other.getCodigoLc116();
        if (this$codigoLc116 == null ? other$codigoLc116 != null : !((Object)this$codigoLc116).equals(other$codigoLc116)) {
            return false;
        }
        LocalDate this$dataLimite = this.getDataLimite();
        LocalDate other$dataLimite = other.getDataLimite();
        if (this$dataLimite == null ? other$dataLimite != null : !((Object)this$dataLimite).equals(other$dataLimite)) {
            return false;
        }
        ServicoTipo this$tipoServico = this.getTipoServico();
        ServicoTipo other$tipoServico = other.getTipoServico();
        if (this$tipoServico == null ? other$tipoServico != null : !this$tipoServico.equals(other$tipoServico)) {
            return false;
        }
        ServicoLocalPrestacao this$localPrestacao = this.getLocalPrestacao();
        ServicoLocalPrestacao other$localPrestacao = other.getLocalPrestacao();
        if (this$localPrestacao == null ? other$localPrestacao != null : !this$localPrestacao.equals(other$localPrestacao)) {
            return false;
        }
        Boolean this$construcaoCivil = this.getConstrucaoCivil();
        Boolean other$construcaoCivil = other.getConstrucaoCivil();
        if (this$construcaoCivil == null ? other$construcaoCivil != null : !((Object)this$construcaoCivil).equals(other$construcaoCivil)) {
            return false;
        }
        Long this$idServico = this.getIdServico();
        Long other$idServico = other.getIdServico();
        if (this$idServico == null ? other$idServico != null : !((Object)this$idServico).equals(other$idServico)) {
            return false;
        }
        Boolean this$vetado = this.getVetado();
        Boolean other$vetado = other.getVetado();
        if (this$vetado == null ? other$vetado != null : !((Object)this$vetado).equals(other$vetado)) {
            return false;
        }
        Boolean this$permiteDeducao = this.getPermiteDeducao();
        Boolean other$permiteDeducao = other.getPermiteDeducao();
        if (this$permiteDeducao == null ? other$permiteDeducao != null : !((Object)this$permiteDeducao).equals(other$permiteDeducao)) {
            return false;
        }
        Boolean this$permiteExportacao = this.getPermiteExportacao();
        Boolean other$permiteExportacao = other.getPermiteExportacao();
        if (this$permiteExportacao == null ? other$permiteExportacao != null : !((Object)this$permiteExportacao).equals(other$permiteExportacao)) {
            return false;
        }
        Boolean this$retemISS = this.getRetemISS();
        Boolean other$retemISS = other.getRetemISS();
        if (this$retemISS == null ? other$retemISS != null : !((Object)this$retemISS).equals(other$retemISS)) {
            return false;
        }
        Boolean this$ativo = this.getAtivo();
        Boolean other$ativo = other.getAtivo();
        return !(this$ativo == null ? other$ativo != null : !((Object)this$ativo).equals(other$ativo));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Servico;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $entidade = this.getEntidade();
        result = result * 59 + ($entidade == null ? 43 : ((Object)$entidade).hashCode());
        Long $exercicio = this.getExercicio();
        result = result * 59 + ($exercicio == null ? 43 : ((Object)$exercicio).hashCode());
        Long $servico = this.getServico();
        result = result * 59 + ($servico == null ? 43 : ((Object)$servico).hashCode());
        String $descricao = this.getDescricao();
        result = result * 59 + ($descricao == null ? 43 : $descricao.hashCode());
        BigDecimal $aliquota = this.getAliquota();
        result = result * 59 + ($aliquota == null ? 43 : ((Object)$aliquota).hashCode());
        ServicoPeriodo $periodo = this.getPeriodo();
        result = result * 59 + ($periodo == null ? 43 : $periodo.hashCode());
        ServicoBaseCalculo $baseCalculo = this.getBaseCalculo();
        result = result * 59 + ($baseCalculo == null ? 43 : $baseCalculo.hashCode());
        BigDecimal $aliquotaHomologada = this.getAliquotaHomologada();
        result = result * 59 + ($aliquotaHomologada == null ? 43 : ((Object)$aliquotaHomologada).hashCode());
        Long $codigoLc116 = this.getCodigoLc116();
        result = result * 59 + ($codigoLc116 == null ? 43 : ((Object)$codigoLc116).hashCode());
        LocalDate $dataLimite = this.getDataLimite();
        result = result * 59 + ($dataLimite == null ? 43 : ((Object)$dataLimite).hashCode());
        ServicoTipo $tipoServico = this.getTipoServico();
        result = result * 59 + ($tipoServico == null ? 43 : $tipoServico.hashCode());
        ServicoLocalPrestacao $localPrestacao = this.getLocalPrestacao();
        result = result * 59 + ($localPrestacao == null ? 43 : $localPrestacao.hashCode());
        Boolean $construcaoCivil = this.getConstrucaoCivil();
        result = result * 59 + ($construcaoCivil == null ? 43 : ((Object)$construcaoCivil).hashCode());
        Long $idServico = this.getIdServico();
        result = result * 59 + ($idServico == null ? 43 : ((Object)$idServico).hashCode());
        Boolean $vetado = this.getVetado();
        result = result * 59 + ($vetado == null ? 43 : ((Object)$vetado).hashCode());
        Boolean $permiteDeducao = this.getPermiteDeducao();
        result = result * 59 + ($permiteDeducao == null ? 43 : ((Object)$permiteDeducao).hashCode());
        Boolean $permiteExportacao = this.getPermiteExportacao();
        result = result * 59 + ($permiteExportacao == null ? 43 : ((Object)$permiteExportacao).hashCode());
        Boolean $retemISS = this.getRetemISS();
        result = result * 59 + ($retemISS == null ? 43 : ((Object)$retemISS).hashCode());
        Boolean $ativo = this.getAtivo();
        result = result * 59 + ($ativo == null ? 43 : ((Object)$ativo).hashCode());
        return result;
    }

    @Generated
    public Servico() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Long getEntidade() {
        return this.entidade;
    }

    @Generated
    public Long getExercicio() {
        return this.exercicio;
    }

    @Generated
    public Long getServico() {
        return this.servico;
    }

    @Generated
    public String getDescricao() {
        return this.descricao;
    }

    @Generated
    public BigDecimal getAliquota() {
        return this.aliquota;
    }

    @Generated
    public ServicoPeriodo getPeriodo() {
        return this.periodo;
    }

    @Generated
    public ServicoBaseCalculo getBaseCalculo() {
        return this.baseCalculo;
    }

    @Generated
    public BigDecimal getAliquotaHomologada() {
        return this.aliquotaHomologada;
    }

    @Generated
    public Long getCodigoLc116() {
        return this.codigoLc116;
    }

    @Generated
    public LocalDate getDataLimite() {
        return this.dataLimite;
    }

    @Generated
    public ServicoTipo getTipoServico() {
        return this.tipoServico;
    }

    @Generated
    public ServicoLocalPrestacao getLocalPrestacao() {
        return this.localPrestacao;
    }

    @Generated
    public Boolean getConstrucaoCivil() {
        return this.construcaoCivil;
    }

    @Generated
    public Long getIdServico() {
        return this.idServico;
    }

    @Generated
    public Boolean getVetado() {
        return this.vetado;
    }

    @Generated
    public Boolean getPermiteDeducao() {
        return this.permiteDeducao;
    }

    @Generated
    public Boolean getPermiteExportacao() {
        return this.permiteExportacao;
    }

    @Generated
    public Boolean getRetemISS() {
        return this.retemISS;
    }

    @Generated
    public Boolean getAtivo() {
        return this.ativo;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setEntidade(Long entidade) {
        this.entidade = entidade;
    }

    @Generated
    public void setExercicio(Long exercicio) {
        this.exercicio = exercicio;
    }

    @Generated
    public void setServico(Long servico) {
        this.servico = servico;
    }

    @Generated
    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @Generated
    public void setAliquota(BigDecimal aliquota) {
        this.aliquota = aliquota;
    }

    @Generated
    public void setPeriodo(ServicoPeriodo periodo) {
        this.periodo = periodo;
    }

    @Generated
    public void setBaseCalculo(ServicoBaseCalculo baseCalculo) {
        this.baseCalculo = baseCalculo;
    }

    @Generated
    public void setAliquotaHomologada(BigDecimal aliquotaHomologada) {
        this.aliquotaHomologada = aliquotaHomologada;
    }

    @Generated
    public void setCodigoLc116(Long codigoLc116) {
        this.codigoLc116 = codigoLc116;
    }

    @Generated
    public void setDataLimite(LocalDate dataLimite) {
        this.dataLimite = dataLimite;
    }

    @Generated
    public void setTipoServico(ServicoTipo tipoServico) {
        this.tipoServico = tipoServico;
    }

    @Generated
    public void setLocalPrestacao(ServicoLocalPrestacao localPrestacao) {
        this.localPrestacao = localPrestacao;
    }

    @Generated
    public void setConstrucaoCivil(Boolean construcaoCivil) {
        this.construcaoCivil = construcaoCivil;
    }

    @Generated
    public void setIdServico(Long idServico) {
        this.idServico = idServico;
    }

    @Generated
    public void setVetado(Boolean vetado) {
        this.vetado = vetado;
    }

    @Generated
    public void setPermiteDeducao(Boolean permiteDeducao) {
        this.permiteDeducao = permiteDeducao;
    }

    @Generated
    public void setPermiteExportacao(Boolean permiteExportacao) {
        this.permiteExportacao = permiteExportacao;
    }

    @Generated
    public void setRetemISS(Boolean retemISS) {
        this.retemISS = retemISS;
    }

    @Generated
    public void setAtivo(Boolean ativo) {
        this.ativo = ativo;
    }

    @Generated
    public String toString() {
        return "Servico(id=" + this.getId() + ", entidade=" + this.getEntidade() + ", exercicio=" + this.getExercicio() + ", servico=" + this.getServico() + ", descricao=" + this.getDescricao() + ", aliquota=" + this.getAliquota() + ", periodo=" + this.getPeriodo() + ", baseCalculo=" + this.getBaseCalculo() + ", aliquotaHomologada=" + this.getAliquotaHomologada() + ", codigoLc116=" + this.getCodigoLc116() + ", dataLimite=" + this.getDataLimite() + ", tipoServico=" + this.getTipoServico() + ", localPrestacao=" + this.getLocalPrestacao() + ", construcaoCivil=" + this.getConstrucaoCivil() + ", idServico=" + this.getIdServico() + ", vetado=" + this.getVetado() + ", permiteDeducao=" + this.getPermiteDeducao() + ", permiteExportacao=" + this.getPermiteExportacao() + ", retemISS=" + this.getRetemISS() + ", ativo=" + this.getAtivo() + ")";
    }
}

