/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.converter.BooleanToStringConverter;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.converter.TipoCadastroConverter;
import br.com.elotech.tributos.domain.ImobiliarioItbiObs;
import br.com.elotech.tributos.domain.ImobiliarioItbiObsId;
import br.com.elotech.tributos.domain.ImobiliarioItbiSegmento;
import br.com.elotech.tributos.domain.ImobiliarioItbiSegmentoId;
import br.com.elotech.tributos.domain.ParametroItbi;
import br.com.elotech.tributos.domain.Pessoa;
import br.com.elotech.tributos.domain.ProprietarioItbi;
import br.com.elotech.tributos.domain.ProprietarioItbiId;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.domain.TipoItbi;
import br.com.elotech.tributos.domain.TipoProprietarioItbi;
import br.com.elotech.tributos.domain.TipoSituacaoImobiliarioItbi;
import br.com.elotech.tributos.dto.itbi.ImobiliarioItbiDTO;
import br.com.elotech.tributos.dto.itbi.ImobiliarioItbiSegmentoDTO;
import br.com.elotech.tributos.exception.ProprietarioPrincipalItbiException;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.hibernate.validator.constraints.Length;
import org.springframework.http.HttpStatus;

@Entity
@Table(name="TRIBIMOBILIARIOITBI")
public class ImobiliarioItbi
implements EloEntity<Long>,
Serializable {
    @Id
    @EloSequence(sequenceName="s05imobiliarioitbi")
    @Column(name="idsequencia")
    @JsonProperty(value="idItbi")
    private Long id;
    private Long entidade;
    private Long exercicio;
    @NotNull
    private TipoCadastro tipoCadastro;
    @NotNull
    private Long cadastroGeral;
    private Long guiaRecolhimento;
    private Long subDivida;
    private LocalDate dataLancamento;
    private LocalDate dataSituacao;
    @Length(max=250)
    private @Length(max=250) String usuario;
    private LocalDate dataInclusao;
    @Column(name="transferido")
    private TipoSituacaoImobiliarioItbi situacao;
    private LocalDate dataVencimento;
    private BigDecimal valor = BigDecimal.ZERO;
    private BigDecimal valorFinanciado = BigDecimal.ZERO;
    private BigDecimal aliquota = BigDecimal.ZERO;
    private BigDecimal aliquotaFinanciado = BigDecimal.ZERO;
    private BigDecimal baseCalculo = BigDecimal.ZERO;
    private BigDecimal baseCalculoFinanciado = BigDecimal.ZERO;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean todasUnidades = Boolean.FALSE;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean debitoGerado = Boolean.FALSE;
    @ManyToOne
    @JoinColumn(name="tipoitbi")
    private TipoItbi tipoItbi;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean somenteTerreno = Boolean.FALSE;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean parcelado = Boolean.FALSE;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean transfereAutomatico = Boolean.FALSE;
    @NotNull
    private Long codigoItbi;
    @ManyToOne
    @JoinColumn(name="parametroitbi")
    private ParametroItbi parametroItbi;
    @JsonIgnore
    @OneToMany(mappedBy="id.itbi", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<ImobiliarioItbiObs> observacoes = new ArrayList();
    @JsonIgnore
    @OneToMany(mappedBy="id.itbi", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<ProprietarioItbi> proprietarios = new ArrayList();
    @JsonIgnore
    @OneToMany(mappedBy="id.itbi", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<ImobiliarioItbiSegmento> segmentos = new ArrayList();

    public void addObservacao(ImobiliarioItbiObs obs) {
        ImobiliarioItbiObsId idObs = new ImobiliarioItbiObsId();
        idObs.setItbi(this);
        idObs.setSequencia(Long.valueOf(this.observacoes.size() + 1));
        obs.setId(idObs);
        this.observacoes.add(obs);
    }

    public void addProprietario(ProprietarioItbi proprietario, Pessoa pessoa, TipoProprietarioItbi tipoProprietarioItbi) {
        ProprietarioItbiId idProprietario = new ProprietarioItbiId();
        idProprietario.setItbi(this);
        idProprietario.setPessoa(pessoa);
        idProprietario.setTipoProprietarioItbi(tipoProprietarioItbi);
        proprietario.setId(idProprietario);
        this.proprietarios.add(proprietario);
    }

    public void addSegmento(ImobiliarioItbiSegmento segmento) {
        ImobiliarioItbiSegmentoId idSegmento = new ImobiliarioItbiSegmentoId();
        idSegmento.setItbi(this);
        idSegmento.setSequencia(Integer.valueOf(this.segmentos.size() + 1));
        segmento.setId(idSegmento);
        this.segmentos.add(segmento);
    }

    public void addSegmento(ImobiliarioItbiSegmentoDTO segmentoDTO) {
        ImobiliarioItbiSegmentoId idSegmento = new ImobiliarioItbiSegmentoId();
        idSegmento.setItbi(this);
        idSegmento.setSequencia(segmentoDTO.getSequencia());
        ImobiliarioItbiSegmento segmento = new ImobiliarioItbiSegmento();
        segmento.setAreaConstruida(segmentoDTO.getAreaConstruida());
        segmento.setAreaItbi(segmentoDTO.getAreaItbi());
        segmento.setTipoSegmento(segmentoDTO.getTipoSegmento());
        segmento.setValorConstrucao(segmentoDTO.getValorConstrucao());
        segmento.setId(idSegmento);
        this.segmentos.add(segmento);
    }

    public static ImobiliarioItbi from(ImobiliarioItbiDTO dto) {
        TipoCadastroConverter converter = new TipoCadastroConverter();
        ImobiliarioItbi itbi = new ImobiliarioItbi();
        itbi.setTipoCadastro(converter.convertToEntityAttribute(dto.getTipoCadastro()));
        itbi.setCadastroGeral(dto.getCadastroGeral());
        itbi.setTransfereAutomatico(dto.getTransfereAutomatico());
        itbi.setValor(dto.getValor());
        itbi.setValorFinanciado(dto.getValorFinanciado());
        itbi.setAliquota(dto.getAliquota());
        itbi.setAliquotaFinanciado(dto.getAliquotaFinanciado());
        itbi.setBaseCalculo(dto.getBaseCalculo());
        itbi.setBaseCalculoFinanciado(dto.getBaseCalculoFinanciado());
        itbi.setUsuario(dto.getUsuario());
        dto.getObservacoes().stream().map(ImobiliarioItbiObs::new).forEach(arg_0 -> itbi.addObservacao(arg_0));
        return itbi;
    }

    public void validar() {
        if (Objects.isNull(this.situacao)) {
            throw new EloValidationException("O Tipo de situa\u00e7\u00e3o de ITBI n\u00e3o pode estar nulo");
        }
        if (this.proprietarios.stream().filter(ProprietarioItbi::isAtual).noneMatch(ProprietarioItbi::getPrincipal)) {
            throw new ProprietarioPrincipalItbiException(HttpStatus.BAD_REQUEST, "Necess\u00e1rio informar um novo propriet\u00e1rio principal.");
        }
    }

    @JsonIgnore
    public ProprietarioItbi getCompradorPrincipal() {
        return this.proprietarios.stream().filter(proprietarioItbi -> TipoProprietarioItbi.COMPRADOR.equals((Object)proprietarioItbi.getId().getTipoProprietarioItbi()) && Boolean.TRUE.equals(proprietarioItbi.getPrincipal())).findFirst().orElse(null);
    }

    @Generated
    public ImobiliarioItbi() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Long getEntidade() {
        return this.entidade;
    }

    @Generated
    public Long getExercicio() {
        return this.exercicio;
    }

    @Generated
    public TipoCadastro getTipoCadastro() {
        return this.tipoCadastro;
    }

    @Generated
    public Long getCadastroGeral() {
        return this.cadastroGeral;
    }

    @Generated
    public Long getGuiaRecolhimento() {
        return this.guiaRecolhimento;
    }

    @Generated
    public Long getSubDivida() {
        return this.subDivida;
    }

    @Generated
    public LocalDate getDataLancamento() {
        return this.dataLancamento;
    }

    @Generated
    public LocalDate getDataSituacao() {
        return this.dataSituacao;
    }

    @Generated
    public String getUsuario() {
        return this.usuario;
    }

    @Generated
    public LocalDate getDataInclusao() {
        return this.dataInclusao;
    }

    @Generated
    public TipoSituacaoImobiliarioItbi getSituacao() {
        return this.situacao;
    }

    @Generated
    public LocalDate getDataVencimento() {
        return this.dataVencimento;
    }

    @Generated
    public BigDecimal getValor() {
        return this.valor;
    }

    @Generated
    public BigDecimal getValorFinanciado() {
        return this.valorFinanciado;
    }

    @Generated
    public BigDecimal getAliquota() {
        return this.aliquota;
    }

    @Generated
    public BigDecimal getAliquotaFinanciado() {
        return this.aliquotaFinanciado;
    }

    @Generated
    public BigDecimal getBaseCalculo() {
        return this.baseCalculo;
    }

    @Generated
    public BigDecimal getBaseCalculoFinanciado() {
        return this.baseCalculoFinanciado;
    }

    @Generated
    public Boolean getTodasUnidades() {
        return this.todasUnidades;
    }

    @Generated
    public Boolean getDebitoGerado() {
        return this.debitoGerado;
    }

    @Generated
    public TipoItbi getTipoItbi() {
        return this.tipoItbi;
    }

    @Generated
    public Boolean getSomenteTerreno() {
        return this.somenteTerreno;
    }

    @Generated
    public Boolean getParcelado() {
        return this.parcelado;
    }

    @Generated
    public Boolean getTransfereAutomatico() {
        return this.transfereAutomatico;
    }

    @Generated
    public Long getCodigoItbi() {
        return this.codigoItbi;
    }

    @Generated
    public ParametroItbi getParametroItbi() {
        return this.parametroItbi;
    }

    @Generated
    public List<ImobiliarioItbiObs> getObservacoes() {
        return this.observacoes;
    }

    @Generated
    public List<ProprietarioItbi> getProprietarios() {
        return this.proprietarios;
    }

    @Generated
    public List<ImobiliarioItbiSegmento> getSegmentos() {
        return this.segmentos;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setEntidade(Long entidade) {
        this.entidade = entidade;
    }

    @Generated
    public void setExercicio(Long exercicio) {
        this.exercicio = exercicio;
    }

    @Generated
    public void setTipoCadastro(TipoCadastro tipoCadastro) {
        this.tipoCadastro = tipoCadastro;
    }

    @Generated
    public void setCadastroGeral(Long cadastroGeral) {
        this.cadastroGeral = cadastroGeral;
    }

    @Generated
    public void setGuiaRecolhimento(Long guiaRecolhimento) {
        this.guiaRecolhimento = guiaRecolhimento;
    }

    @Generated
    public void setSubDivida(Long subDivida) {
        this.subDivida = subDivida;
    }

    @Generated
    public void setDataLancamento(LocalDate dataLancamento) {
        this.dataLancamento = dataLancamento;
    }

    @Generated
    public void setDataSituacao(LocalDate dataSituacao) {
        this.dataSituacao = dataSituacao;
    }

    @Generated
    public void setUsuario(String usuario) {
        this.usuario = usuario;
    }

    @Generated
    public void setDataInclusao(LocalDate dataInclusao) {
        this.dataInclusao = dataInclusao;
    }

    @Generated
    public void setSituacao(TipoSituacaoImobiliarioItbi situacao) {
        this.situacao = situacao;
    }

    @Generated
    public void setDataVencimento(LocalDate dataVencimento) {
        this.dataVencimento = dataVencimento;
    }

    @Generated
    public void setValor(BigDecimal valor) {
        this.valor = valor;
    }

    @Generated
    public void setValorFinanciado(BigDecimal valorFinanciado) {
        this.valorFinanciado = valorFinanciado;
    }

    @Generated
    public void setAliquota(BigDecimal aliquota) {
        this.aliquota = aliquota;
    }

    @Generated
    public void setAliquotaFinanciado(BigDecimal aliquotaFinanciado) {
        this.aliquotaFinanciado = aliquotaFinanciado;
    }

    @Generated
    public void setBaseCalculo(BigDecimal baseCalculo) {
        this.baseCalculo = baseCalculo;
    }

    @Generated
    public void setBaseCalculoFinanciado(BigDecimal baseCalculoFinanciado) {
        this.baseCalculoFinanciado = baseCalculoFinanciado;
    }

    @Generated
    public void setTodasUnidades(Boolean todasUnidades) {
        this.todasUnidades = todasUnidades;
    }

    @Generated
    public void setDebitoGerado(Boolean debitoGerado) {
        this.debitoGerado = debitoGerado;
    }

    @Generated
    public void setTipoItbi(TipoItbi tipoItbi) {
        this.tipoItbi = tipoItbi;
    }

    @Generated
    public void setSomenteTerreno(Boolean somenteTerreno) {
        this.somenteTerreno = somenteTerreno;
    }

    @Generated
    public void setParcelado(Boolean parcelado) {
        this.parcelado = parcelado;
    }

    @Generated
    public void setTransfereAutomatico(Boolean transfereAutomatico) {
        this.transfereAutomatico = transfereAutomatico;
    }

    @Generated
    public void setCodigoItbi(Long codigoItbi) {
        this.codigoItbi = codigoItbi;
    }

    @Generated
    public void setParametroItbi(ParametroItbi parametroItbi) {
        this.parametroItbi = parametroItbi;
    }

    @Generated
    public void setObservacoes(List<ImobiliarioItbiObs> observacoes) {
        this.observacoes = observacoes;
    }

    @Generated
    public void setProprietarios(List<ProprietarioItbi> proprietarios) {
        this.proprietarios = proprietarios;
    }

    @Generated
    public void setSegmentos(List<ImobiliarioItbiSegmento> segmentos) {
        this.segmentos = segmentos;
    }

    @Generated
    public String toString() {
        return "ImobiliarioItbi(id=" + this.getId() + ", entidade=" + this.getEntidade() + ", exercicio=" + this.getExercicio() + ", tipoCadastro=" + this.getTipoCadastro() + ", cadastroGeral=" + this.getCadastroGeral() + ", guiaRecolhimento=" + this.getGuiaRecolhimento() + ", subDivida=" + this.getSubDivida() + ", dataLancamento=" + this.getDataLancamento() + ", dataSituacao=" + this.getDataSituacao() + ", usuario=" + this.getUsuario() + ", dataInclusao=" + this.getDataInclusao() + ", situacao=" + this.getSituacao() + ", dataVencimento=" + this.getDataVencimento() + ", valor=" + this.getValor() + ", valorFinanciado=" + this.getValorFinanciado() + ", aliquota=" + this.getAliquota() + ", aliquotaFinanciado=" + this.getAliquotaFinanciado() + ", baseCalculo=" + this.getBaseCalculo() + ", baseCalculoFinanciado=" + this.getBaseCalculoFinanciado() + ", todasUnidades=" + this.getTodasUnidades() + ", debitoGerado=" + this.getDebitoGerado() + ", tipoItbi=" + this.getTipoItbi() + ", somenteTerreno=" + this.getSomenteTerreno() + ", parcelado=" + this.getParcelado() + ", transfereAutomatico=" + this.getTransfereAutomatico() + ", codigoItbi=" + this.getCodigoItbi() + ", parametroItbi=" + this.getParametroItbi() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ImobiliarioItbi)) {
            return false;
        }
        ImobiliarioItbi other = (ImobiliarioItbi)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ImobiliarioItbi;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }
}

