/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.metamodel.annotation.MetaModelIgnore;
import br.com.elotech.tributos.domain.Divida;
import br.com.elotech.tributos.domain.DividaGrupoVencimentoId;
import br.com.elotech.tributos.domain.DividaGrupoVencimentoParcela;
import br.com.elotech.tributos.domain.DividaGrupoVencimentoParcelaId;
import br.com.elotech.tributos.util.ListUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.MapsId;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import lombok.Generated;

@Entity
@Table(name="tribguiarecolhimentogrupovenc")
public class DividaGrupoVencimento
implements EloEntity<DividaGrupoVencimentoId> {
    private static final Long ACRESCIMO_DE_SEQUENCIA = 1L;
    @EmbeddedId
    private DividaGrupoVencimentoId id;
    @Column(name="numeroparcelas")
    private Integer numeroParcelas;
    @Column(name="databasegrupo")
    private LocalDate dataBase;
    @Column(name="valorminimoparcela")
    private BigDecimal valorMinimoParcela;
    @Column(name="valortotaldebito")
    private BigDecimal valorTotalDebito;
    @MapsId(value="entidade,exercicio,divida")
    @ManyToOne
    @JoinColumns(value={@JoinColumn(name="entidade", referencedColumnName="entidade"), @JoinColumn(name="exercicio", referencedColumnName="exercicio"), @JoinColumn(name="guiarecolhimento", referencedColumnName="guiarecolhimento")})
    @JsonIgnore
    @MetaModelIgnore
    private Divida divida;
    @OneToMany(mappedBy="dividaGrupoVencimento", cascade={CascadeType.ALL}, orphanRemoval=true)
    @OrderBy(value="id.parcela")
    @JsonIgnoreProperties(value={"dividaGrupoVencimento"})
    private List<DividaGrupoVencimentoParcela> parcelas = new ArrayList();

    public void setDividaTributoParcelaId() {
        this.parcelas.forEach(parcela -> {
            if (Objects.isNull(parcela.getId()) || Objects.isNull(parcela.getId().getGrupoVencimento())) {
                parcela.setId(DividaGrupoVencimentoParcelaId.builder().entidade(this.getId().getEntidade()).exercicio(this.getId().getExercicio()).divida(this.getId().getDivida()).grupoVencimento(this.getGrupoVencimento()).parcela(parcela.getParcela()).build());
            }
            parcela.setDividaGrupoVencimento(this);
        });
    }

    @JsonIgnore
    public Long getGrupoVencimento() {
        return Optional.ofNullable(this.id).map(DividaGrupoVencimentoId::getGrupoVencimento).orElse(0L);
    }

    @JsonIgnore
    public Long getProximoNumeroVencimento() {
        return this.divida.getGruposVencimento().stream().map(DividaGrupoVencimento::getGrupoVencimento).reduce(0L, Long::max) + ACRESCIMO_DE_SEQUENCIA;
    }

    public void mergeParcelas(List<DividaGrupoVencimentoParcela> novasParcelas) {
        List merged = ListUtils.merge((List)this.getParcelas(), novasParcelas, DividaGrupoVencimentoParcela::getId, DividaGrupoVencimentoParcela::merge);
        this.getParcelas().clear();
        this.getParcelas().addAll(merged);
    }

    @Generated
    public DividaGrupoVencimento() {
    }

    @Generated
    public DividaGrupoVencimentoId getId() {
        return this.id;
    }

    @Generated
    public Integer getNumeroParcelas() {
        return this.numeroParcelas;
    }

    @Generated
    public LocalDate getDataBase() {
        return this.dataBase;
    }

    @Generated
    public BigDecimal getValorMinimoParcela() {
        return this.valorMinimoParcela;
    }

    @Generated
    public BigDecimal getValorTotalDebito() {
        return this.valorTotalDebito;
    }

    @Generated
    public Divida getDivida() {
        return this.divida;
    }

    @Generated
    public List<DividaGrupoVencimentoParcela> getParcelas() {
        return this.parcelas;
    }

    @Generated
    public void setId(DividaGrupoVencimentoId id) {
        this.id = id;
    }

    @Generated
    public void setNumeroParcelas(Integer numeroParcelas) {
        this.numeroParcelas = numeroParcelas;
    }

    @Generated
    public void setDataBase(LocalDate dataBase) {
        this.dataBase = dataBase;
    }

    @Generated
    public void setValorMinimoParcela(BigDecimal valorMinimoParcela) {
        this.valorMinimoParcela = valorMinimoParcela;
    }

    @Generated
    public void setValorTotalDebito(BigDecimal valorTotalDebito) {
        this.valorTotalDebito = valorTotalDebito;
    }

    @Generated
    public void setDivida(Divida divida) {
        this.divida = divida;
    }

    @Generated
    public void setParcelas(List<DividaGrupoVencimentoParcela> parcelas) {
        this.parcelas = parcelas;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DividaGrupoVencimento)) {
            return false;
        }
        DividaGrupoVencimento other = (DividaGrupoVencimento)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        DividaGrupoVencimentoId this$id = this.getId();
        DividaGrupoVencimentoId other$id = other.getId();
        return !(this$id == null ? other$id != null : !this$id.equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DividaGrupoVencimento;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        DividaGrupoVencimentoId $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "DividaGrupoVencimento(id=" + this.getId() + ")";
    }
}

