/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.controller;

import br.com.elotech.core.utils.web.ResponseUtils;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.params.CadastroGeralParams;
import br.com.elotech.tributos.report.RelatorioTributos;
import br.com.elotech.tributos.service.AvulsoCompletoRelatorioService;
import java.io.IOException;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"/api/relatorios"})
public class AvulsoRelatorioController {
    private final AvulsoCompletoRelatorioService avulsoCompletoRelatorioService;

    public AvulsoRelatorioController(AvulsoCompletoRelatorioService avulsoCompletoRelatorioService) {
        this.avulsoCompletoRelatorioService = avulsoCompletoRelatorioService;
    }

    @GetMapping(value={"/avulso-completo"}, params={"cadastroGeral"})
    public void imprimirCadastroAvulsoCompleto(Long cadastroGeral, HttpServletResponse response) throws IOException {
        byte[] espelhoCadastroAvulso = this.avulsoCompletoRelatorioService.createAvulsoCompletoPdfReport(new CadastroGeralParams(TipoCadastro.AVULSO, cadastroGeral));
        ResponseUtils.writePdfToResponse((HttpServletResponse)response, (byte[])espelhoCadastroAvulso, (String)RelatorioTributos.CADASTRO_AVULSO_COMPLETO.getNomePdf());
    }
}

