/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.calculo.service;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.calculo.domain.TabelaValor;
import br.com.elotech.tributos.calculo.domain.TipoCampo;
import br.com.elotech.tributos.calculo.dto.TabelaValorCalculoParametrosDTO;
import br.com.elotech.tributos.calculo.dto.TabelaValorDTO;
import br.com.elotech.tributos.calculo.dto.TabelaValorParametroDTO;
import br.com.elotech.tributos.calculo.exception.TabelaValorException;
import br.com.elotech.tributos.calculo.repository.TabelaValorRepository;
import br.com.elotech.tributos.calculo.service.CalculoTabelaValores;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.convert.ConversionException;
import org.springframework.core.convert.ConversionService;
import org.springframework.stereotype.Service;

@Service
public class TabelaValorService
extends CrudService<TabelaValor, Long> {
    private static final Logger LOGGER = LoggerFactory.getLogger(TabelaValorService.class);
    private final TabelaValorRepository tabelaValorRepository;
    private final ConversionService conversionService;

    public TabelaValorService(TabelaValorRepository tabelaValorRepository, ConversionService conversionService) {
        this.tabelaValorRepository = tabelaValorRepository;
        this.conversionService = conversionService;
    }

    public TabelaValorDTO save(TabelaValorDTO dto) {
        this.beforeSave(dto);
        TabelaValor tabelaValor = TabelaValor.of((TabelaValorDTO)dto);
        tabelaValor.getColunas().forEach(coluna -> {
            coluna.setTabelaValor(tabelaValor);
            coluna.getCelulas().forEach(celula -> celula.setColuna(coluna));
        });
        this.validateBuildTabelaValor(tabelaValor);
        return TabelaValorDTO.of((TabelaValor)((TabelaValor)this.tabelaValorRepository.save((Object)tabelaValor)));
    }

    private void beforeSave(TabelaValorDTO dto) {
        this.validateCelulasColunaResultado(dto.getLinhas());
        this.validateCelulasParametros(dto);
    }

    private void validateCelulasParametros(TabelaValorDTO dto) {
        List referenciasParametros = dto.getParametros().stream().map(TabelaValorParametroDTO::getReferenciaParametro).collect(Collectors.toList());
        referenciasParametros.add("resultado");
        dto.getLinhas().forEach(linha -> linha.forEach((chave, valor) -> {
            if (!referenciasParametros.contains(chave)) {
                throw new TabelaValorException(String.format("Par\u00e2metro \"%s\" n\u00e3o cadastrado na lista de par\u00e2metros.", chave));
            }
        }));
    }

    private void validateBuildTabelaValor(TabelaValor tabelaValor) {
        new CalculoTabelaValores(this.conversionService, Collections.singletonList(tabelaValor));
    }

    public TabelaValorDTO update(Long id, TabelaValorDTO dto) {
        this.beforeSave(dto);
        TabelaValor tabelaValor = (TabelaValor)this.tabelaValorRepository.findById((Object)id).orElseThrow(() -> new TabelaValorException(String.format("Tabela de Valor com id %d n\u00e3o encontrada.", id)));
        tabelaValor.merge(TabelaValor.of((TabelaValorDTO)dto));
        this.validateBuildTabelaValor(tabelaValor);
        return TabelaValorDTO.of((TabelaValor)((TabelaValor)this.tabelaValorRepository.save((Object)tabelaValor)));
    }

    public void delete(Long id) {
        TabelaValor tabelaValor = (TabelaValor)this.tabelaValorRepository.findById((Object)id).orElseThrow(() -> new TabelaValorException(String.format("Tabela de Valor com id %d n\u00e3o encontrada.", id)));
        this.delete((EloEntity)tabelaValor, null);
    }

    private void validateCelulasColunaResultado(List<Map<String, String>> linhas) {
        List<String> valoresResultado = linhas.stream().map(linha -> {
            String valorResultado = linha.getOrDefault("resultado", "");
            if (StringUtils.isBlank((CharSequence)valorResultado)) {
                throw new TabelaValorException(String.format("Preencha todos valores da coluna \"%s\".", "resultado"));
            }
            return valorResultado;
        }).collect(Collectors.toList());
        valoresResultado.forEach(valor -> {
            TipoCampo tipoResultado = TipoCampo.DOUBLE;
            try {
                this.conversionService.convert(valor, tipoResultado.getClasse());
            }
            catch (ConversionException e) {
                String message = String.format("Tabela de valor com valor \"%s\" incompat\u00edvel ao tipo \"%s\" da coluna \"%s\".", valor, tipoResultado.getDescricao(), "resultado");
                LOGGER.error(message, (Throwable)e);
                throw new TabelaValorException(String.format(message, new Object[]{e}));
            }
        });
    }

    public List<TabelaValor> findByExercicio(Long exercicio) {
        return this.tabelaValorRepository.findByExercicio(exercicio);
    }

    public Double simulaCalculoValorResultado(Long id, TabelaValorCalculoParametrosDTO dto) {
        TabelaValor tabelaValor = (TabelaValor)this.tabelaValorRepository.findById((Object)id).orElseThrow(() -> new TabelaValorException(String.format("Tabela de Valor com id %d n\u00e3o encontrada.", id)));
        CalculoTabelaValores calculoTabelaValores = new CalculoTabelaValores(this.conversionService, Collections.singletonList(tabelaValor));
        return calculoTabelaValores.calculaTabelaValores(tabelaValor.getNome(), dto.getParametros());
    }
}

