/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.calculo.service;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.service.support.ReadOnlyService;
import br.com.elotech.tributos.calculo.domain.Calculo;
import br.com.elotech.tributos.calculo.domain.CalculoCadastro;
import br.com.elotech.tributos.calculo.domain.CalculoLoteImpressao;
import br.com.elotech.tributos.calculo.domain.CalculoLoteImpressaoItem;
import br.com.elotech.tributos.calculo.domain.SituacaoCalculo;
import br.com.elotech.tributos.calculo.dto.CalculoLoteImpressaoItemDTO;
import br.com.elotech.tributos.calculo.dto.LoteItemDTO;
import br.com.elotech.tributos.calculo.exception.CalculoException;
import br.com.elotech.tributos.calculo.repository.CalculoLoteImpressaoItemRepository;
import br.com.elotech.tributos.calculo.service.CalculoCadastroService;
import br.com.elotech.tributos.dto.CarneDTO;
import br.com.elotech.tributos.service.CarneService;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.batch.core.BatchStatus;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class CalculoLoteImpressaoItemService
extends ReadOnlyService<CalculoLoteImpressaoItem, Long> {
    private final CalculoLoteImpressaoItemRepository calculoLoteImpressaoItemRepository;
    private final CarneService carneService;
    private final CalculoCadastroService calculoCadastroService;

    public CalculoLoteImpressaoItemService(CalculoLoteImpressaoItemRepository calculoLoteImpressaoItemRepository, CarneService carneService, CalculoCadastroService calculoCadastroService) {
        this.calculoLoteImpressaoItemRepository = calculoLoteImpressaoItemRepository;
        this.carneService = carneService;
        this.calculoCadastroService = calculoCadastroService;
    }

    public List<CalculoLoteImpressaoItem> createLoteImpressaoItem(CalculoLoteImpressao calculoLoteImpressao, List<LoteItemDTO> loteItens) {
        ArrayList<CalculoLoteImpressaoItem> loteImpressaoItens = new ArrayList<CalculoLoteImpressaoItem>();
        AtomicLong ordem = new AtomicLong();
        loteItens.forEach(loteItem -> {
            CalculoLoteImpressaoItem loteImpressaoItem = new CalculoLoteImpressaoItem();
            loteImpressaoItem.setCalculoLoteImpressao(calculoLoteImpressao);
            loteImpressaoItem.setIdCalculoCadastro(loteItem.getIdCalculoCadastro());
            loteImpressaoItem.setOrdem(Long.valueOf(ordem.incrementAndGet()));
            loteImpressaoItens.add(loteImpressaoItem);
            this.calculoLoteImpressaoItemRepository.save((Object)loteImpressaoItem);
        });
        return loteImpressaoItens;
    }

    public Page<CalculoLoteImpressaoItemDTO> findByLoteImpressaoId(Long idLoteImpressao, String search, Pageable pageable) {
        String idClause = String.format("calculoLoteImpressao.id==%d", idLoteImpressao);
        String searchWithIdClause = StringUtils.isBlank((CharSequence)search) ? idClause : String.format("(%s) and (%s)", idClause, search);
        return this.findByRsql(searchWithIdClause, pageable).map(CalculoLoteImpressaoItemDTO::of);
    }

    public CalculoLoteImpressaoItem findItemById(Long id) {
        return (CalculoLoteImpressaoItem)this.calculoLoteImpressaoItemRepository.findById((Object)id).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi encontrado item do lote de impress\u00e3o com id %d.", id)));
    }

    private void saveCarne(CalculoLoteImpressaoItem calculoLoteImpressaoItem) {
        CalculoCadastro calculoCadastro = calculoLoteImpressaoItem.getCalculoCadastro();
        CarneDTO carneDTO = this.carneService.geraCarneCalculo(calculoCadastro, calculoLoteImpressaoItem.getCalculoLoteImpressao().getOrdem());
        calculoCadastro.vincularCarne(carneDTO);
        this.calculoCadastroService.save((EloEntity)calculoCadastro, null);
    }

    public CalculoLoteImpressaoItemDTO gerarCarneManual(Long id) {
        CalculoLoteImpressaoItem calculoLoteImpressaoItem = this.findItemById(id);
        CalculoCadastro calculoCadastro = calculoLoteImpressaoItem.getCalculoCadastro();
        this.validaGeracaoCarneManual(calculoCadastro);
        this.saveCarne(calculoLoteImpressaoItem);
        this.atualizaSituacaoCalculoCasoTodosCarnesGerados(calculoCadastro.getCalculo());
        return CalculoLoteImpressaoItemDTO.of((CalculoLoteImpressaoItem)calculoLoteImpressaoItem);
    }

    public CalculoLoteImpressaoItemDTO gerarCarneBatch(Long id) {
        CalculoLoteImpressaoItem calculoLoteImpressaoItem = this.findItemById(id);
        this.saveCarne(calculoLoteImpressaoItem);
        return CalculoLoteImpressaoItemDTO.of((CalculoLoteImpressaoItem)calculoLoteImpressaoItem);
    }

    private void atualizaSituacaoCalculoCasoTodosCarnesGerados(Calculo calculo) {
        List cadastros = this.calculoLoteImpressaoItemRepository.findAllCalculoCadastroInAnyLoteByCalculoId(calculo.getId());
        if (cadastros.stream().allMatch(cadastro -> Objects.nonNull(cadastro.getNumeroCarne()))) {
            calculo.setSituacao(SituacaoCalculo.CARNE_GERADO);
        }
    }

    private void validaGeracaoCarneManual(CalculoCadastro calculoCadastro) {
        this.validaSituacaoCalculo(calculoCadastro.getCalculo());
        this.validaFormasPagamento(calculoCadastro);
    }

    public void validaGeracaoCarneBatch(Calculo calculo) {
        this.validaSituacaoCalculo(calculo);
        this.validaFormasPagamentoTodasDividasDoCalculo(calculo);
    }

    private void validaSituacaoCalculo(Calculo calculo) {
        BatchStatus batchStatus;
        BatchStatus batchStatus2 = batchStatus = Objects.nonNull(calculo.getBatchJobExecutionCarne()) ? calculo.getBatchJobExecutionCarne().getStatus() : null;
        if (!SituacaoCalculo.LOTE_GERADO.equals((Object)calculo.getSituacao()) && !SituacaoCalculo.ERRO_GERACAO_CARNE.equals((Object)calculo.getSituacao())) {
            if (SituacaoCalculo.GERANDO_CARNE.equals((Object)calculo.getSituacao()) && !BatchStatus.FAILED.equals((Object)batchStatus)) {
                throw new CalculoException(String.format("Os carn\u00eas do c\u00e1lculo %d j\u00e1 est\u00e3o sendo gerados. Por favor aguarde ou tente novamente.", calculo.getId()));
            }
            if (!SituacaoCalculo.GERANDO_CARNE.equals((Object)calculo.getSituacao())) {
                throw new EloValidationException(String.format("N\u00e3o \u00e9 poss\u00edvel gerar carn\u00eas para c\u00e1lculo com situa\u00e7\u00e3o %s.", calculo.getSituacao().getDescricao()));
            }
        }
    }

    private void validaFormasPagamento(CalculoCadastro calculoCadastro) {
        List formasPagamento = calculoCadastro.getCalculo().getFormasPagamento();
        if (formasPagamento.stream().noneMatch(formaPagamento -> formaPagamento.getDividaFormaPagamento().getDivida().equals((Object)calculoCadastro.getDivida()))) {
            throw new EloValidationException(String.format("Forma de pagamento n\u00e3o configurada para d\u00edvida %d.", calculoCadastro.getDivida().getDivida()));
        }
    }

    private void validaFormasPagamentoTodasDividasDoCalculo(Calculo calculo) {
        List dividasSemFormaDePagamento = calculo.getDividas().stream().filter(divida -> calculo.getFormasPagamento().stream().noneMatch(formaPagamento -> formaPagamento.getDividaFormaPagamento().getDivida().equals(divida))).collect(Collectors.toList());
        if (!dividasSemFormaDePagamento.isEmpty()) {
            throw new EloValidationException(String.format("\u00c9 necess\u00e1rio configurar pelo menos uma forma de pagamento para as seguintes d\u00edvidas %s.", dividasSemFormaDePagamento.stream().map(divida -> String.format("\"%d - %s\"", divida.getDivida(), divida.getDescricao())).collect(Collectors.joining(", "))));
        }
    }

    public void deleteCarne(Long id) {
        CalculoLoteImpressaoItem calculoLoteImpressaoItem = this.findItemById(id);
        CalculoCadastro calculoCadastro = calculoLoteImpressaoItem.getCalculoCadastro();
        this.carneService.deleteCarne(calculoCadastro.getEntidadeCarne(), calculoCadastro.getExercicioCarne(), calculoCadastro.getNumeroCarne());
        calculoCadastro.limparCarne();
        this.calculoCadastroService.save((EloEntity)calculoCadastro, null);
    }
}

