/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.calculo.service;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.calculo.domain.Calculo;
import br.com.elotech.tributos.calculo.domain.CalculoGeracaoLote;
import br.com.elotech.tributos.calculo.domain.SituacaoCalculo;
import br.com.elotech.tributos.calculo.dto.CalculoGeracaoLoteDTO;
import br.com.elotech.tributos.calculo.dto.CampoCadastroGeralDTO;
import br.com.elotech.tributos.calculo.dto.CampoCadastroImobiliarioDTO;
import br.com.elotech.tributos.calculo.dto.CampoCidadeDTO;
import br.com.elotech.tributos.calculo.dto.CampoDetalheDTO;
import br.com.elotech.tributos.calculo.dto.LoteItemDTO;
import br.com.elotech.tributos.calculo.repository.CalculoGeracaoLoteRepository;
import br.com.elotech.tributos.calculo.service.CalculoLoteImpressaoService;
import br.com.elotech.tributos.calculo.service.CalculoService;
import br.com.elotech.tributos.domain.ParametroGeralEnum;
import br.com.elotech.tributos.domain.camposdinamicos.FuncionalidadeCampo;
import br.com.elotech.tributos.service.ParametroGeralService;
import br.com.elotech.tributos.service.camposdinamicos.GrupoCampoService;
import br.com.elotech.tributos.util.AutoCompleteDetailUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class CalculoGeracaoLoteService
extends CrudService<CalculoGeracaoLote, Long> {
    private CalculoService calculoService;
    private CalculoGeracaoLoteRepository calculoGeracaoLoteRepository;
    private CalculoLoteImpressaoService calculoLoteImpressaoService;
    private GrupoCampoService grupoCampoService;
    private ParametroGeralService parametroGeralService;

    public CalculoGeracaoLoteService(CalculoService calculoService, CalculoGeracaoLoteRepository calculoGeracaoLoteRepository, CalculoLoteImpressaoService calculoLoteImpressaoService, GrupoCampoService grupoCampoService, ParametroGeralService parametroGeralService) {
        this.calculoService = calculoService;
        this.calculoGeracaoLoteRepository = calculoGeracaoLoteRepository;
        this.calculoLoteImpressaoService = calculoLoteImpressaoService;
        this.grupoCampoService = grupoCampoService;
        this.parametroGeralService = parametroGeralService;
    }

    public CalculoGeracaoLoteDTO createConfiguracaoAndLote(CalculoGeracaoLoteDTO calculoGeracaoLoteDTO) {
        Calculo calculo = this.getCalculo(calculoGeracaoLoteDTO.getIdCalculo());
        if (!SituacaoCalculo.DEBITO_GERADO.equals((Object)calculo.getSituacao())) {
            throw new EloValidationException(String.format("N\u00e3o \u00e9 poss\u00edvel gerar lotes de impress\u00e3o para c\u00e1lculo na situa\u00e7\u00e3o %s", calculo.getSituacao().getDescricao()));
        }
        CalculoGeracaoLote calculoGeracaoLote = calculoGeracaoLoteDTO.toEntity(calculo);
        CalculoGeracaoLoteDTO loteDTO = CalculoGeracaoLoteDTO.of((CalculoGeracaoLote)((CalculoGeracaoLote)this.calculoGeracaoLoteRepository.save((Object)calculoGeracaoLote)));
        Map lotes = this.getItensLoteImpressao(calculoGeracaoLoteDTO);
        this.calculoLoteImpressaoService.createLoteImpressao(calculoGeracaoLote, lotes);
        return loteDTO;
    }

    protected Map<String, List<LoteItemDTO>> getItensLoteImpressao(CalculoGeracaoLoteDTO calculoGeracaoLoteDTO) {
        Set loteItemDTOS = this.calculoGeracaoLoteRepository.loadItensLoteImpressao(calculoGeracaoLoteDTO);
        if (loteItemDTOS.isEmpty()) {
            throw new EloValidationException("N\u00e3o possui cadastros para gera\u00e7\u00e3o do lote de impress\u00e3o.");
        }
        if (calculoGeracaoLoteDTO.getAgrupamentos().isEmpty()) {
            return loteItemDTOS.stream().collect(Collectors.groupingBy(loteItemDTO -> "Geral"));
        }
        return loteItemDTOS.stream().collect(Collectors.groupingBy(LoteItemDTO::getAgrupamento));
    }

    private Calculo getCalculo(Long idCalculo) {
        return (Calculo)this.calculoService.findById((Serializable)idCalculo).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi poss\u00edvel encontrar o c\u00e1lculo com id: %d", idCalculo)));
    }

    public Page<CalculoGeracaoLoteDTO> findByCalculoId(Long idCalculo, String search, Pageable pageable) {
        String idClause = String.format("calculo.id==%d", idCalculo);
        String searchWithIdClause = StringUtils.isBlank((CharSequence)search) ? idClause : String.format("(%s) and (%s)", idClause, search);
        return this.findByRsql(searchWithIdClause, pageable).map(CalculoGeracaoLoteDTO::of);
    }

    public List<CampoDetalheDTO> searchCampos(String search) {
        List campos = this.getCampos();
        if (StringUtils.isNotBlank((CharSequence)search)) {
            return campos.stream().filter(item -> item.getTabela().toLowerCase().contains(search.toLowerCase()) || item.getNome().toLowerCase().contains(search.toLowerCase())).collect(Collectors.toList());
        }
        return campos;
    }

    public List<CampoDetalheDTO> getCampos() {
        ArrayList<CampoDetalheDTO> campos = new ArrayList<CampoDetalheDTO>();
        campos.addAll(AutoCompleteDetailUtils.getCamposFromAnnotation(CampoCadastroImobiliarioDTO.class));
        campos.addAll(AutoCompleteDetailUtils.getCamposFromAnnotation(CampoCadastroGeralDTO.class));
        campos.addAll(AutoCompleteDetailUtils.getCamposFromAnnotation(CampoCidadeDTO.class));
        Boolean utilizaBoletimLogradouro = this.parametroGeralService.getParamValueAsBoolean(ParametroGeralEnum.UTILIZA_BOLETIM_LOGRADOURO);
        if (Objects.isNull(utilizaBoletimLogradouro)) {
            throw new EloValidationException("N\u00e3o foi poss\u00edvel encontrar o par\u00e2metro Utiliza Boletim Logradouro");
        }
        if (Boolean.TRUE.equals(utilizaBoletimLogradouro)) {
            campos.addAll(this.grupoCampoService.getCamposByFuncionalidade(Arrays.asList(FuncionalidadeCampo.TERRENO, FuncionalidadeCampo.LOGRADOURO)));
        } else {
            campos.addAll(this.grupoCampoService.getCamposByFuncionalidade(Collections.singletonList(FuncionalidadeCampo.TERRENO)));
        }
        return campos;
    }
}

