/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.calculo.service;

import br.com.caelum.stella.tinytype.CNPJ;
import br.com.caelum.stella.tinytype.CPF;
import br.com.elotech.core.enumerable.common.TipoPessoa;
import br.com.elotech.tributos.calculo.domain.CalculoLoteImpressao;
import br.com.elotech.tributos.calculo.domain.arquivografica.SegmentoA;
import br.com.elotech.tributos.calculo.domain.arquivografica.SegmentoArquivoGrafica;
import br.com.elotech.tributos.calculo.domain.arquivografica.SegmentoC;
import br.com.elotech.tributos.calculo.domain.arquivografica.SegmentoD;
import br.com.elotech.tributos.calculo.domain.arquivografica.SegmentoE;
import br.com.elotech.tributos.calculo.domain.arquivografica.SegmentoF;
import br.com.elotech.tributos.calculo.domain.arquivografica.SegmentoJ;
import br.com.elotech.tributos.calculo.domain.arquivografica.SegmentoN;
import br.com.elotech.tributos.calculo.domain.arquivografica.SegmentoO;
import br.com.elotech.tributos.calculo.domain.arquivografica.SegmentoZ;
import br.com.elotech.tributos.calculo.dto.ArquivoGraficaBoletoDTO;
import br.com.elotech.tributos.calculo.dto.ArquivoGraficaCampoVariavelDTO;
import br.com.elotech.tributos.calculo.dto.ArquivoGraficaItemDTO;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.domain.inscricaocadastral.ConfiguracaoInscricaoCadastral;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public class ArquivoGrafica {
    private ByteArrayOutputStream outStream;
    private ZipOutputStream zipOutStream;
    private AtomicLong sequenciaLinha = new AtomicLong(1L);

    public ArquivoGrafica(String nomeArquivo) {
        try {
            this.outStream = new ByteArrayOutputStream();
            this.zipOutStream = new ZipOutputStream(this.outStream);
            ZipEntry e = new ZipEntry(String.format("%s.txt", nomeArquivo));
            this.zipOutStream.putNextEntry(e);
        }
        catch (IOException ex) {
            throw new RuntimeException("N\u00e3o foi poss\u00edvel criar o arquivo para gr\u00e1fica.", ex);
        }
    }

    private void escreverLinha(String segmento, String ... campos) {
        String linhaComSequencia = this.getSequenciaLinha() + segmento + "-" + String.join((CharSequence)"", campos) + "\n";
        try {
            byte[] data = linhaComSequencia.getBytes();
            this.zipOutStream.write(data, 0, data.length);
        }
        catch (IOException ex) {
            throw new RuntimeException("Erro ao escrever no arquivo para gr\u00e1fica.", ex);
        }
    }

    private String formatField(Long value, SegmentoArquivoGrafica campo) {
        Long valueOrDefault = Optional.ofNullable(value).orElse(0L);
        return StringUtils.truncate((String)this.completaZeroEsquerda(valueOrDefault, campo.getTamanho()), (int)campo.getTamanho().intValue());
    }

    private String formatField(String value, SegmentoArquivoGrafica campo) {
        return this.formatField(value, campo.getTamanho());
    }

    private String formatField(String value, Long tamanho) {
        return StringUtils.truncate((String)StringUtils.rightPad((String)StringUtils.defaultString((String)value), (int)tamanho.intValue()), (int)tamanho.intValue());
    }

    private String formatField(LocalDate date, SegmentoArquivoGrafica campo) {
        String formattedDate = Optional.ofNullable(date).map(value -> value.format(DateTimeFormatter.ofPattern("yyyyMMdd"))).orElse("");
        return this.formatField(formattedDate, campo);
    }

    private String formatField(BigDecimal value, SegmentoArquivoGrafica campo) {
        Long valorMultiplicadoPorCem = Optional.ofNullable(value).map(valor -> valor.multiply(BigDecimal.valueOf(100L)).longValue()).orElse(0L);
        return this.formatField(valorMultiplicadoPorCem, campo);
    }

    private String completaZeroEsquerda(Long numero, Long quantidadeCasas) {
        return StringUtils.leftPad((String)numero.toString(), (int)quantidadeCasas.intValue(), (String)"0");
    }

    private String getSequenciaLinha() {
        return this.completaZeroEsquerda(Long.valueOf(this.sequenciaLinha.getAndIncrement()), Long.valueOf(10L));
    }

    public void finalizaGeracaoArquivo() {
        try {
            this.zipOutStream.closeEntry();
            this.zipOutStream.close();
        }
        catch (IOException ex) {
            throw new RuntimeException("Erro ao finalizar gera\u00e7\u00e3o do arquivo para gr\u00e1fica.", ex);
        }
    }

    public void gerarSegmentoA(CalculoLoteImpressao calculoLoteImpressao, String descricaoEntidade) {
        String numeroRemessa = this.formatField(calculoLoteImpressao.getId(), (SegmentoArquivoGrafica)SegmentoA.NUMERO_REMESSA);
        String dataProcessamento = this.formatField(LocalDate.now(), (SegmentoArquivoGrafica)SegmentoA.DATA_PROCESSAMENTO);
        String prefeituraMunicipal = this.formatField(descricaoEntidade, (SegmentoArquivoGrafica)SegmentoA.PREFEITURA_MUNICIPAL);
        this.escreverLinha("A", new String[]{numeroRemessa, dataProcessamento, prefeituraMunicipal});
    }

    public void gerarSegmentoC(ArquivoGraficaItemDTO item, ConfiguracaoInscricaoCadastral configuracaoInscricaoCadastral) {
        String inscricaoComMascara = configuracaoInscricaoCadastral.formatarInscricaoCadastral(item.getQuadricula(), item.getDistrito(), item.getSetor(), item.getQuadra(), item.getLote(), item.getUnidade());
        String tipoCadastro = this.formatField(item.getTipoCadastro(), (SegmentoArquivoGrafica)SegmentoC.TIPO_CADASTRO);
        String cadastroGeral = this.formatField(item.getCadastroGeral(), (SegmentoArquivoGrafica)SegmentoC.CADASTRO_GERAL);
        String inscricaoCadastral = this.formatField(inscricaoComMascara, (SegmentoArquivoGrafica)SegmentoC.INSCRICAO_CADASTRAL);
        String descricaoDivida = this.formatField(item.getDescricaoDivida(), (SegmentoArquivoGrafica)SegmentoC.DESCRICAO_DIVIDA);
        String divida = this.formatField(item.getDivida(), (SegmentoArquivoGrafica)SegmentoC.DIVIDA);
        String subdivida = this.formatField(item.getSubDivida(), (SegmentoArquivoGrafica)SegmentoC.SUBDIVIDA);
        String numeroParcelas = this.formatField(item.getNumeroParcela(), (SegmentoArquivoGrafica)SegmentoC.NUMERO_PARCELAS);
        String constaDebitoDividaAtiva = this.formatField(item.getConstaDebitoDividaAtiva(), (SegmentoArquivoGrafica)SegmentoC.CONSTA_DEBITO_DIVIDA_ATIVA);
        this.escreverLinha("C", new String[]{tipoCadastro, cadastroGeral, inscricaoCadastral, descricaoDivida, divida, subdivida, numeroParcelas, constaDebitoDividaAtiva});
    }

    public void gerarSegmentoD(ArquivoGraficaItemDTO item) {
        String nomeContribuinte = this.formatField(item.getNomePessoa(), (SegmentoArquivoGrafica)SegmentoD.NOME_CONTRIBUINTE);
        String logradouro = this.formatField(item.getEnderecoCorrespondencia(), (SegmentoArquivoGrafica)SegmentoD.LOGRAOUDO);
        String numero = this.formatField(item.getNumeroCorrespondencia(), (SegmentoArquivoGrafica)SegmentoD.NUMERO);
        String complemento = this.formatField(item.getComplementoCorrespondencia(), (SegmentoArquivoGrafica)SegmentoD.COMPLEMENTO);
        String bairro = this.formatField(item.getBairroCorrespondencia(), (SegmentoArquivoGrafica)SegmentoD.BAIRRO);
        String cidade = this.formatField(item.getCidadeufCorrespondencia(), (SegmentoArquivoGrafica)SegmentoD.CIDADE);
        String cep = this.formatField(StringUtils.getDigits((String)item.getCepCorrespondencia()), (SegmentoArquivoGrafica)SegmentoD.CEP);
        String uf = this.formatField(item.getUfCorrespondencia(), (SegmentoArquivoGrafica)SegmentoD.UF);
        String compromissario = TipoCadastro.IMOBILIARIO.getValue().equals(item.getTipoCadastro()) && Objects.nonNull(item.getCodigoPessoaCompromissario()) ? this.formatField("***** PEGAR INFORMACAO DO COMPROMISSARIO NO SEGMENTO J *****", (SegmentoArquivoGrafica)SegmentoD.COMPROMISSARIO) : this.formatField("", (SegmentoArquivoGrafica)SegmentoD.COMPROMISSARIO);
        String verificacaoCpfCnpj = "0";
        if (Objects.nonNull(item.getCpfCnpj())) {
            if (TipoPessoa.FISICA.getValue().equals(item.getTipoPessoa())) {
                if (new CPF(item.getCpfCnpj()).isValido()) {
                    verificacaoCpfCnpj = "1";
                }
            } else if (new CNPJ(item.getCpfCnpj()).isValid()) {
                verificacaoCpfCnpj = "1";
            }
        }
        verificacaoCpfCnpj = this.formatField(verificacaoCpfCnpj, (SegmentoArquivoGrafica)SegmentoD.VERIFICACAO_CPF_CNPJ);
        String tipoPessoa = this.formatField(item.getTipoPessoa(), (SegmentoArquivoGrafica)SegmentoD.TIPO_PESSOA);
        String cpfCnpj = this.formatField(item.getCpfCnpj(), (SegmentoArquivoGrafica)SegmentoD.DOCUMENTO);
        String codigoContribuinte = this.formatField(item.getCodigoPessoa(), (SegmentoArquivoGrafica)SegmentoD.CODIGO_CONTRIBUINTE);
        this.escreverLinha("D", new String[]{nomeContribuinte, logradouro, numero, complemento, bairro, cidade, cep, uf, compromissario, verificacaoCpfCnpj, tipoPessoa, cpfCnpj, codigoContribuinte});
    }

    public void gerarSegmentoE(ArquivoGraficaItemDTO item) {
        String quadraLocalizacao = this.formatField(item.getQuadra(), (SegmentoArquivoGrafica)SegmentoE.QUADRA_INSCRICAO_CADASTRAL);
        String loteLocalizacao = this.formatField(item.getLote(), (SegmentoArquivoGrafica)SegmentoE.LOTE_INSCRICAO_CADASTRAL);
        String faceQuadraLocalizacao = this.formatField(item.getFaceQuadra(), (SegmentoArquivoGrafica)SegmentoE.FACE_QUADRA);
        String logradouroLocalizacao = this.formatField(item.getTipoLogradouroLocalizacao() + " " + item.getLogradouroLocalizacao(), (SegmentoArquivoGrafica)SegmentoE.LOGRADOURO);
        String numeroLocalizacao = this.formatField(item.getNumeroLocalizacao(), (SegmentoArquivoGrafica)SegmentoE.NUMERO);
        String complementoLocalizacao = this.formatField(item.getComplementoLocalizacao(), (SegmentoArquivoGrafica)SegmentoE.COMPLEMENTO);
        String bairroLocalizacao = this.formatField(item.getBairroLocalizacao(), (SegmentoArquivoGrafica)SegmentoE.BAIRRO);
        String observacaoCadastro = this.formatField(item.getObservacaoCadastro(), (SegmentoArquivoGrafica)SegmentoE.OBSERVACAO_CADASTRO);
        String quadraFiscalizacao = this.formatField(item.getQuadraFiscalizacao(), (SegmentoArquivoGrafica)SegmentoE.QUADRA_FISCALIZACAO);
        String loteFiscalizacao = this.formatField(item.getLoteFiscalizacao(), (SegmentoArquivoGrafica)SegmentoE.LOTE_FISCALIZACAO);
        String complementoLote = this.formatField(item.getComplementoLote(), (SegmentoArquivoGrafica)SegmentoE.COMPLEMENTO_LOTE);
        String cepLocalizacao = this.formatField(StringUtils.getDigits((String)item.getCepLocalizacao()), (SegmentoArquivoGrafica)SegmentoE.CEP);
        this.escreverLinha("E", new String[]{quadraLocalizacao, loteLocalizacao, faceQuadraLocalizacao, logradouroLocalizacao, numeroLocalizacao, complementoLocalizacao, bairroLocalizacao, observacaoCadastro, quadraFiscalizacao, loteFiscalizacao, complementoLote, cepLocalizacao});
    }

    public void gerarSegmentoF(ArquivoGraficaItemDTO item) {
        String areaLote = this.formatField(item.getAreaLote(), (SegmentoArquivoGrafica)SegmentoF.AREA_LOTE);
        String areaTotalConstruida = this.formatField(item.getAreaTotalConstruida(), (SegmentoArquivoGrafica)SegmentoF.AREA_TOTAL_CONSTRUIDA);
        String valorVenalTerritorial = this.formatField(item.getValorVenalTerritorial(), (SegmentoArquivoGrafica)SegmentoF.VALOR_VENAL_TERRITORIAL);
        String valorVenalPredial = this.formatField(item.getValorVenalPredial(), (SegmentoArquivoGrafica)SegmentoF.VALOR_VENAL_PREDIAL);
        String somaTestadas = this.formatField(item.getSomaTestadas(), (SegmentoArquivoGrafica)SegmentoF.SOMA_TESTADAS);
        String testadaPrincipal = this.formatField(item.getTamanhoTestadaPrincipal(), (SegmentoArquivoGrafica)SegmentoF.TESTADA_PRINCIPAL);
        String aliquota = this.formatField(item.getAliquota(), (SegmentoArquivoGrafica)SegmentoF.ALIQUOTA);
        String loteamento = this.formatField(item.getLoteamento(), (SegmentoArquivoGrafica)SegmentoF.LOTEAMENTO);
        String descricaoLoteamento = this.formatField(item.getDescricaoLoteamento(), (SegmentoArquivoGrafica)SegmentoF.DESCRICAO_LOTEAMENTO);
        String somaValorTerritorialPredial = this.formatField(item.getSomaValorVenalTerritorialPredial(), (SegmentoArquivoGrafica)SegmentoF.SOMA_VALOR_TERRITORIAL_PREDIAL);
        String areaTotalInscricao = this.formatField(item.getAreaTotalInscricao(), (SegmentoArquivoGrafica)SegmentoF.AREA_TOTAL_INSCRICAO);
        this.escreverLinha("F", new String[]{areaLote, areaTotalConstruida, valorVenalTerritorial, valorVenalPredial, somaTestadas, testadaPrincipal, aliquota, loteamento, descricaoLoteamento, somaValorTerritorialPredial, areaTotalInscricao});
    }

    public void gerarSegmentoJ(ArquivoGraficaItemDTO item) {
        String nomeCompromissario = this.formatField(item.getNomePessoaCompromissario(), (SegmentoArquivoGrafica)SegmentoJ.NOME_CONTRIBUINTE_COMPROMISSARIO);
        String verificacaoCpfCnpj = "0";
        if (Objects.nonNull(item.getCpfCnpjCompromissario())) {
            if (TipoPessoa.FISICA.getValue().equals(item.getTipoPessoaCompromissario())) {
                if (new CPF(item.getCpfCnpjCompromissario()).isValido()) {
                    verificacaoCpfCnpj = "1";
                }
            } else if (new CNPJ(item.getCpfCnpjCompromissario()).isValid()) {
                verificacaoCpfCnpj = "1";
            }
        }
        verificacaoCpfCnpj = this.formatField(verificacaoCpfCnpj, (SegmentoArquivoGrafica)SegmentoJ.VERIFICACAO_CPF_CNPJ_COMPROMISSARIO);
        String tipoPessoaCompromissario = this.formatField(item.getTipoPessoaCompromissario(), (SegmentoArquivoGrafica)SegmentoJ.TIPO_PESSOA_COMPROMISSARIO);
        String cpfCnpjCompromissario = this.formatField(item.getCpfCnpjCompromissario(), (SegmentoArquivoGrafica)SegmentoJ.DOCUMENTO_COMPROMISSARIO);
        String codigoContribuinte = this.formatField(item.getCodigoPessoaCompromissario(), (SegmentoArquivoGrafica)SegmentoJ.CODIGO_CONTRIBUINTE_COMPROMISSARIO);
        this.escreverLinha("J", new String[]{nomeCompromissario, verificacaoCpfCnpj, tipoPessoaCompromissario, cpfCnpjCompromissario, codigoContribuinte});
    }

    public void gerarSegmentoN(ArquivoGraficaItemDTO item) {
        ArrayList<String> camposFormatados = new ArrayList<String>();
        String valorTotalDebito = this.formatField(item.getValorTotalDebito(), (SegmentoArquivoGrafica)SegmentoN.VALOR_TOTAL_DEBITO);
        camposFormatados.add(valorTotalDebito);
        item.getTributosCarne().forEach(tributoCarne -> {
            camposFormatados.add(this.formatField(tributoCarne.getCodigoTributo(), (SegmentoArquivoGrafica)SegmentoN.CODIGO_RECEITA));
            camposFormatados.add(this.formatField(tributoCarne.getValorTributo(), (SegmentoArquivoGrafica)SegmentoN.VALOR_RECEITA));
            camposFormatados.add(this.formatField(tributoCarne.getDescricaoTributo(), (SegmentoArquivoGrafica)SegmentoN.DESCRICAO_RECEITA));
            camposFormatados.add(this.formatField(tributoCarne.getApelidoTributo(), (SegmentoArquivoGrafica)SegmentoN.APELIDO_RECEITA));
        });
        this.escreverLinha("N", camposFormatados.toArray(new String[0]));
    }

    public void gerarSegmentoO(List<ArquivoGraficaBoletoDTO> boletos) {
        boletos.forEach(boleto -> {
            ArrayList<String> camposFormatados = new ArrayList<String>();
            camposFormatados.add(this.formatField(boleto.getTipoFormaPagamento(), (SegmentoArquivoGrafica)SegmentoO.TIPO_PAGAMENTO));
            camposFormatados.add(this.formatField(boleto.getIdentificador(), (SegmentoArquivoGrafica)SegmentoO.IDENTIFICADOR));
            camposFormatados.add(this.formatField(boleto.getDataVencimento(), (SegmentoArquivoGrafica)SegmentoO.DATA_VENCIMENTO));
            camposFormatados.add(this.formatField(boleto.getInformacaoValorReceita(), (SegmentoArquivoGrafica)SegmentoO.INFORMACAO_VALOR_RECEITA));
            camposFormatados.add(this.formatField(boleto.getValorPrincipal(), (SegmentoArquivoGrafica)SegmentoO.VALOR_ORIGINAL));
            camposFormatados.add(this.formatField(boleto.getValorLiquido(), (SegmentoArquivoGrafica)SegmentoO.VALOR_LIQUIDO));
            camposFormatados.add(this.formatField(boleto.getCodigoBarras(), (SegmentoArquivoGrafica)SegmentoO.CODIGO_BARRAS));
            camposFormatados.add(this.formatField(boleto.getNossoNumero(), (SegmentoArquivoGrafica)SegmentoO.NOSSO_NUMERO));
            camposFormatados.add(this.formatField(boleto.getDvNossoNumero(), (SegmentoArquivoGrafica)SegmentoO.DV_NOSSO_NUMEO));
            camposFormatados.add(this.formatField(boleto.getCarne(), (SegmentoArquivoGrafica)SegmentoO.CARNE));
            camposFormatados.add(this.formatField(boleto.getBanco(), (SegmentoArquivoGrafica)SegmentoO.BANCO));
            camposFormatados.add(this.formatField(boleto.getAgencia(), (SegmentoArquivoGrafica)SegmentoO.AGENCIA));
            camposFormatados.add(this.formatField(boleto.getCodigoCedente(), (SegmentoArquivoGrafica)SegmentoO.CODIGO_CEDENTE));
            camposFormatados.add(this.formatField(boleto.getFormaPagamento(), (SegmentoArquivoGrafica)SegmentoO.FORMA_PAGAMENTO));
            camposFormatados.add(this.formatField(boleto.getLinhaDigitavel(), (SegmentoArquivoGrafica)SegmentoO.LINHA_DIGITAVEL));
            boleto.getTributosBoleto().forEach(tributoBoleto -> {
                camposFormatados.add(this.formatField(tributoBoleto.getCodigoTributo(), (SegmentoArquivoGrafica)SegmentoN.CODIGO_RECEITA));
                camposFormatados.add(this.formatField(tributoBoleto.getValorTributo(), (SegmentoArquivoGrafica)SegmentoN.VALOR_RECEITA));
                camposFormatados.add(this.formatField(tributoBoleto.getDescricaoTributo(), (SegmentoArquivoGrafica)SegmentoN.DESCRICAO_RECEITA));
                camposFormatados.add(this.formatField(tributoBoleto.getApelidoTributo(), (SegmentoArquivoGrafica)SegmentoN.APELIDO_RECEITA));
            });
            this.escreverLinha("O", camposFormatados.toArray(new String[0]));
        });
    }

    public void gerarSegmentoQ(List<ArquivoGraficaCampoVariavelDTO> camposVariaveis) {
        ArrayList camposFormatados = new ArrayList();
        camposVariaveis.forEach(campoVariavel -> camposFormatados.add(this.formatField(campoVariavel.getValor(), campoVariavel.getTamanho())));
        this.escreverLinha("Q", camposFormatados.toArray(new String[0]));
    }

    public void gerarSegmentoZ(int totalRegistros) {
        this.escreverLinha("Z", new String[]{this.formatField(Long.valueOf(totalRegistros), (SegmentoArquivoGrafica)SegmentoZ.TOTAL_REGISTROS)});
    }

    @Generated
    public ByteArrayOutputStream getOutStream() {
        return this.outStream;
    }
}

