/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.calculo.resource;

import br.com.elotech.core.resource.support.ReadOnlyResource;
import br.com.elotech.tributos.calculo.domain.Calculo;
import br.com.elotech.tributos.calculo.domain.CalculoCadastro;
import br.com.elotech.tributos.calculo.dto.CalculoCadastroResumidoDTO;
import br.com.elotech.tributos.calculo.dto.CalculoGeracaoLoteDTO;
import br.com.elotech.tributos.calculo.dto.CalculoLoteImpressaoDTO;
import br.com.elotech.tributos.calculo.dto.CalculoResumoDTO;
import br.com.elotech.tributos.calculo.dto.SimulacaoCalculoDTO;
import br.com.elotech.tributos.calculo.service.CalculoGeracaoLoteService;
import br.com.elotech.tributos.calculo.service.CalculoLoteImpressaoService;
import br.com.elotech.tributos.calculo.service.CalculoService;
import br.com.elotech.tributos.dto.CalculoFormaPagamentoDTO;
import br.com.elotech.tributos.service.batch.CalculoGeracaoCarneJobStarter;
import br.com.elotech.tributos.service.batch.GeracaoDebitoCalculoJobStarter;
import br.com.elotech.tributos.service.batch.SimulacaoCalculoJobStarter;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.springframework.batch.core.JobParametersInvalidException;
import org.springframework.batch.core.repository.JobExecutionAlreadyRunningException;
import org.springframework.batch.core.repository.JobInstanceAlreadyCompleteException;
import org.springframework.batch.core.repository.JobRestartException;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/calculo"})
public class CalculoResource
extends ReadOnlyResource<Calculo, Long> {
    private final CalculoService calculoService;
    private final CalculoGeracaoLoteService calculoGeracaoLoteService;
    private final CalculoLoteImpressaoService calculoLoteImpressaoService;
    private final SimulacaoCalculoJobStarter simulacaoCalculoJobStarter;
    private final GeracaoDebitoCalculoJobStarter geracaoDebitoCalculoJobStarter;
    private final CalculoGeracaoCarneJobStarter calculoGeracaoCarneJobStarter;

    public CalculoResource(CalculoService calculoService, CalculoGeracaoLoteService calculoGeracaoLoteService, CalculoLoteImpressaoService calculoLoteImpressaoService, SimulacaoCalculoJobStarter simulacaoCalculoJobStarter, GeracaoDebitoCalculoJobStarter geracaoDebitoCalculoJobStarter, CalculoGeracaoCarneJobStarter calculoGeracaoCarneJobStarter) {
        this.calculoService = calculoService;
        this.calculoGeracaoLoteService = calculoGeracaoLoteService;
        this.calculoLoteImpressaoService = calculoLoteImpressaoService;
        this.simulacaoCalculoJobStarter = simulacaoCalculoJobStarter;
        this.geracaoDebitoCalculoJobStarter = geracaoDebitoCalculoJobStarter;
        this.calculoGeracaoCarneJobStarter = calculoGeracaoCarneJobStarter;
    }

    @GetMapping(value={"/{id}/resumo"})
    public ResponseEntity<CalculoResumoDTO> findDto(@PathVariable(value="id") Long id) {
        return ResponseEntity.ok((Object)this.calculoService.findCalculoByIdWithTotais(id));
    }

    @PostMapping
    public ResponseEntity<Void> createSimulacao(@RequestBody @Valid SimulacaoCalculoDTO simulacaoCalculoDTO) throws JobParametersInvalidException, JobExecutionAlreadyRunningException, JobRestartException, JobInstanceAlreadyCompleteException {
        Calculo calculo = this.calculoService.createSimulacao(simulacaoCalculoDTO);
        this.simulacaoCalculoJobStarter.startJob(calculo.getId(), calculo.buildFilterCadastros());
        return ResponseEntity.ok().build();
    }

    @PutMapping(value={"/{id}/simular-novamente"})
    public ResponseEntity<Void> simularNovamente(@PathVariable(value="id") Long id) throws JobParametersInvalidException, JobExecutionAlreadyRunningException, JobRestartException, JobInstanceAlreadyCompleteException {
        Calculo calculo = this.calculoService.prepareSimularNovamente(id);
        this.simulacaoCalculoJobStarter.startJob(calculo.getId(), calculo.buildFilterCadastros());
        return ResponseEntity.ok().build();
    }

    @PutMapping(value={"/{id}/recalcular/{idCalculoCadastro}"})
    public ResponseEntity<CalculoCadastroResumidoDTO> recalcularCadastros(@PathVariable(value="id") Long id, @PathVariable(value="idCalculoCadastro") Long idCalculoCadastro) {
        return ResponseEntity.ok((Object)CalculoCadastroResumidoDTO.from((CalculoCadastro)this.calculoService.recalcularCadastro(id, idCalculoCadastro)));
    }

    @PutMapping(value={"/{id}/recalculo-cadastros-inconsistentes"})
    public ResponseEntity<List<CalculoCadastroResumidoDTO>> recalcularAllCadastrosInconsistentes(@PathVariable(value="id") Long id) {
        return ResponseEntity.ok(this.calculoService.recalcularAllCadastrosInconsistentes(id).stream().map(CalculoCadastroResumidoDTO::from).collect(Collectors.toList()));
    }

    @PutMapping(value={"/{id}/cancelar"})
    public ResponseEntity<CalculoResumoDTO> cancelarSimulacao(@PathVariable(value="id") Long id) {
        return ResponseEntity.ok((Object)CalculoResumoDTO.of((Calculo)this.calculoService.cancelarSimulacao(id)));
    }

    @PostMapping(value={"/{id}/gerar-debito"})
    public ResponseEntity<CalculoResumoDTO> gerarDebito(@PathVariable(value="id") Long id) throws JobParametersInvalidException, JobExecutionAlreadyRunningException, JobRestartException, JobInstanceAlreadyCompleteException {
        this.geracaoDebitoCalculoJobStarter.startJob(id);
        return ResponseEntity.ok().build();
    }

    @GetMapping(value={"/{id}/cadastros"})
    public ResponseEntity<Page<CalculoCadastroResumidoDTO>> findCadastrosWithPagination(@PathVariable Long id, @RequestParam(value="search", required=false) String search, @RequestParam(value="inconsistentes", required=false, defaultValue="false") Boolean somenteInconsistentes, Pageable pageable) {
        return ResponseEntity.ok((Object)this.calculoService.findCadastrosWithPagination(id, search, somenteInconsistentes, pageable));
    }

    @GetMapping(value={"/{id}/lote-geracao"})
    public ResponseEntity<Page<CalculoGeracaoLoteDTO>> findLotesGeracaoByCalculoId(@PathVariable Long id, @RequestParam(value="search", required=false) String search, Pageable pageable) {
        return ResponseEntity.ok((Object)this.calculoGeracaoLoteService.findByCalculoId(id, search, pageable));
    }

    @GetMapping(value={"/{id}/lote-impressao"})
    public ResponseEntity<Page<CalculoLoteImpressaoDTO>> findLotesImpressaoByCalculoId(@PathVariable Long id, @RequestParam(value="search", required=false) String search, Pageable pageable) {
        return ResponseEntity.ok((Object)this.calculoLoteImpressaoService.findbyCalculoId(id, search, pageable));
    }

    @PostMapping(value={"/{id}/finalizar-geracao-lote"})
    public ResponseEntity<CalculoResumoDTO> finalizarGeracaoLoteImpressao(@PathVariable Long id) {
        return ResponseEntity.ok((Object)this.calculoService.finalizarGeracaoLoteImpressao(id));
    }

    @GetMapping(value={"/{id}/formas-pagamento-disponiveis"})
    public ResponseEntity<List<CalculoFormaPagamentoDTO>> findFormasPagamentoDisponiveis(@PathVariable Long id) {
        return ResponseEntity.ok((Object)this.calculoService.findFormasPagamentosDisponiveis(id));
    }

    @PostMapping(value={"/{id}/formas-pagamento"})
    public ResponseEntity<Void> saveFormasPagamento(@PathVariable Long id, @RequestBody List<CalculoFormaPagamentoDTO> formasPagamento) {
        this.calculoService.saveFormasPagamento(id, formasPagamento);
        return ResponseEntity.noContent().build();
    }

    @PostMapping(value={"/{idCalculo}/gerarCarnes"})
    public ResponseEntity<Void> gerarCarnes(@PathVariable(value="idCalculo") Long idCalculo) throws JobParametersInvalidException, JobExecutionAlreadyRunningException, JobRestartException, JobInstanceAlreadyCompleteException {
        this.calculoGeracaoCarneJobStarter.startJob(idCalculo);
        return ResponseEntity.ok().build();
    }

    @PutMapping(value={"{idCalculo}/constituir-debitos"})
    public ResponseEntity<Void> constituirDebitosCalculo(@PathVariable(name="idCalculo") Long idCalculo) {
        this.calculoService.constituirDebitos(idCalculo);
        return ResponseEntity.ok().build();
    }
}

