/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.calculo.resource;

import br.com.elotech.core.exception.RestException;
import br.com.elotech.core.resource.support.ReadOnlyResource;
import br.com.elotech.tributos.calculo.domain.CalculoGeracaoLote;
import br.com.elotech.tributos.calculo.dto.CalculoGeracaoLoteDTO;
import br.com.elotech.tributos.calculo.dto.CampoDetalheDTO;
import br.com.elotech.tributos.calculo.service.CalculoGeracaoLoteService;
import java.io.Serializable;
import java.util.List;
import javax.validation.Valid;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/lotes-geracao"})
public class CalculoGeracaoLoteResource
extends ReadOnlyResource<CalculoGeracaoLote, Long> {
    private final CalculoGeracaoLoteService calculoGeracaoLoteService;

    public CalculoGeracaoLoteResource(CalculoGeracaoLoteService calculoGeracaoLoteService) {
        this.calculoGeracaoLoteService = calculoGeracaoLoteService;
    }

    @PostMapping
    public ResponseEntity<CalculoGeracaoLoteDTO> createConfiguracaoLote(@RequestBody @Valid CalculoGeracaoLoteDTO calculoGeracaoLoteDTO) {
        return ResponseEntity.ok((Object)this.calculoGeracaoLoteService.createConfiguracaoAndLote(calculoGeracaoLoteDTO));
    }

    @GetMapping(value={"/search"})
    public ResponseEntity<List<CampoDetalheDTO>> searchCampos(@RequestParam String search) {
        return ResponseEntity.ok((Object)this.calculoGeracaoLoteService.searchCampos(search));
    }

    @GetMapping(value={"/{id}/resumo"})
    public ResponseEntity<CalculoGeracaoLoteDTO> getResumo(@PathVariable Long id) {
        CalculoGeracaoLote calculoGeracaoLote = (CalculoGeracaoLote)this.calculoGeracaoLoteService.findById((Serializable)id).orElseThrow(RestException::notFound);
        return ResponseEntity.ok((Object)CalculoGeracaoLoteDTO.of((CalculoGeracaoLote)calculoGeracaoLote));
    }
}

