/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.calculo.resource;

import br.com.elotech.core.resource.support.ReadOnlyResource;
import br.com.elotech.tributos.calculo.domain.ArquivoGraficaConfig;
import br.com.elotech.tributos.calculo.domain.ArquivoGraficaConfigDTO;
import br.com.elotech.tributos.calculo.dto.CampoDetalheDTO;
import br.com.elotech.tributos.calculo.service.ArquivoGraficaConfigService;
import br.com.elotech.tributos.domain.TipoDivida;
import java.util.List;
import javax.validation.Valid;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/arquivo-grafica"})
public class ArquivoGraficaConfigResource
extends ReadOnlyResource<ArquivoGraficaConfig, Long> {
    private final ArquivoGraficaConfigService arquivoGraficaConfigService;

    public ArquivoGraficaConfigResource(ArquivoGraficaConfigService arquivoGraficaConfigService) {
        this.arquivoGraficaConfigService = arquivoGraficaConfigService;
    }

    @GetMapping(value={"/load/{id}"})
    public ResponseEntity<ArquivoGraficaConfigDTO> loadDTO(@PathVariable Long id) {
        return ResponseEntity.ok((Object)this.arquivoGraficaConfigService.loadDTO(id));
    }

    @PostMapping(value={"/save"})
    public ResponseEntity<ArquivoGraficaConfigDTO> saveDTO(@RequestBody @Valid ArquivoGraficaConfigDTO dto) {
        return ResponseEntity.ok((Object)this.arquivoGraficaConfigService.saveDTO(dto));
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<Void> delete(@PathVariable Long id) {
        this.arquivoGraficaConfigService.delete(id);
        return ResponseEntity.ok().build();
    }

    @GetMapping(value={"/search"})
    public ResponseEntity<List<CampoDetalheDTO>> searchCampos(@RequestParam String tipoDivida, @RequestParam String search) {
        return ResponseEntity.ok((Object)this.arquivoGraficaConfigService.searchCampos(TipoDivida.fromValue((String)tipoDivida), search));
    }
}

