/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.calculo.dto;

import br.com.elotech.tributos.calculo.dto.CalculoContext;
import br.com.elotech.tributos.calculo.dto.ImobiliarioDTO;
import br.com.elotech.tributos.calculo.dto.ImobiliarioSegmentoDTO;
import br.com.elotech.tributos.calculo.dto.ImobiliarioTestadaDTO;
import br.com.elotech.tributos.calculo.dto.ImobiliarioTestadaGenericaDTO;
import br.com.elotech.tributos.calculo.dto.RespostaDTO;
import br.com.elotech.tributos.calculo.exception.CalculoException;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CalculoImobiliarioContext
extends CalculoContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(CalculoImobiliarioContext.class);
    public ImobiliarioDTO cadastro;
    public ImobiliarioSegmentoDTO segmento;
    public ImobiliarioTestadaDTO testada;
    public ImobiliarioTestadaGenericaDTO testadagenerica;

    public Double campo(ImobiliarioSegmentoDTO segmento, String identificador) {
        return Double.valueOf(this.campotexto(segmento, identificador));
    }

    public Integer campointeiro(ImobiliarioSegmentoDTO segmento, String identificador) {
        return Integer.valueOf(this.campotexto(segmento, identificador));
    }

    public String campotexto(ImobiliarioSegmentoDTO segmento, String identificador) {
        return this.campotexto(segmento, identificador, null);
    }

    public Double campo(ImobiliarioSegmentoDTO segmento, String identificador, Object valorDefault) {
        return Double.valueOf(this.campotexto(segmento, identificador, valorDefault));
    }

    public Integer campointeiro(ImobiliarioSegmentoDTO segmento, String identificador, Object valorDefault) {
        return Integer.valueOf(this.campotexto(segmento, identificador, valorDefault));
    }

    public String campotexto(ImobiliarioSegmentoDTO segmento, String identificador, Object valorDefault) {
        if (Objects.isNull(segmento)) {
            throw new CalculoException("Cadastro sem valor para segmento");
        }
        String valor = segmento.getBoletim().getOrDefault(identificador.toLowerCase(), new RespostaDTO()).getValor();
        if (Objects.isNull(valor)) {
            if (Objects.isNull(valorDefault)) {
                throw new CalculoException(String.format("Campo do boletim de segmento \"%s\" nulo", identificador));
            }
            valor = valorDefault.toString();
        }
        this.addTrace(this.registroTraceAtual, String.format("campo(segmento, \"%s\")", identificador), (Object)valor);
        LOGGER.trace("Campo do boletim de segmento {}, valor {}", (Object)identificador, (Object)valor);
        return valor;
    }

    public Double valoralternativa(ImobiliarioSegmentoDTO segmento, String identificador) {
        if (Objects.isNull(segmento)) {
            throw new CalculoException("Cadastro sem valor para segmento");
        }
        RespostaDTO resposta = (RespostaDTO)segmento.getBoletim().get(identificador);
        if (Objects.isNull(resposta)) {
            throw new CalculoException(String.format("Campo do boletim de segmento \"%s\" nulo", identificador));
        }
        if (Objects.isNull(resposta.getAlternativaValor())) {
            throw new CalculoException(String.format("Campo do boletim de segmento \"%s\" n\u00e3o possui valor de m\u00faltipla escolha", identificador));
        }
        this.addTrace(this.registroTraceAtual, String.format("valoralternativa(segmento, \"%s\")", identificador), (Object)resposta.getAlternativaValor());
        LOGGER.trace("Campo do boletim de segmento {}, valor alternativa {}", (Object)identificador, (Object)resposta.getAlternativaValor());
        return resposta.getAlternativaValor();
    }

    public Double campo(ImobiliarioTestadaDTO testada, String identificador) {
        return Double.valueOf(this.campotexto(testada, identificador, null));
    }

    public Integer campointeiro(ImobiliarioTestadaDTO testada, String identificador) {
        return Integer.valueOf(this.campotexto(testada, identificador, null));
    }

    public String campotexto(ImobiliarioTestadaDTO testada, String identificador) {
        return this.campotexto(testada, identificador, null);
    }

    public Double campo(ImobiliarioTestadaDTO testada, String identificador, Object valorDefault) {
        return Double.valueOf(this.campotexto(testada, identificador, valorDefault));
    }

    public Integer campointeiro(ImobiliarioTestadaDTO testada, String identificador, Object valorDefault) {
        return Integer.valueOf(this.campotexto(testada, identificador, valorDefault));
    }

    public String campotexto(ImobiliarioTestadaDTO testada, String identificador, Object valorDefault) {
        if (Objects.isNull(testada)) {
            throw new CalculoException("Cadastro sem valor para testada");
        }
        String valor = testada.getBoletim().getOrDefault(identificador.toLowerCase(), new RespostaDTO()).getValor();
        if (Objects.isNull(valor)) {
            if (Objects.isNull(valorDefault)) {
                throw new CalculoException(String.format("Campo do boletim de testada \"%s\" nulo", identificador));
            }
            valor = valorDefault.toString();
        }
        this.addTrace(this.registroTraceAtual, String.format("campo(testada, \"%s\")", identificador), (Object)valor);
        LOGGER.trace("Campo do boletim de testada {}, valor {}", (Object)identificador, (Object)valor);
        return valor;
    }

    public Double valoralternativa(ImobiliarioTestadaDTO testada, String identificador) {
        if (Objects.isNull(testada)) {
            throw new CalculoException("Cadastro sem valor para testada");
        }
        RespostaDTO resposta = (RespostaDTO)testada.getBoletim().get(identificador);
        if (Objects.isNull(resposta)) {
            throw new CalculoException(String.format("Campo do boletim de testada \"%s\" nulo", identificador));
        }
        if (Objects.isNull(resposta.getAlternativaValor())) {
            throw new CalculoException(String.format("Campo do boletim de testada \"%s\" n\u00e3o possui valor de m\u00faltipla escolha", identificador));
        }
        this.addTrace(this.registroTraceAtual, String.format("valoralternativa(testada, \"%s\")", identificador), (Object)resposta.getAlternativaValor());
        LOGGER.trace("Campo do boletim de testada {}, valor alternativa {}", (Object)identificador, (Object)resposta.getAlternativaValor());
        return resposta.getAlternativaValor();
    }

    @Generated
    public ImobiliarioDTO getCadastro() {
        return this.cadastro;
    }

    @Generated
    public ImobiliarioSegmentoDTO getSegmento() {
        return this.segmento;
    }

    @Generated
    public ImobiliarioTestadaDTO getTestada() {
        return this.testada;
    }

    @Generated
    public ImobiliarioTestadaGenericaDTO getTestadagenerica() {
        return this.testadagenerica;
    }

    @Generated
    public void setCadastro(ImobiliarioDTO cadastro) {
        this.cadastro = cadastro;
    }

    @Generated
    public void setSegmento(ImobiliarioSegmentoDTO segmento) {
        this.segmento = segmento;
    }

    @Generated
    public void setTestada(ImobiliarioTestadaDTO testada) {
        this.testada = testada;
    }

    @Generated
    public void setTestadagenerica(ImobiliarioTestadaGenericaDTO testadagenerica) {
        this.testadagenerica = testadagenerica;
    }
}

