/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.calculo.domain;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.metamodel.annotation.MetaModelIgnore;
import br.com.elotech.tributos.calculo.domain.CalculoCadastro;
import br.com.elotech.tributos.calculo.domain.CalculoLinha;
import br.com.elotech.tributos.calculo.domain.CalculoResultadoDeducao;
import br.com.elotech.tributos.calculo.dto.CalculoResultadoDTO;
import br.com.elotech.tributos.domain.calculo.CalculoTributo;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import lombok.Generated;

@Table(name="calculoresultado")
@Entity
public class CalculoResultado
implements EloEntity<Long> {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="seq_calculoresultado")
    @SequenceGenerator(name="seq_calculoresultado", sequenceName="seq_calculoresultado")
    private Long id;
    @ManyToOne
    private CalculoTributo calculoTributo;
    private BigDecimal valor = BigDecimal.ZERO;
    private BigDecimal valorBaseCalculo = BigDecimal.ZERO;
    private BigDecimal aliquota = BigDecimal.ZERO;
    @OneToMany(mappedBy="calculoResultado", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<CalculoResultadoDeducao> deducoes = new ArrayList();
    @OneToMany(mappedBy="calculoResultado", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<CalculoLinha> linhas = new ArrayList();
    @MetaModelIgnore
    @JsonIgnore
    @ManyToOne
    @JoinColumn(name="calculocadastro")
    private CalculoCadastro calculoCadastro;

    public static CalculoResultado from(CalculoCadastro calculoCadastro, CalculoTributo tributo, CalculoResultadoDTO resultado) {
        CalculoResultado calculoResultado = new CalculoResultado();
        calculoResultado.setCalculoTributo(tributo);
        calculoResultado.setCalculoCadastro(calculoCadastro);
        Optional.ofNullable(resultado.getValor()).map(BigDecimal::valueOf).ifPresent(arg_0 -> calculoResultado.setValor(arg_0));
        Optional.ofNullable(resultado.getValorBase()).map(BigDecimal::valueOf).ifPresent(arg_0 -> calculoResultado.setValorBaseCalculo(arg_0));
        Optional.ofNullable(resultado.getValorAliquota()).map(BigDecimal::valueOf).ifPresent(arg_0 -> calculoResultado.setAliquota(arg_0));
        return calculoResultado;
    }

    public BigDecimal getValorDeducoes() {
        return Optional.ofNullable(this.deducoes).map(deducao -> deducao.stream().map(CalculoResultadoDeducao::getValor).reduce(BigDecimal.ZERO, BigDecimal::add)).orElse(BigDecimal.ZERO);
    }

    public BigDecimal getValorTotal() {
        return this.valor.subtract(this.getValorDeducoes());
    }

    @Generated
    public CalculoResultado() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public CalculoTributo getCalculoTributo() {
        return this.calculoTributo;
    }

    @Generated
    public BigDecimal getValor() {
        return this.valor;
    }

    @Generated
    public BigDecimal getValorBaseCalculo() {
        return this.valorBaseCalculo;
    }

    @Generated
    public BigDecimal getAliquota() {
        return this.aliquota;
    }

    @Generated
    public List<CalculoResultadoDeducao> getDeducoes() {
        return this.deducoes;
    }

    @Generated
    public List<CalculoLinha> getLinhas() {
        return this.linhas;
    }

    @Generated
    public CalculoCadastro getCalculoCadastro() {
        return this.calculoCadastro;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setCalculoTributo(CalculoTributo calculoTributo) {
        this.calculoTributo = calculoTributo;
    }

    @Generated
    public void setValor(BigDecimal valor) {
        this.valor = valor;
    }

    @Generated
    public void setValorBaseCalculo(BigDecimal valorBaseCalculo) {
        this.valorBaseCalculo = valorBaseCalculo;
    }

    @Generated
    public void setAliquota(BigDecimal aliquota) {
        this.aliquota = aliquota;
    }

    @Generated
    public void setDeducoes(List<CalculoResultadoDeducao> deducoes) {
        this.deducoes = deducoes;
    }

    @Generated
    public void setLinhas(List<CalculoLinha> linhas) {
        this.linhas = linhas;
    }

    @Generated
    public void setCalculoCadastro(CalculoCadastro calculoCadastro) {
        this.calculoCadastro = calculoCadastro;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CalculoResultado)) {
            return false;
        }
        CalculoResultado other = (CalculoResultado)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CalculoResultado;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "CalculoResultado(id=" + this.getId() + ", calculoTributo=" + this.getCalculoTributo() + ", valor=" + this.getValor() + ", valorBaseCalculo=" + this.getValorBaseCalculo() + ")";
    }
}

