/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.simulacaocalculo;

import java.util.Map;
import javax.sql.DataSource;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.database.JdbcPagingItemReader;
import org.springframework.batch.item.database.support.SqlPagingQueryProviderFactoryBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
@StepScope
public class SimulacaoCalculoBatchReader
extends JdbcPagingItemReader<Long> {
    public SimulacaoCalculoBatchReader(@Value(value="#{jobParameters}") Map<String, Object> jobParameters, DataSource dataSource) throws Exception {
        this.setFetchSize(50);
        this.setName("idCadastroGeral");
        this.setDataSource(dataSource);
        this.setRowMapper((rs, rowNum) -> rs.getLong("idkey"));
        this.setQueryProvider(this.queryProvider(jobParameters, dataSource).getObject());
    }

    private SqlPagingQueryProviderFactoryBean queryProvider(Map<String, Object> jobParameters, DataSource dataSource) {
        String filtroCadastro = (String)jobParameters.get("filtroCadastro");
        SqlPagingQueryProviderFactoryBean provider = new SqlPagingQueryProviderFactoryBean();
        provider.setDataSource(dataSource);
        provider.setSelectClause("select idkey");
        provider.setFromClause("from tribcadastrogeral cadastrogeral");
        provider.setWhereClause(String.format("where exclusaologica = 'N' and %s ", filtroCadastro));
        provider.setSortKey("idkey");
        return provider;
    }
}

