/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.geracaodebitocalculo;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.tributos.calculo.domain.CalculoCadastro;
import br.com.elotech.tributos.calculo.service.CalculoCadastroService;
import br.com.elotech.tributos.calculo.service.CalculoService;
import java.util.List;
import javax.persistence.EntityManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.annotation.BeforeStep;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.ItemWriter;
import org.springframework.stereotype.Component;

@StepScope
@Component
public class GeracaoDebitoCalculoBatchWriter
implements ItemWriter<CalculoCadastro> {
    private static final Logger LOGGER = LoggerFactory.getLogger(GeracaoDebitoCalculoBatchWriter.class);
    private final CalculoService calculoService;
    private final CalculoCadastroService calculoCadastroService;
    private final EntityManager entityManager;
    private StepExecution stepExecution;

    public GeracaoDebitoCalculoBatchWriter(CalculoService calculoService, CalculoCadastroService calculoCadastroService, EntityManager entityManager) {
        this.calculoService = calculoService;
        this.calculoCadastroService = calculoCadastroService;
        this.entityManager = entityManager;
    }

    @BeforeStep
    void beforeStep(StepExecution stepExecution) {
        this.stepExecution = stepExecution;
    }

    public void write(List<? extends CalculoCadastro> items) {
        LOGGER.info("Salvando a gera\u00e7\u00e3o de d\u00e9bitos dos cadastros. Read count {}. Job Id {}.", (Object)this.stepExecution.getReadCount(), (Object)this.stepExecution.getJobExecution().getId());
        items.forEach(calculoCadastro -> this.calculoCadastroService.save((EloEntity)calculoCadastro, null));
        this.entityManager.flush();
    }
}

