/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.calculoloteimpressaogeracaocarne;

import java.util.Map;
import javax.sql.DataSource;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.database.JdbcPagingItemReader;
import org.springframework.batch.item.database.support.SqlPagingQueryProviderFactoryBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
@StepScope
public class CalculoGeracaoCarneBatchReader
extends JdbcPagingItemReader<Long> {
    public CalculoGeracaoCarneBatchReader(@Value(value="#{jobParameters}") Map<String, Object> jobParameters, DataSource dataSource) throws Exception {
        this.setFetchSize(10);
        this.setName("calculoLoteImpressaoItemId");
        this.setDataSource(dataSource);
        this.setRowMapper((rs, rowNum) -> rs.getLong("id"));
        this.setQueryProvider(this.queryProvider(jobParameters, dataSource).getObject());
    }

    private SqlPagingQueryProviderFactoryBean queryProvider(Map<String, Object> jobParameters, DataSource dataSource) {
        SqlPagingQueryProviderFactoryBean provider = new SqlPagingQueryProviderFactoryBean();
        Long idCalculo = (Long)jobParameters.get("idCalculo");
        provider.setDataSource(dataSource);
        provider.setSelectClause("SELECT id");
        provider.setFromClause("FROM calculoloteimpressaoitem clii");
        provider.setWhereClause(String.format("WHERE exists (    select *       from calculocadastro cc       where clii.idcalculocadastro = cc.id       and cc.calculo = %d )", idCalculo));
        provider.setSortKey("id");
        return provider;
    }
}

