/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.baixaautomatica;

import br.com.elotech.tributos.domain.pagamento.BaixaAutomaticaDetalhe;
import br.com.elotech.tributos.domain.pagamento.PagamentoLote;
import br.com.elotech.tributos.service.PagamentoLoteService;
import br.com.elotech.tributos.service.ProcessaPagamentoLoteService;
import java.util.List;
import javax.persistence.EntityManager;
import org.hibernate.Hibernate;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.annotation.BeforeStep;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.ItemWriter;
import org.springframework.stereotype.Component;

@Component
@StepScope
public class BaixaAutomaticaBatchWriter
implements ItemWriter<BaixaAutomaticaDetalhe> {
    private final ProcessaPagamentoLoteService processaPagamentoLoteService;
    private final PagamentoLoteService pagamentoLoteService;
    private final EntityManager entityManager;
    private StepExecution stepExecution;

    public BaixaAutomaticaBatchWriter(ProcessaPagamentoLoteService processaPagamentoLoteService, PagamentoLoteService pagamentoLoteService, EntityManager entityManager) {
        this.processaPagamentoLoteService = processaPagamentoLoteService;
        this.pagamentoLoteService = pagamentoLoteService;
        this.entityManager = entityManager;
    }

    @BeforeStep
    void beforeStep(StepExecution stepExecution) {
        this.stepExecution = stepExecution;
    }

    public void write(List<? extends BaixaAutomaticaDetalhe> items) {
        Long entidade = this.stepExecution.getJobParameters().getLong("entidade");
        Long exercicio = this.stepExecution.getJobParameters().getLong("exercicio");
        Long lote = this.stepExecution.getJobParameters().getLong("lote");
        PagamentoLote pagamentoLote = (PagamentoLote)Hibernate.unproxy((Object)this.pagamentoLoteService.findByPagamentoLote(entidade, exercicio, lote));
        this.processaPagamentoLoteService.fechaLoteSeTodasSequenciasBaixadas(pagamentoLote);
        this.entityManager.flush();
    }
}

