/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.ws.rest;

import br.com.elotech.tributos.config.HttpEntityFactory;
import br.com.elotech.tributos.config.TributosProperties;
import br.com.elotech.tributos.dto.parcelamento.AiseEstornoParcelamentoDTO;
import br.com.elotech.tributos.dto.parcelamento.AiseParcelamentoDTO;
import br.com.elotech.tributos.dto.parcelamento.SimulacaoEstornoParcelamentoDTO;
import br.com.elotech.tributos.service.AiseDebitoService;
import br.com.elotech.tributos.service.ws.AiseEstornoParcelamentoService;
import br.com.elotech.tributos.service.ws.rest.AiseLoginServiceRest;
import java.util.List;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
public class AiseEstornoParcelamentoServiceRest
implements AiseEstornoParcelamentoService {
    private final RestTemplate restTemplate;
    private final AiseLoginServiceRest aiseLoginServiceRest;
    private final TributosProperties tributosProperties;
    private final AiseDebitoService debitoService;

    public AiseEstornoParcelamentoServiceRest(RestTemplate restTemplate, AiseLoginServiceRest aiseLoginServiceRest, TributosProperties tributosProperties, AiseDebitoService debitoService) {
        this.restTemplate = restTemplate;
        this.aiseLoginServiceRest = aiseLoginServiceRest;
        this.tributosProperties = tributosProperties;
        this.debitoService = debitoService;
    }

    public SimulacaoEstornoParcelamentoDTO simularEstornoParcelamento(AiseEstornoParcelamentoDTO request) {
        HttpHeaders headers = this.aiseLoginServiceRest.getHttpAuthorizationHeaders();
        AiseParcelamentoDTO parcelamentoDTO = (AiseParcelamentoDTO)this.restTemplate.exchange(this.tributosProperties.getAise().getWsBaseUrl() + "/datasnap/rest/tEstornoParcelamento/simular", HttpMethod.POST, HttpEntityFactory.createHttpEntity((Object)request, (HttpHeaders)headers), AiseParcelamentoDTO.class, new Object[0]).getBody();
        return SimulacaoEstornoParcelamentoDTO.from((AiseParcelamentoDTO)parcelamentoDTO, (List)this.debitoService.getDebitosParcelamento(request.getIdParcelamento()));
    }

    public AiseEstornoParcelamentoDTO estornarParcelamento(AiseEstornoParcelamentoDTO request) {
        HttpHeaders headers = this.aiseLoginServiceRest.getHttpAuthorizationHeaders();
        return (AiseEstornoParcelamentoDTO)this.restTemplate.exchange(this.tributosProperties.getAise().getWsBaseUrl() + "/datasnap/rest/tEstornoParcelamento/executar", HttpMethod.POST, HttpEntityFactory.createHttpEntity((Object)request, (HttpHeaders)headers), AiseEstornoParcelamentoDTO.class, new Object[0]).getBody();
    }

    public void desfazerEstornoParcelamento(Long idEstornoParcelamento) {
        HttpHeaders headers = this.aiseLoginServiceRest.getHttpAuthorizationHeaders();
        AiseEstornoParcelamentoDTO request = new AiseEstornoParcelamentoDTO();
        request.setIdEstornoParcelamento(idEstornoParcelamento);
        this.restTemplate.exchange(this.tributosProperties.getAise().getWsBaseUrl() + "/datasnap/rest/tEstornoParcelamento/desfazer", HttpMethod.POST, HttpEntityFactory.createHttpEntity((Object)request, (HttpHeaders)headers), AiseEstornoParcelamentoDTO.class, new Object[0]).getBody();
    }
}

