/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.documento.cda;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.documento.cda.SituacaoLoteCda;
import br.com.elotech.tributos.repository.documento.cda.LoteCdaItemRepository;
import java.util.Objects;
import org.springframework.stereotype.Service;

@Service
public class LoteCdaItemService {
    private final LoteCdaItemRepository loteCdaItemRepository;

    public LoteCdaItemService(LoteCdaItemRepository loteCdaItemRepository) {
        this.loteCdaItemRepository = loteCdaItemRepository;
    }

    public SituacaoLoteCda getSituacaoLoteByItemId(Long itemId) {
        return this.loteCdaItemRepository.getSituacaoLote(itemId);
    }

    public void deleteById(Long id) {
        SituacaoLoteCda situacaoLote = this.loteCdaItemRepository.getSituacaoLote(id);
        if (Objects.isNull(situacaoLote)) {
            throw new EloValidationException("N\u00e3o foi poss\u00edvel encontrar item");
        }
        if (!SituacaoLoteCda.SIMULACAO_GERADA.equals((Object)situacaoLote)) {
            throw new EloValidationException(String.format("N\u00e3o \u00e9 permitido remover itens de lote com situa\u00e7\u00e3o diferente de %s", SituacaoLoteCda.SIMULACAO_GERADA.getDescricao()));
        }
        this.loteCdaItemRepository.deleteById((Object)id);
    }
}

