/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.arquivos.client.ArquivoClient;
import br.com.elotech.arquivos.domain.Arquivo;
import br.com.elotech.arquivos.domain.request.ArquivoDownloadRequest;
import br.com.elotech.arquivos.domain.request.ArquivoFindRequest;
import br.com.elotech.arquivos.domain.request.ArquivoNovoRequest;
import br.com.elotech.arquivos.domain.response.ArquivoContent;
import br.com.elotech.arquivos.domain.response.ArquivoUrl;
import br.com.elotech.arquivos.domain.support.ContentType;
import br.com.elotech.arquivos.domain.support.Tenant;
import br.com.elotech.console.dto.Modulo;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.DebitoParcela;
import br.com.elotech.tributos.domain.Pagamento;
import br.com.elotech.tributos.domain.ParametroGeralEnum;
import br.com.elotech.tributos.domain.SituacaoParcelamento;
import br.com.elotech.tributos.domain.parcelamento.ParamParcelamento;
import br.com.elotech.tributos.domain.parcelamento.Parcelamento;
import br.com.elotech.tributos.domain.parcelamento.SituacaoParcelamentoEnum;
import br.com.elotech.tributos.domain.parcelamento.TipoParcelamento;
import br.com.elotech.tributos.domain.relatorio.Relatorio;
import br.com.elotech.tributos.dto.DebitoIdDTO;
import br.com.elotech.tributos.dto.ImprimirRelatorioDTO;
import br.com.elotech.tributos.dto.SubReportDTO;
import br.com.elotech.tributos.dto.SubReportItemDTO;
import br.com.elotech.tributos.dto.ValueBlockDashDTO;
import br.com.elotech.tributos.dto.parcelamento.EstornoParcelamentoRowDTO;
import br.com.elotech.tributos.dto.parcelamento.ImprimirContratoDTO;
import br.com.elotech.tributos.dto.parcelamento.ParcelamentoDTO;
import br.com.elotech.tributos.dto.parcelamento.ParcelamentoDebitoDTO;
import br.com.elotech.tributos.dto.parcelamento.ParcelamentoDebitoParcelasDTO;
import br.com.elotech.tributos.exception.ImpressaoContratoParcelamentoException;
import br.com.elotech.tributos.report.loader.ContratoParcelamentoParamLoader;
import br.com.elotech.tributos.repository.PagamentoRepository;
import br.com.elotech.tributos.repository.parcelamento.ParamParcelamentoRepository;
import br.com.elotech.tributos.repository.parcelamento.ParcelamentoRepository;
import br.com.elotech.tributos.service.EstornoParcelamentoService;
import br.com.elotech.tributos.service.ParametroGeralService;
import br.com.elotech.tributos.service.SituacaoParcelamentoService;
import br.com.elotech.tributos.service.ws.AiseRelatorioService;
import br.com.elotech.tributos.utils.TenantUtils;
import com.google.common.collect.Sets;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.server.ResponseStatusException;

@Service
public class ParcelamentoService
extends CrudService<Parcelamento, Long> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ParcelamentoService.class);
    private static final Integer RELATORIO_SITUACAO_CONTRATO = 1054;
    private final ParcelamentoRepository parcelamentoRepository;
    private final ParamParcelamentoRepository paramParcelamentoRepository;
    private final ContratoParcelamentoParamLoader contratoParcelamentoParamLoader;
    private final EstornoParcelamentoService estornoParcelamentoService;
    private final ParametroGeralService parametroGeralService;
    private final PagamentoRepository pagamentoRepository;
    private final SituacaoParcelamentoService situacaoParcelamentoService;
    private final ArquivoClient arquivoClient;
    private final ArquivoClient arquivoClientNovo;
    private final AiseRelatorioService aiseRelatorioService;

    @Autowired
    public ParcelamentoService(ParcelamentoRepository parcelamentoRepository, ParamParcelamentoRepository paramParcelamentoRepository, ContratoParcelamentoParamLoader contratoParcelamentoParamLoader, EstornoParcelamentoService estornoParcelamentoService, ParametroGeralService parametroGeralService, PagamentoRepository pagamentoRepository, SituacaoParcelamentoService situacaoParcelamentoService, ArquivoClient arquivoClient, @Qualifier(value="novo") ArquivoClient arquivoClientNovo, AiseRelatorioService aiseRelatorioService) {
        this.parcelamentoRepository = parcelamentoRepository;
        this.paramParcelamentoRepository = paramParcelamentoRepository;
        this.contratoParcelamentoParamLoader = contratoParcelamentoParamLoader;
        this.estornoParcelamentoService = estornoParcelamentoService;
        this.parametroGeralService = parametroGeralService;
        this.pagamentoRepository = pagamentoRepository;
        this.situacaoParcelamentoService = situacaoParcelamentoService;
        this.arquivoClient = arquivoClient;
        this.arquivoClientNovo = arquivoClientNovo;
        this.aiseRelatorioService = aiseRelatorioService;
    }

    public List<ParcelamentoDebitoDTO> findParcelamentoDebitoOrigem(Long idParcelamento) {
        return this.parcelamentoRepository.findParcelamentoDebitoOrigem(idParcelamento);
    }

    public List<ParcelamentoDebitoDTO> findParcelamentoDebitoNovo(Long idParcelamento) {
        return this.parcelamentoRepository.findParcelamentoDebitoNovo(idParcelamento);
    }

    public List<ParcelamentoDebitoParcelasDTO> findParcelamentoDebitoParcelas(Long idParcelamento) {
        return this.parcelamentoRepository.findParcelamentoDebitoParcelas(idParcelamento);
    }

    public ImprimirRelatorioDTO getImprimirContratoDTO(Long idParcelamento) {
        Long idParamParcelamento = this.findIdParamParcelamento(idParcelamento);
        ParamParcelamento paramParcelamento = this.findParamParcelamento(idParamParcelamento);
        Relatorio relatorioContrato = Optional.ofNullable(paramParcelamento.getRelatorio()).orElseThrow(() -> new ResponseStatusException(HttpStatus.INTERNAL_SERVER_ERROR, String.format("Relat\u00f3rio de impress\u00e3o do contrato n\u00e3o configurado para o par\u00e2metro de %s %d.", paramParcelamento.getTipo().getDescricao(), paramParcelamento.getId())));
        return this.createImprimirContratoDTO(idParcelamento, relatorioContrato, paramParcelamento.getSequenciaEmissaoRelatorio());
    }

    private ParamParcelamento findParamParcelamento(Long idParamParcelamento) {
        return (ParamParcelamento)this.paramParcelamentoRepository.findById((Object)idParamParcelamento).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND, String.format("N\u00e3o foi encontrado Par\u00e2metro do Parcelamento com id %d", idParamParcelamento)));
    }

    private Long findIdParamParcelamento(Long idParcelamento) {
        return (Long)this.parcelamentoRepository.findIdParametroParcelamentoByIdParcelamento(idParcelamento).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND, String.format("N\u00e3o foi encontrado Parcelamento com id %d", idParcelamento)));
    }

    private ImprimirRelatorioDTO createImprimirContratoDTO(Long idParcelamento, Relatorio relatorioContrato, Long sequenciaImpressao) {
        ImprimirRelatorioDTO dto = new ImprimirRelatorioDTO();
        dto.setModulo(relatorioContrato.getId().getModulo());
        dto.setRelatorio(relatorioContrato.getId().getRelatorio());
        dto.setTipoRelatorioFromEnum(relatorioContrato.getId().getTipoRelatorio());
        dto.setFiltro(String.format(" tp.IdParcelamento = %d", idParcelamento));
        dto.setListParametros(this.contratoParcelamentoParamLoader.load());
        dto.setListVariaveisAmbienteTela(String.format("Rel_IdParcelamento=%d%nIdParcelamento=%d%n", idParcelamento, idParcelamento));
        dto.setSequenciaTipoEmissao(sequenciaImpressao);
        dto.setSubReports(this.createSubReportImprimirContratoDTO(dto.getFiltro()));
        return dto;
    }

    private SubReportDTO createSubReportImprimirContratoDTO(String filtroPadrao) {
        SubReportDTO subReport = new SubReportDTO();
        subReport.setItems((Set)Sets.newHashSet((Object[])new SubReportItemDTO[]{new SubReportItemDTO("Detalhe", filtroPadrao), new SubReportItemDTO("Comprador", filtroPadrao), new SubReportItemDTO("Vendedor", filtroPadrao), new SubReportItemDTO("CadastroContribuinte", filtroPadrao)}));
        return subReport;
    }

    public ImprimirRelatorioDTO getImprimirSituacaoContratoDTO(Long idParcelamento) {
        this.findIdParamParcelamento(idParcelamento);
        ImprimirRelatorioDTO dto = new ImprimirRelatorioDTO();
        dto.setRelatorio(RELATORIO_SITUACAO_CONTRATO);
        dto.setFiltro(String.format(" tp.IdParcelamento = %d", idParcelamento));
        dto.setListParametros(this.contratoParcelamentoParamLoader.load());
        dto.setListVariaveisAmbienteTela(String.format("IdParcelamento=%d%n", idParcelamento));
        return dto;
    }

    public ValueBlockDashDTO getQuantidadeContratosGerados(LocalDate data) {
        return this.parcelamentoRepository.getQuantidadeContratosGerados(data);
    }

    public Optional<Parcelamento> findParcelamentoQuitadoByParcelaTributo(DebitoParcela debitoParcela) {
        return this.parcelamentoRepository.findParcelamentoQuitadoByParcela(debitoParcela);
    }

    public Optional<Parcelamento> findParcelamentoDisponivelParaQuitacao(DebitoParcela debitoParcela) {
        return this.parcelamentoRepository.findParcelamentoDisponivelParaQuitacao(debitoParcela);
    }

    public ParcelamentoDTO getResumo(Long idParcelamento) {
        Parcelamento parcelamento = (Parcelamento)this.parcelamentoRepository.findById((Object)idParcelamento).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND, String.format("N\u00e3o foi encontrado Parcelamento com id %d", idParcelamento)));
        ParamParcelamento paramParcelamento = this.findParamParcelamento(parcelamento.getIdParametroParcelamento());
        ParcelamentoDTO parcelamentoDTO = parcelamento.toDto();
        parcelamentoDTO.setDescricaoParametroParcelamento(paramParcelamento.getDescricao());
        parcelamentoDTO.setDebitosOrigem(this.findParcelamentoDebitoOrigem(idParcelamento));
        parcelamentoDTO.setDebitosNovos(this.findParcelamentoDebitoNovo(idParcelamento));
        parcelamentoDTO.setParcelas(this.findParcelamentoDebitoParcelas(idParcelamento));
        parcelamentoDTO.setEstornos(this.getEstornos(idParcelamento));
        return parcelamentoDTO;
    }

    public List<EstornoParcelamentoRowDTO> getEstornos(Long idParcelamento) {
        return this.estornoParcelamentoService.findByIdParcelamento(idParcelamento);
    }

    public Parcelamento findByCodigoValidacao(String codigoValidacao) {
        return this.parcelamentoRepository.findByCodigoValidacao(codigoValidacao);
    }

    @Transactional
    public void quitarContratoParcelamento(Pagamento pagamento) {
        Boolean quitarContrato = this.parametroGeralService.getParamValueAsBoolean(ParametroGeralEnum.ATUALIZAR_SITUACAO_CONTRATO);
        if (Boolean.TRUE.equals(quitarContrato)) {
            SituacaoParcelamento situacaoParcelamentoAberto = (SituacaoParcelamento)this.situacaoParcelamentoService.findOne((Serializable)SituacaoParcelamentoEnum.ABERTO.getValue());
            List debitosId = this.pagamentoRepository.findIdDebitoQuitadoListByPagamento(pagamento.getId().getEntidade(), pagamento.getId().getExercicioPagamento(), pagamento.getId().getPagamento());
            if (!debitosId.isEmpty()) {
                debitosId.stream().filter(debito -> Objects.nonNull(debito) && Objects.nonNull(debito.getIdParcelamento())).map(DebitoIdDTO::getIdParcelamento).filter(arg_0 -> ((ParcelamentoRepository)this.parcelamentoRepository).parcelamentoComDebitosQuitados(arg_0)).map(arg_0 -> ((ParcelamentoRepository)this.parcelamentoRepository).findOne(arg_0)).filter(Objects::nonNull).filter(parcelamento -> Objects.isNull(parcelamento.getSituacao()) || situacaoParcelamentoAberto.equals((Object)parcelamento.getSituacao())).forEach(arg_0 -> this.quitarContrato(arg_0));
            }
        }
    }

    private void quitarContrato(Parcelamento parcelamento) {
        parcelamento.setSituacao((SituacaoParcelamento)this.situacaoParcelamentoService.findOne((Serializable)SituacaoParcelamentoEnum.QUITADO.getValue()));
        parcelamento.setDataQuitacao(LocalDate.now());
        this.parcelamentoRepository.save((Object)parcelamento);
    }

    public byte[] imprimirContratoParcelamentoFromTenant(String tenant, Long idParcelamento) {
        try {
            Parcelamento parcelamento = (Parcelamento)this.parcelamentoRepository.findById((Object)idParcelamento).orElseThrow(() -> new EloValidationException("Contrato do parcelamento n\u00e3o encontrado."));
            ImprimirContratoDTO imprimirContratoDTO = Optional.ofNullable(parcelamento.getIdArquivo()).map(uuid -> this.getUrlArquivo(uuid, parcelamento.getTenant())).orElseGet(() -> this.uploadContratoParcelamento(tenant, parcelamento));
            ArquivoContent arquivo = (ArquivoContent)this.resolveArquivoClient().buscarArquivo(ArquivoFindRequest.create((Tenant)Tenant.create((String)tenant), (String)imprimirContratoDTO.getFullPath())).orElseThrow(() -> new EloValidationException(String.format("Contrato de parcelamento n\u00e3o localizado - %s", imprimirContratoDTO.getFullPath())));
            return IOUtils.toByteArray((InputStream)arquivo.getContent());
        }
        catch (Exception ex) {
            LOGGER.error("Erro na impress\u00e3o do contrato de parcelamento", (Throwable)ex);
            throw new ImpressaoContratoParcelamentoException(HttpStatus.BAD_REQUEST, ex.getMessage(), ex);
        }
    }

    public ImprimirContratoDTO uploadContratoParcelamento(String tenant, Parcelamento parcelamento) {
        ImprimirRelatorioDTO imprimirRelatorioDTO = this.getImprimirContratoDTO(parcelamento.getId());
        byte[] relatorioPdf = this.aiseRelatorioService.imprimirRelatorioGenerico(imprimirRelatorioDTO);
        String nomeArquivo = (parcelamento.getTipo().equals((Object)TipoParcelamento.PARCELAMENTO) ? "parcelamento" : "reparcelamento").concat(String.format("_%d_%d.pdf", parcelamento.getNumeroContrato(), parcelamento.getAnoContrato()));
        ArquivoNovoRequest arquivoNovoRequest = ArquivoNovoRequest.builder((Tenant)Tenant.create((String)tenant), (Modulo)Modulo.OXY_TRIBUTOS).fileName(nomeArquivo).content((InputStream)new ByteArrayInputStream(relatorioPdf)).contentType(ContentType.APPLICATION_PDF).build();
        Arquivo arquivo = this.resolveArquivoClient().criarArquivo(arquivoNovoRequest);
        this.saveArquivoParcelamento(parcelamento, arquivo.getId(), tenant);
        return this.getUrlArquivo(arquivo.getId(), tenant);
    }

    private void saveArquivoParcelamento(Parcelamento parcelamento, UUID idArquivo, String tenant) {
        parcelamento.setIdArquivo(idArquivo);
        parcelamento.setTenant(tenant);
        this.parcelamentoRepository.save((Object)parcelamento);
    }

    private ImprimirContratoDTO getUrlArquivo(UUID idArquivo, String tenant) {
        ArquivoDownloadRequest arquivoDownloadRequest = ArquivoDownloadRequest.create((Tenant)Tenant.create((String)tenant), (String)("oxy_tributos/" + idArquivo.toString()));
        ArquivoUrl arquivo = this.resolveArquivoClient().gerarUrlParaGet(arquivoDownloadRequest);
        ImprimirContratoDTO imprimirContratoDTO = new ImprimirContratoDTO();
        imprimirContratoDTO.setUrlContrato(arquivo.getUrlAssinada());
        imprimirContratoDTO.setFullPath(arquivo.getFullPath());
        return imprimirContratoDTO;
    }

    private ArquivoClient resolveArquivoClient() {
        return TenantUtils.usesNovoS3() != false ? this.arquivoClientNovo : this.arquivoClient;
    }
}

