/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource.integracaoboleto;

import br.com.elotech.core.exception.RestException;
import br.com.elotech.tributos.domain.Bloqueto;
import br.com.elotech.tributos.dto.integracaoboleto.IntegracaoBoletoPixResponseDTO;
import br.com.elotech.tributos.service.BloquetoService;
import br.com.elotech.tributos.service.integracaoboleto.IntegracaoBoletoService;
import java.io.Serializable;
import java.util.Base64;
import lombok.Generated;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/integracao-boleto"})
public class IntegracaoBoletoResource {
    private final IntegracaoBoletoService integracaoBoletoService;
    private final BloquetoService bloquetoService;

    @PostMapping(value={"/{id}/geraqrcodepix"})
    public ResponseEntity<IntegracaoBoletoPixResponseDTO> gerarQrCode(@PathVariable Long id) {
        Bloqueto bloqueto = (Bloqueto)this.bloquetoService.findById((Serializable)id).orElseThrow(() -> new RestException(HttpStatus.NOT_FOUND, "Bloqueto n\u00e3o encontrado"));
        Bloqueto boleto = this.bloquetoService.save(this.integracaoBoletoService.gerarQrCodePix(bloqueto));
        String imagemBase64 = Base64.getEncoder().encodeToString(boleto.getCodigoQrCode());
        return ResponseEntity.ok((Object)new IntegracaoBoletoPixResponseDTO(imagemBase64, boleto.getTextoQrCode()));
    }

    @Generated
    public IntegracaoBoletoResource(IntegracaoBoletoService integracaoBoletoService, BloquetoService bloquetoService) {
        this.integracaoBoletoService = integracaoBoletoService;
        this.bloquetoService = bloquetoService;
    }
}

