/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto;

import br.com.elotech.core.enumerable.common.TipoPessoa;
import br.com.elotech.tributos.domain.Bairro;
import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.Cidade;
import br.com.elotech.tributos.domain.Logradouro;
import br.com.elotech.tributos.domain.Pessoa;
import br.com.elotech.tributos.domain.Setor;
import br.com.elotech.tributos.domain.SetorQuadra;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.domain.TipoLogradouro;
import br.com.elotech.tributos.domain.imobiliario.CadastroImobiliario;
import java.util.Optional;
import lombok.Generated;

public class EnderecoCadastroGeralDTO {
    private Long idCadastro;
    private Long tipoCadastro;
    private Long cadastroGeral;
    private Long cep;
    private String numero;
    private String cidade;
    private String unidadeFederacao;
    private String quadra;
    private String lote;
    private String bairro;
    private String setor;
    private String enderecoCompleto;
    private Boolean vencido;
    private String tipoLogradouro;
    private String logradouro;
    private String pessoaNome;
    private String cnpjCpf;
    private Long codigoPessoa;
    private TipoPessoa tipoPessoa;
    private String pessoaNomeResponsavel;
    private String cnpjCpfResponsavel;
    private Long codigoPessoaResponsavel;
    private TipoPessoa tipoPessoaResponsavel;

    public static EnderecoCadastroGeralDTO from(CadastroGeral cadastroGeral) {
        EnderecoCadastroGeralDTO dto = new EnderecoCadastroGeralDTO();
        Optional.ofNullable(cadastroGeral.getId()).ifPresent(arg_0 -> dto.setIdCadastro(arg_0));
        Optional.ofNullable(cadastroGeral.getTipoCadastro()).map(TipoCadastro::getValue).ifPresent(arg_0 -> dto.setTipoCadastro(arg_0));
        Optional.ofNullable(cadastroGeral.getCadastroGeral()).ifPresent(arg_0 -> dto.setCadastroGeral(arg_0));
        Optional.ofNullable(cadastroGeral.getCep()).ifPresent(arg_0 -> dto.setCep(arg_0));
        Optional.ofNullable(cadastroGeral.getNumero()).ifPresent(arg_0 -> dto.setNumero(arg_0));
        Optional.ofNullable(cadastroGeral.getCidade()).map(Cidade::getDescricao).ifPresent(arg_0 -> dto.setCidade(arg_0));
        Optional.ofNullable(cadastroGeral.getCidade()).map(Cidade::getUnidadeFederacao).ifPresent(arg_0 -> dto.setUnidadeFederacao(arg_0));
        Optional.ofNullable(cadastroGeral.getBairro()).map(Bairro::getDescricao).ifPresent(arg_0 -> dto.setBairro(arg_0));
        Optional.ofNullable(cadastroGeral.getEnderecoFormatado()).ifPresent(arg_0 -> dto.setEnderecoCompleto(arg_0));
        Optional.ofNullable(cadastroGeral.getLogradouro()).map(Logradouro::getTipoLogradouro).map(TipoLogradouro::getDescricao).ifPresent(arg_0 -> dto.setTipoLogradouro(arg_0));
        Optional.ofNullable(cadastroGeral.getLogradouro()).map(Logradouro::getDescricao).ifPresent(arg_0 -> dto.setLogradouro(arg_0));
        Optional.ofNullable(cadastroGeral.getPessoa()).map(Pessoa::getNome).ifPresent(arg_0 -> dto.setPessoaNome(arg_0));
        Optional.ofNullable(cadastroGeral.getPessoa()).map(Pessoa::getCnpjCpf).ifPresent(arg_0 -> dto.setCnpjCpf(arg_0));
        Optional.ofNullable(cadastroGeral.getPessoa()).map(Pessoa::getId).ifPresent(arg_0 -> dto.setCodigoPessoa(arg_0));
        Optional.ofNullable(cadastroGeral.getPessoa()).map(Pessoa::getTipoPessoa).ifPresent(arg_0 -> dto.setTipoPessoa(arg_0));
        Optional<Pessoa> responsavel = Optional.ofNullable(cadastroGeral.getPessoaResponsavel());
        if (responsavel.isPresent()) {
            responsavel.map(Pessoa::getNome).ifPresent(arg_0 -> dto.setPessoaNomeResponsavel(arg_0));
            responsavel.map(Pessoa::getCnpjCpf).ifPresent(arg_0 -> dto.setCnpjCpfResponsavel(arg_0));
            responsavel.map(Pessoa::getId).ifPresent(arg_0 -> dto.setCodigoPessoaResponsavel(arg_0));
            responsavel.map(Pessoa::getTipoPessoa).ifPresent(arg_0 -> dto.setTipoPessoaResponsavel(arg_0));
        }
        if (cadastroGeral instanceof CadastroImobiliario) {
            CadastroImobiliario cadastroImobiliario = (CadastroImobiliario)cadastroGeral;
            Optional.ofNullable(cadastroImobiliario.getSetorLocalizacao()).map(Setor::getSetor).ifPresent(arg_0 -> dto.setSetor(arg_0));
            Optional.ofNullable(cadastroImobiliario.getQuadraLocalizacao()).map(SetorQuadra::getQuadra).ifPresent(arg_0 -> dto.setQuadra(arg_0));
            dto.setLote(cadastroImobiliario.getLoteLocalizacao());
        }
        return dto;
    }

    public String getTipoCadastroDescricao() {
        TipoCadastro tipoCadastroFound = TipoCadastro.fromValue((Long)this.tipoCadastro);
        if (tipoCadastroFound == null) {
            return "";
        }
        return tipoCadastroFound.getDescricao();
    }

    @Generated
    public Long getIdCadastro() {
        return this.idCadastro;
    }

    @Generated
    public Long getTipoCadastro() {
        return this.tipoCadastro;
    }

    @Generated
    public Long getCadastroGeral() {
        return this.cadastroGeral;
    }

    @Generated
    public Long getCep() {
        return this.cep;
    }

    @Generated
    public String getNumero() {
        return this.numero;
    }

    @Generated
    public String getCidade() {
        return this.cidade;
    }

    @Generated
    public String getUnidadeFederacao() {
        return this.unidadeFederacao;
    }

    @Generated
    public String getQuadra() {
        return this.quadra;
    }

    @Generated
    public String getLote() {
        return this.lote;
    }

    @Generated
    public String getBairro() {
        return this.bairro;
    }

    @Generated
    public String getSetor() {
        return this.setor;
    }

    @Generated
    public String getEnderecoCompleto() {
        return this.enderecoCompleto;
    }

    @Generated
    public Boolean getVencido() {
        return this.vencido;
    }

    @Generated
    public String getTipoLogradouro() {
        return this.tipoLogradouro;
    }

    @Generated
    public String getLogradouro() {
        return this.logradouro;
    }

    @Generated
    public String getPessoaNome() {
        return this.pessoaNome;
    }

    @Generated
    public String getCnpjCpf() {
        return this.cnpjCpf;
    }

    @Generated
    public Long getCodigoPessoa() {
        return this.codigoPessoa;
    }

    @Generated
    public TipoPessoa getTipoPessoa() {
        return this.tipoPessoa;
    }

    @Generated
    public String getPessoaNomeResponsavel() {
        return this.pessoaNomeResponsavel;
    }

    @Generated
    public String getCnpjCpfResponsavel() {
        return this.cnpjCpfResponsavel;
    }

    @Generated
    public Long getCodigoPessoaResponsavel() {
        return this.codigoPessoaResponsavel;
    }

    @Generated
    public TipoPessoa getTipoPessoaResponsavel() {
        return this.tipoPessoaResponsavel;
    }

    @Generated
    public void setIdCadastro(Long idCadastro) {
        this.idCadastro = idCadastro;
    }

    @Generated
    public void setTipoCadastro(Long tipoCadastro) {
        this.tipoCadastro = tipoCadastro;
    }

    @Generated
    public void setCadastroGeral(Long cadastroGeral) {
        this.cadastroGeral = cadastroGeral;
    }

    @Generated
    public void setCep(Long cep) {
        this.cep = cep;
    }

    @Generated
    public void setNumero(String numero) {
        this.numero = numero;
    }

    @Generated
    public void setCidade(String cidade) {
        this.cidade = cidade;
    }

    @Generated
    public void setUnidadeFederacao(String unidadeFederacao) {
        this.unidadeFederacao = unidadeFederacao;
    }

    @Generated
    public void setQuadra(String quadra) {
        this.quadra = quadra;
    }

    @Generated
    public void setLote(String lote) {
        this.lote = lote;
    }

    @Generated
    public void setBairro(String bairro) {
        this.bairro = bairro;
    }

    @Generated
    public void setSetor(String setor) {
        this.setor = setor;
    }

    @Generated
    public void setEnderecoCompleto(String enderecoCompleto) {
        this.enderecoCompleto = enderecoCompleto;
    }

    @Generated
    public void setVencido(Boolean vencido) {
        this.vencido = vencido;
    }

    @Generated
    public void setTipoLogradouro(String tipoLogradouro) {
        this.tipoLogradouro = tipoLogradouro;
    }

    @Generated
    public void setLogradouro(String logradouro) {
        this.logradouro = logradouro;
    }

    @Generated
    public void setPessoaNome(String pessoaNome) {
        this.pessoaNome = pessoaNome;
    }

    @Generated
    public void setCnpjCpf(String cnpjCpf) {
        this.cnpjCpf = cnpjCpf;
    }

    @Generated
    public void setCodigoPessoa(Long codigoPessoa) {
        this.codigoPessoa = codigoPessoa;
    }

    @Generated
    public void setTipoPessoa(TipoPessoa tipoPessoa) {
        this.tipoPessoa = tipoPessoa;
    }

    @Generated
    public void setPessoaNomeResponsavel(String pessoaNomeResponsavel) {
        this.pessoaNomeResponsavel = pessoaNomeResponsavel;
    }

    @Generated
    public void setCnpjCpfResponsavel(String cnpjCpfResponsavel) {
        this.cnpjCpfResponsavel = cnpjCpfResponsavel;
    }

    @Generated
    public void setCodigoPessoaResponsavel(Long codigoPessoaResponsavel) {
        this.codigoPessoaResponsavel = codigoPessoaResponsavel;
    }

    @Generated
    public void setTipoPessoaResponsavel(TipoPessoa tipoPessoaResponsavel) {
        this.tipoPessoaResponsavel = tipoPessoaResponsavel;
    }
}

