/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain;

import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Stream;

/*
 * Exception performing whole class analysis ignored.
 */
public enum ClassificacaoTipoTributo {
    IPTU(1, "Imposto - I.P.T.U.", Boolean.TRUE),
    ITBI(2, "Imposto I.T.B.I", Boolean.TRUE),
    ISS(3, "Imposto - I.S.S.", Boolean.TRUE),
    CONTRIBUICAO(4, "Contribui\u00e7\u00e3o", Boolean.TRUE),
    TAXAS(5, "Taxas", Boolean.TRUE),
    OUTRAS_RECEITAS_TRIBUTAVEIS(6, "Outras Receitas Tribut\u00e1veis", Boolean.TRUE),
    COSIP(7, "COSIP", Boolean.FALSE),
    IMPUGNACOES_IMPOSICOES(8, "Impugna\u00e7\u00f5es/Imposi\u00e7\u00f5es", Boolean.FALSE),
    OUTRAS_RECEITAS_NAO_TRIBUTAVEIS(9, "Outras Receitas N\u00e3o Tribut\u00e1veis", Boolean.FALSE);

    private final int value;
    private final String descricao;
    private final Boolean tributavel;

    private ClassificacaoTipoTributo(int value, String descricao, Boolean tributavel) {
        this.value = value;
        this.descricao = descricao;
        this.tributavel = tributavel;
    }

    public Boolean isImposto() {
        return Arrays.asList(1, 2, 3).contains(this.value);
    }

    public Boolean isTaxa() {
        return 5 == this.value;
    }

    public Boolean isContribuicao() {
        return Arrays.asList(4, 7).contains(this.value);
    }

    public Boolean isReceitaNaoTributavel() {
        return 9 == this.value;
    }

    public int getValue() {
        return this.value;
    }

    public String getDescricao() {
        return this.descricao;
    }

    public Boolean isTributavel() {
        return this.tributavel;
    }

    public static ClassificacaoTipoTributo fromValue(Integer value) {
        return Stream.of(ClassificacaoTipoTributo.values()).filter(t -> Objects.equals(t.getValue(), value)).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("Classifica\u00e7\u00e3o do tipo de tributo inv\u00e1lida com valor '%d'.", value)));
    }
}

