/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.calculo.service;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.calculo.dto.CadastroCalculoDTO;
import br.com.elotech.tributos.calculo.dto.CadastroCalculoRoot;
import br.com.elotech.tributos.calculo.dto.CadastroImobiliarioCalculoDTO;
import br.com.elotech.tributos.calculo.dto.CadastroMobiliarioCalculoDTO;
import br.com.elotech.tributos.calculo.dto.CalculoBuildDTO;
import br.com.elotech.tributos.calculo.dto.CalculoContext;
import br.com.elotech.tributos.calculo.dto.CalculoImobiliarioContext;
import br.com.elotech.tributos.calculo.dto.CalculoMobiliarioContext;
import br.com.elotech.tributos.calculo.dto.CampoDinamicoScriptDTO;
import br.com.elotech.tributos.calculo.dto.ParametroTesteScriptDTO;
import br.com.elotech.tributos.calculo.exception.CalculoException;
import br.com.elotech.tributos.calculo.repository.CadastroGeralCalculoRepository;
import br.com.elotech.tributos.calculo.repository.CadastroImobiliarioCalculoRepository;
import br.com.elotech.tributos.calculo.repository.CadastroMobiliarioCalculoRepository;
import br.com.elotech.tributos.calculo.service.CalculoBuild;
import br.com.elotech.tributos.calculo.service.CalculoParser;
import br.com.elotech.tributos.calculo.service.CalculoTabelaValores;
import br.com.elotech.tributos.calculo.service.TabelaValorService;
import br.com.elotech.tributos.domain.TipoDivida;
import br.com.elotech.tributos.domain.calculo.CalculoTributo;
import br.com.elotech.tributos.domain.calculo.TipoCalculoTributo;
import com.google.common.base.Stopwatch;
import java.lang.reflect.InvocationTargetException;
import java.time.LocalDate;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.convert.ConversionService;
import org.springframework.stereotype.Service;

@Service
public class CalculoExecucaoService {
    private static final Logger LOGGER = LoggerFactory.getLogger(CalculoExecucaoService.class);
    private final CadastroImobiliarioCalculoRepository cadastroImobiliarioCalculoRepository;
    private final TabelaValorService tabelaValorService;
    private final ConversionService conversionService;
    private final CadastroMobiliarioCalculoRepository cadastroMobiliarioCalculoRepository;
    private final CadastroGeralCalculoRepository cadastroGeralCalculoRepository;

    public CalculoExecucaoService(CadastroImobiliarioCalculoRepository cadastroImobiliarioCalculoRepository, TabelaValorService tabelaValorService, ConversionService conversionService, CadastroMobiliarioCalculoRepository cadastroMobiliarioCalculoRepository, CadastroGeralCalculoRepository cadastroGeralCalculoRepository) {
        this.cadastroImobiliarioCalculoRepository = cadastroImobiliarioCalculoRepository;
        this.tabelaValorService = tabelaValorService;
        this.conversionService = conversionService;
        this.cadastroMobiliarioCalculoRepository = cadastroMobiliarioCalculoRepository;
        this.cadastroGeralCalculoRepository = cadastroGeralCalculoRepository;
    }

    public List<CadastroCalculoRoot> calcular(List<CalculoTributo> tributos, Long exercicio, String filtro, Long segmento, Boolean traceAtivo, LocalDate dataReferencia) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        Set camposDinamicos = CalculoParser.extractCamposDinamicos(tributos);
        List root = this.loadCadastros(tributos, filtro, segmento, exercicio, camposDinamicos, dataReferencia);
        stopwatch.stop();
        LOGGER.debug("Carregando {} cadastros - {} m {} s {} ms - {} ns", new Object[]{root.size(), stopwatch.elapsed(TimeUnit.MINUTES), stopwatch.elapsed(TimeUnit.SECONDS), stopwatch.elapsed(TimeUnit.MILLISECONDS), stopwatch.elapsed(TimeUnit.NANOSECONDS)});
        if (root.isEmpty()) {
            throw new CalculoException("N\u00e3o foram encontrados cadastros para o filtro informado.");
        }
        return this.calcular(root, tributos, traceAtivo, exercicio);
    }

    public List<CadastroCalculoRoot> calcular(List<CalculoTributo> tributos, Long exercicio, String filtro, Boolean traceAtivo, LocalDate dataReferencia) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        Set camposDinamicos = CalculoParser.extractCamposDinamicos(tributos);
        List root = this.loadCadastros(tributos, filtro, null, exercicio, camposDinamicos, dataReferencia);
        stopwatch.stop();
        LOGGER.debug("Carregando {} cadastros - {} m {} s {} ms - {} ns", new Object[]{root.size(), stopwatch.elapsed(TimeUnit.MINUTES), stopwatch.elapsed(TimeUnit.SECONDS), stopwatch.elapsed(TimeUnit.MILLISECONDS), stopwatch.elapsed(TimeUnit.NANOSECONDS)});
        if (root.isEmpty()) {
            throw new CalculoException("N\u00e3o foram encontrados cadastros para o filtro informado.");
        }
        return this.calcular(root, tributos, traceAtivo, exercicio);
    }

    public List<CadastroCalculoRoot> calcularSemCompilarFormulas(List<CalculoTributo> tributos, Long exercicio, String filtro, LocalDate dataReferencia) {
        Set camposDinamicos = CalculoParser.extractCamposDinamicos(tributos);
        List cadastrosRoots = this.loadCadastros(tributos, filtro, null, exercicio, camposDinamicos, dataReferencia);
        if (cadastrosRoots.isEmpty()) {
            throw new CalculoException(String.format("N\u00e3o foram encontrados cadastros para o filtro informado: %s.", filtro));
        }
        CalculoTabelaValores calculoTabelaValores = this.carregaTabelaValores(exercicio);
        for (CalculoTributo tributo : tributos) {
            tributo.getCalculoBuildDTO().getContext().setCalculoTabelaValores(calculoTabelaValores);
        }
        cadastrosRoots.forEach(cadastro -> this.executeCalculo(tributos, cadastro));
        return cadastrosRoots;
    }

    public void verifyFiltroTemUmCadastroGeralPeloMenos(String filtro) {
        if (!this.cadastroGeralCalculoRepository.temUmCadastroGeralPeloMenos(filtro).booleanValue()) {
            throw new CalculoException("N\u00e3o foram encontrados cadastros para o filtro informado.");
        }
    }

    private List<CadastroCalculoRoot> loadCadastros(List<CalculoTributo> tributos, String filtro, Long segmento, Long exercicio, Set<CampoDinamicoScriptDTO> camposDinamicos, LocalDate dataReferencia) {
        if (tributos.isEmpty()) {
            throw new CalculoException("N\u00e3o foi informado script para execu\u00e7\u00e3o do c\u00e1lculo.");
        }
        TipoDivida tipoDivida = tributos.get(0).getDivida().getTipoDivida();
        if (tipoDivida.equals((Object)TipoDivida.IPTU)) {
            return this.cadastroImobiliarioCalculoRepository.loadCadastros(filtro, segmento, exercicio, camposDinamicos);
        }
        if (TipoDivida.ISS_FIXO.equals((Object)tipoDivida) || TipoDivida.ALVARA.equals((Object)tipoDivida)) {
            return this.cadastroMobiliarioCalculoRepository.loadCadastros(filtro, exercicio, camposDinamicos, dataReferencia);
        }
        throw new EloValidationException(String.format("N\u00e3o h\u00e1 implementa\u00e7\u00e3o de c\u00e1lculo para o tipo de d\u00edvida %s.", tipoDivida));
    }

    private CalculoTabelaValores carregaTabelaValores(Long exercicio) {
        return new CalculoTabelaValores(this.conversionService, this.tabelaValorService.findByExercicio(exercicio));
    }

    public List<CadastroCalculoRoot> calcular(List<CadastroCalculoRoot> cadastros, List<CalculoTributo> tributos, Boolean traceAtivo, Long exercicio) {
        CalculoTabelaValores calculoTabelaValores = this.carregaTabelaValores(exercicio);
        for (CalculoTributo tributo : tributos) {
            CalculoBuildDTO calculoBuildDTO = this.getFormulaCompilada(tributo, traceAtivo);
            tributo.setCalculoBuildDTO(calculoBuildDTO);
            tributo.getCalculoBuildDTO().getContext().setCalculoTabelaValores(calculoTabelaValores);
        }
        Stopwatch stopwatch = Stopwatch.createStarted();
        cadastros.forEach(cadastro -> this.executeCalculo(tributos, cadastro));
        stopwatch.stop();
        LOGGER.debug("Execution time: {} cadastros -  {} ms  - {} ns", new Object[]{cadastros.size(), stopwatch.elapsed(TimeUnit.MILLISECONDS), stopwatch.elapsed(TimeUnit.NANOSECONDS)});
        return cadastros;
    }

    public CalculoBuildDTO getFormulaCompilada(CalculoTributo tributo, Boolean traceAtivo) {
        try {
            String scriptParsed = CalculoParser.parseLinhas((List)tributo.getScript(), (String)tributo.getIdentificadorResultado(), (String)tributo.getIdentificadorBaseCalculo(), (String)tributo.getIdentificadorCondicao(), (String)"", (String)tributo.getIdentificadorAliquota());
            Stopwatch stopwatch = Stopwatch.createStarted();
            CalculoBuildDTO calculoBuildDTO = CalculoBuild.buildCalculo((String)scriptParsed, (Boolean)traceAtivo, (TipoDivida)tributo.getDivida().getTipoDivida());
            stopwatch.stop();
            LOGGER.debug("Build time {}: {} ms - {} ns ", new Object[]{tributo.getTributo(), stopwatch.elapsed(TimeUnit.MILLISECONDS), stopwatch.elapsed(TimeUnit.NANOSECONDS)});
            return calculoBuildDTO;
        }
        catch (Exception e) {
            throw new CalculoException(String.format("Erro ao compilar o c\u00e1lculo do tributo %s", tributo.getTributo().getTributo()), (Throwable)e);
        }
    }

    private void executeCalculo(List<CalculoTributo> tributos, CadastroCalculoRoot root) {
        for (CalculoTributo tributo : tributos) {
            try {
                if (TipoCalculoTributo.GERAL.equals((Object)tributo.getTipo())) {
                    this.executeCalculoGeral(root, tributo);
                    continue;
                }
                this.executeCalculoPorSegmento(root, tributo);
            }
            catch (InvocationTargetException e) {
                LOGGER.error("Erro ao calcular o tributo {} do cadastro {}-{}: {}", new Object[]{tributo.getTributo(), root.getTipoCadastro(), root.getCadastroGeral(), e});
                root.addInconsistencia(tributo.getTributo().getTributo(), tributo.getDivida().getId(), e.getTargetException().getMessage());
            }
            catch (Exception e) {
                LOGGER.error("Erro ao calcular o tributo {} do cadastro {}-{}: {}", new Object[]{tributo.getTributo(), root.getTipoCadastro(), root.getCadastroGeral(), e});
                root.addInconsistencia(tributo.getTributo().getTributo(), tributo.getDivida().getId(), e.getMessage());
            }
        }
    }

    private void executeCalculoPorSegmento(CadastroCalculoRoot root, CalculoTributo tributo) throws InvocationTargetException, IllegalAccessException {
        for (CadastroCalculoDTO cadastro : root.getChildren()) {
            Stopwatch stopwatch = Stopwatch.createStarted();
            this.setVariaveisCadastro(tributo.getCalculoBuildDTO().getContext(), cadastro);
            CalculoContext context = CalculoBuild.evaluate((CalculoBuildDTO)tributo.getCalculoBuildDTO());
            cadastro.addResultado(tributo, context);
            stopwatch.stop();
            LOGGER.trace("Cadastro: {}-{} - Tributo {} - Evaluation time: {} ms  - {} ns", new Object[]{root.getTipoCadastro(), root.getCadastroGeral(), tributo, stopwatch.elapsed(TimeUnit.MILLISECONDS), stopwatch.elapsed(TimeUnit.NANOSECONDS)});
        }
    }

    private void executeCalculoGeral(CadastroCalculoRoot root, CalculoTributo tributo) throws InvocationTargetException, IllegalAccessException {
        Stopwatch stopwatch = Stopwatch.createStarted();
        this.setVariaveisCadastro(tributo.getCalculoBuildDTO().getContext(), (CadastroCalculoDTO)root.getChildren().get(0));
        CalculoContext context = CalculoBuild.evaluate((CalculoBuildDTO)tributo.getCalculoBuildDTO());
        root.addResultado(tributo, context);
        stopwatch.stop();
        LOGGER.trace("Cadastro: {}-{} - Tributo {} - Evaluation time: {} ms  - {} ns", new Object[]{root.getTipoCadastro(), root.getCadastroGeral(), tributo, stopwatch.elapsed(TimeUnit.MILLISECONDS), stopwatch.elapsed(TimeUnit.NANOSECONDS)});
    }

    private void setVariaveisCadastro(CalculoContext context, CadastroCalculoDTO cadastroCalculoDTO) {
        if (context instanceof CalculoImobiliarioContext) {
            ((CalculoImobiliarioContext)context).setCadastro(((CadastroImobiliarioCalculoDTO)cadastroCalculoDTO).getCadastro());
            ((CalculoImobiliarioContext)context).setSegmento(((CadastroImobiliarioCalculoDTO)cadastroCalculoDTO).getSegmento());
            ((CalculoImobiliarioContext)context).setTestada(((CadastroImobiliarioCalculoDTO)cadastroCalculoDTO).getTestada());
            ((CalculoImobiliarioContext)context).setTestadagenerica(((CadastroImobiliarioCalculoDTO)cadastroCalculoDTO).getTestadaGenerica());
        } else if (context instanceof CalculoMobiliarioContext) {
            ((CalculoMobiliarioContext)context).setCadastro(((CadastroMobiliarioCalculoDTO)cadastroCalculoDTO).getCadastro());
            ((CalculoMobiliarioContext)context).setAtividade(((CadastroMobiliarioCalculoDTO)cadastroCalculoDTO).getAtividade());
            ((CalculoMobiliarioContext)context).setCnae(((CadastroMobiliarioCalculoDTO)cadastroCalculoDTO).getCnae());
            ((CalculoMobiliarioContext)context).setServico(((CadastroMobiliarioCalculoDTO)cadastroCalculoDTO).getServico());
        }
    }

    public List<CadastroCalculoRoot> testarScript(ParametroTesteScriptDTO parametroTestScriptDTO) {
        parametroTestScriptDTO.getCalculoTributo().setIdentificadorResultado(parametroTestScriptDTO.getIdentificador());
        parametroTestScriptDTO.getCalculoTributo().setIdentificadorBaseCalculo(null);
        CalculoBuild.buildCalculoDebugMode((List)parametroTestScriptDTO.getCalculoTributo().getScript(), CalculoParser::parseLinhaDebugMode, (TipoDivida)parametroTestScriptDTO.getCalculoTributo().getDivida().getTipoDivida());
        return this.calcular(Collections.singletonList(parametroTestScriptDTO.getCalculoTributo()), parametroTestScriptDTO.getCalculoTributo().getExercicio(), parametroTestScriptDTO.buildFiltro(), parametroTestScriptDTO.getSegmento(), Boolean.TRUE, LocalDate.now());
    }
}

