select tep.datareabilitacao      as datamovimentacao,
       tr.receita                as tributo,
       tr.descricao              as descricaotributo,
       case
         when tr.classificacao = 'F'
         then 'J'
         else tr.classificacao
       end                       classificacaotributo,
       case
         when tdp.situacaolegal <> 0 and ( tdp.datadividaativa is null or tdp.datadividaativa <= tep.datareabilitacao )
         then tdp.situacaolegal
         else 0
       end                       situacaolegal,
       null                      as tipooperacaodeducao,
       'ACRESCIMOS_PARCELAMENTO' as tipomovimento,
       sum(tepjf.valor)      as valor
from   tribestornoparcelamento tep
       left outer join tribparcelamento tp
                    on tp.idparcelamento = tep.idparcelamento
       left outer join tribestornoparcjurosfinan tepjf
                    ON tep.idestornoparcelamento = tepjf.idestornoparcelamento
       left outer join tribestornoparcelamentodebito tepd
                    on tepd.idestornoparcelamento = tep.idestornoparcelamento
                   and tepd.iddebitoorigem < tepd.iddebitodestino
       left outer join tribdebito td
                    on td.iddebito = tepd.iddebitodestino
       left outer join tribdebitoparcela tdp
                    on td.entidade = tdp.entidade
                   and td.exercicio = tdp.exercicio
                   and td.tipocadastro = tdp.tipocadastro
                   and td.cadastrogeral = tdp.cadastrogeral
                   and td.guiarecolhimento = tdp.guiarecolhimento
                   and td.subdivida = tdp.subdivida
                   and tdp.parcela = 1
       left outer join tribreceita tr
                    on td.entidade = tr.entidade
                   and td.exercicio = tr.exercicio
                   and tepjf.receita = tr.receita
where  td.constituido = 'S'
  and  coalesce(tr.inscrito, 1) = 1
  and  tep.datareabilitacao in (:datasMovimento)
  and  tepjf.valor > 0
  and  exists(select 1 from tribestornoparcelamentodebito tepd
                      where tepd.idestornoparcelamento = tep.idestornoparcelamento
                        and tepd.iddebitoorigem < tepd.iddebitodestino)
group  by tep.datareabilitacao,
          tr.receita,
          tr.descricao,
          case
            when tr.classificacao = 'F'
            then 'J'
            else tr.classificacao
          end,
          case
            when tdp.situacaolegal <> 0 and ( tdp.datadividaativa is null or tdp.datadividaativa <= tep.datareabilitacao )
            then tdp.situacaolegal
            else 0
          end