select
       tl.DATAINCLUSAO AS datamovimentacao,
       tdpr.receita as tributo,
       tr.descricao as descricaotributo,
       tr.classificacao as classificacaotributo,
       1 as situacaolegal,
       cast(null as numeric(10)) as tipooperacaodeducao,
       'INSCRICAO' as tipomovimento,
       sum(tdpr.valor) as valor
from triblivro tl
left outer join triblivroregistro tlr
 on tlr.entidade = tl.entidade
and tlr.exercicio = tl.exercicio
and tlr.livro = tl.livro
left outer join triblivroparcelareceita tlpr
 on tlpr.entidade = tlr.entidade
and tlpr.exercicio = tlr.exercicio
and tlpr.livro = tlr.livro
and tlpr.sequencia = tlr.sequencia
left outer join tribdebitoparcelareceita tdpr
 on tdpr.iddebitoparcelareceita = tlpr.iddebitoparcelareceita
left outer join tribdebitoreceita tdr
 on tdpr.entidade         = tdr.entidade
and tdpr.exercicio        = tdr.exercicio
and tdpr.tipocadastro     = tdr.tipocadastro
and tdpr.cadastrogeral    = tdr.cadastrogeral
and tdpr.guiarecolhimento = tdr.guiarecolhimento
and tdpr.subdivida        = tdr.subdivida
and tdpr.receita          = tdr.receita
left outer join tribreceita tr
 on tdr.entidade  = tr.entidade
and tdr.exercicio = tr.exercicio
and tdr.receita   = tr.receita
where tl.datainclusao in (:datasMovimento)
  AND tlpr.valor > 0
group by
       tl.DATAINCLUSAO,
       tdpr.receita,
       tr.descricao,
       tr.classificacao