select tep.dataestorno           as datamovimentacao,
       tr.receita                as tributo,
       tr.descricao              as descricaotributo,
       case
         when tr.classificacao = 'F'
         then 'J'
         else tr.classificacao
       end                       classificacaotributo,
       case
         when tdp.situacaolegal <> 0 and ( tdp.datadividaativa is null or tdp.datadividaativa <= tep.dataestorno )
         then tdp.situacaolegal
         else 0
       end                       situacaolegal,
       ttot.codigotce            as tipooperacaodeducao,
       'ESTORNO_ACRESCIMOS_PARCELAMENTO' as tipomovimento,
       sum(tepjf.valor)      as valor
from   tribestornoparcelamento tep
       left outer join tribparcelamento tp
                    on tp.idparcelamento = tep.idparcelamento
       left outer join tribparamparcelamento tpp
                    on tp.idparametroparcelamento = tpp.idparametroparcelamento
       left outer join tribmotivodesconto tmd
                    on tpp.motivodescontofinan = tmd.motivodesconto
       left outer join tribtipooperacaotce ttot
                    on tmd.idtipooperacaotce = ttot.idtipooperacaotce
       left outer join tribestornoparcjurosfinan tepjf
                    ON tep.idestornoparcelamento = tepjf.idestornoparcelamento
       left outer join tribestornoparcelamentodebito tepd
                    on tepd.idestornoparcelamento = tep.idestornoparcelamento
                   and tepd.iddebitoorigem < tepd.iddebitodestino
       left outer join tribdebito td
                    on td.iddebito = tepd.iddebitodestino
       left outer join tribdebitoparcela tdp
                    on td.entidade = tdp.entidade
                   and td.exercicio = tdp.exercicio
                   and td.tipocadastro = tdp.tipocadastro
                   and td.cadastrogeral = tdp.cadastrogeral
                   and td.guiarecolhimento = tdp.guiarecolhimento
                   and td.subdivida = tdp.subdivida
                   and tdp.parcela = 1
       left outer join tribreceita tr
                    on td.entidade = tr.entidade
                   and td.exercicio = tr.exercicio
                   and tepjf.receita = tr.receita
where  td.constituido = 'S'
  and  coalesce(tr.inscrito, 1) = 1
  and  tep.dataestorno in (:datasMovimento)
  and  tepjf.valor > 0
  and  exists(select 1 from tribestornoparcelamentodebito tepd
                      where tepd.idestornoparcelamento = tep.idestornoparcelamento
                        and tepd.iddebitoorigem < tepd.iddebitodestino)
group  by tep.dataestorno,
          tr.receita,
          tr.descricao,
          case
            when tr.classificacao = 'F'
            then 'J'
            else tr.classificacao
          end,
          case
            when tdp.situacaolegal <> 0 and ( tdp.datadividaativa is null or tdp.datadividaativa <= tep.dataestorno )
            then tdp.situacaolegal
            else 0
          end,
          ttot.codigotce