select tp.dataparcelamento       as datamovimentacao, 
       tr.receita                as tributo, 
       tr.descricao              as descricaotributo, 
       case
         when tr.classificacao = 'F'
         then 'J'
         else tr.classificacao
       end                       classificacaotributo,
       case
         when tdp.situacaolegal <> 0 and ( tdp.datadividaativa is null or tdp.datadividaativa <= tp.dataparcelamento )
         then tdp.situacaolegal
         else 0
       end                       situacaolegal,
       null                      as tipooperacaodeducao,
       'ACRESCIMOS_PARCELAMENTO' as tipomovimento,
       sum(acrescimo.valor)      as valor
from   tribparcelamento tp
       left outer join tribparamparcelamento tpp
                    on tp.idparametroparcelamento = tpp.idparametroparcelamento
       left outer join (select tpre.idparcelamentoreceitaespelho,
                               tpre.idparcelamento,
                               tpre.jurosdestino as tributo,
                               tpre.valorjuros   as valor,
                               tpre.iddebitonovo
                        from   tribparcelamentoreceitaespelho tpre
                        where  valorjuros > 0
                        union
                        select tpre.idparcelamentoreceitaespelho,
                               tpre.idparcelamento,
                               tpre.multadestino as tributo,
                               tpre.valormulta   as valor,
                               tpre.iddebitonovo
                        from   tribparcelamentoreceitaespelho tpre
                        where  valormulta > 0
                        union
                        select tpre.idparcelamentoreceitaespelho,
                               tpre.idparcelamento,
                               tpre.correcaodestino as tributo,
                               tpre.valorcorrecao   as valor,
                               tpre.iddebitonovo
                        from   tribparcelamentoreceitaespelho tpre
                        where  valorcorrecao > 0
                        union
                        select tpre.idparcelamentoreceitaespelho,
                               tpre.idparcelamento,
                               tpre.jurosfinandestino as tributo,
                               tpre.valorjurosfinan as valor,
                               tpre.iddebitonovo
                        from   tribparcelamentoreceitaespelho tpre
                        where  valorjurosfinan > 0) acrescimo
                    on acrescimo.idparcelamento = tp.idparcelamento
       left outer join tribdebito td
                    on td.iddebito = acrescimo.iddebitonovo
       left outer join tribdebitoparcela tdp
                    on td.entidade = tdp.entidade
                   and td.exercicio = tdp.exercicio
                   and td.tipocadastro = tdp.tipocadastro
                   and td.cadastrogeral = tdp.cadastrogeral
                   and td.guiarecolhimento = tdp.guiarecolhimento
                   and td.subdivida = tdp.subdivida
                   and tdp.parcela = 1
       left outer join tribreceita tr
                    on td.entidade = tr.entidade
                   and td.exercicio = tr.exercicio
                   and acrescimo.tributo = tr.receita
where  td.constituido = 'S'
  and  coalesce(tr.inscrito, 1) = 1
  and  tp.dataparcelamento in (:datasMovimento)
group  by tp.dataparcelamento,
          tr.receita,
          tr.descricao,
          case
            when tr.classificacao = 'F'
            then 'J'
            else tr.classificacao
          end,
          case 
            when tdp.situacaolegal <> 0 and ( tdp.datadividaativa is null or tdp.datadividaativa <= tp.dataparcelamento ) 
            then tdp.situacaolegal 
            else 0 
          end