SELECT TRIBCADASTROGERAL.TIPOCADASTRO,
       TRIBCADASTROGERAL.CADASTROGERAL,
       TRIBCADASTROGERAL.PESSOA,
       TRIBDEBITO.ENTIDADE,
       TRIBDEBITO.EXERCICIO,
       TRIBDEBITO.GUIARECOLHIMENTO AS DIVIDA,
       TRIBDEBITO.SUBDIVIDA,
       TRIBDEBITOPARCELARECEITA.RECEITA AS TRIBUTO,
       TRIBDEBITOPARCELA.DATALANCAMENTO,
       TRIBDEBITOPARCELA.DATAVENCIMENTO,
       TRIBDEBITO.DATAPRIMEIRAPARCELA,
       TRIBDEBITOPARCELA.SITUACAOLEGAL,
       TRIBDEBITOPARCELARECEITA.VALOR AS VALORPRINCIPAL,
       TRIBDEBITO.FORMACORRECAO,
       CASE WHEN TRIBDEBITO.PARCELADO = 'S' THEN 1 ELSE 0 END AS PARCELADO,
       CASE WHEN TRIBDEBITO.REPARCELADO = 'S' THEN 1 ELSE 0 END AS REPARCELADO,
       TRIBDEBITOPARCELARECEITA.IDDEBITOPARCELARECEITA,
       TRIBDEBITO.IDDEBITO,
       TRIBDEBITOPARCELARECEITA.PARCELA,
       CASE WHEN TRIBGUIARECOLHIMENTO.EMITEBLOQUETO = 'S' THEN 1 ELSE 0 END AS EMITEBOLETO,
       TRIBGUIARECOLHIMENTO.DESCRICAO AS DESCRICAODIVIDA,
       TRIBTIPOSITUACAOPARCELA.TIPOSITUACAOPARCELA,
       TRIBDEBITOPARCELA.IDPROTESTO,
       TRIBSITUACAOPARCELA.DESCRICAO AS SITUACAODEBITODESCRICAO,
       TRIBSITUACAOPARCELA.SIGLA AS SITUACAODEBITOSIGLA,
       COALESCE(TRIBDEBITO.NOPROCESSOCOMUMUNICA, CAST(TRIBDEBITOPARCELA.PROCESSOJUDICIAL AS VARCHAR(30))) AS NOPROCESSOCOMUMUNICA,
       TRIBPARCELAMENTO.IDPARCELAMENTO AS IDPARCELAMENTO,
       TRIBPARCELAMENTO.NUMEROCONTRATO AS NUMEROPARCELAMENTO,
       TRIBPARCELAMENTO.ANOCONTRATO AS EXERCICIOPARCELAMENTO
FROM TRIBDEBITOPARCELARECEITA TRIBDEBITOPARCELARECEITA
INNER JOIN TRIBDEBITOPARCELA TRIBDEBITOPARCELA ON TRIBDEBITOPARCELARECEITA.ENTIDADE = TRIBDEBITOPARCELA.ENTIDADE
                                              AND TRIBDEBITOPARCELARECEITA.EXERCICIO = TRIBDEBITOPARCELA.EXERCICIO
                                              AND TRIBDEBITOPARCELARECEITA.TIPOCADASTRO = TRIBDEBITOPARCELA.TIPOCADASTRO
                                              AND TRIBDEBITOPARCELARECEITA.CADASTROGERAL = TRIBDEBITOPARCELA.CADASTROGERAL
                                              AND TRIBDEBITOPARCELARECEITA.GUIARECOLHIMENTO = TRIBDEBITOPARCELA.GUIARECOLHIMENTO
                                              AND TRIBDEBITOPARCELARECEITA.SUBDIVIDA = TRIBDEBITOPARCELA.SUBDIVIDA
                                              AND TRIBDEBITOPARCELARECEITA.PARCELA = TRIBDEBITOPARCELA.PARCELA
INNER JOIN TRIBDEBITO TRIBDEBITO ON TRIBDEBITO.ENTIDADE = TRIBDEBITOPARCELA.ENTIDADE
                                AND TRIBDEBITO.EXERCICIO = TRIBDEBITOPARCELA.EXERCICIO
                                AND TRIBDEBITO.TIPOCADASTRO = TRIBDEBITOPARCELA.TIPOCADASTRO
                                AND TRIBDEBITO.CADASTROGERAL = TRIBDEBITOPARCELA.CADASTROGERAL
                                AND TRIBDEBITO.GUIARECOLHIMENTO = TRIBDEBITOPARCELA.GUIARECOLHIMENTO
                                AND TRIBDEBITO.SUBDIVIDA = TRIBDEBITOPARCELA.SUBDIVIDA
INNER JOIN TRIBCADASTROGERAL TRIBCADASTROGERAL ON TRIBDEBITO.TIPOCADASTRO = TRIBCADASTROGERAL.TIPOCADASTRO
                                              AND TRIBDEBITO.CADASTROGERAL = TRIBCADASTROGERAL.CADASTROGERAL
INNER JOIN TRIBSITUACAOPARCELA TRIBSITUACAOPARCELA ON TRIBDEBITOPARCELA.SITUACAODEBITO = TRIBSITUACAOPARCELA.SITUACAOPARCELA
INNER JOIN TRIBTIPOSITUACAOPARCELA TRIBTIPOSITUACAOPARCELA ON TRIBSITUACAOPARCELA.TIPOSITUACAOPARCELA = TRIBTIPOSITUACAOPARCELA.TIPOSITUACAOPARCELA
INNER JOIN TRIBGUIARECOLHIMENTO TRIBGUIARECOLHIMENTO ON TRIBGUIARECOLHIMENTO.ENTIDADE = TRIBDEBITO.ENTIDADE
                                                    AND TRIBGUIARECOLHIMENTO.EXERCICIO = TRIBDEBITO.EXERCICIO
                                                    AND TRIBGUIARECOLHIMENTO.GUIARECOLHIMENTO = TRIBDEBITO.GUIARECOLHIMENTO
LEFT OUTER JOIN TRIBPROTESTO TRIBPROTESTO ON TRIBDEBITOPARCELA.IDPROTESTO = TRIBPROTESTO.IDPROTESTO
LEFT JOIN TRIBPARCELAMENTODEBITO TRIBPARCELAMENTODEBITO ON TRIBPARCELAMENTODEBITO.IDDEBITO = TRIBDEBITO.IDDEBITO
LEFT JOIN TRIBPARCELAMENTO TRIBPARCELAMENTO ON TRIBPARCELAMENTO.IDPARCELAMENTO = TRIBPARCELAMENTODEBITO.IDPARCELAMENTO
WHERE TRIBDEBITO.ENTIDADE = 1
  AND TRIBTIPOSITUACAOPARCELA.TIPO = 'A'
  AND TRIBDEBITOPARCELARECEITA.VALOR > 0
  AND TRIBCADASTROGERAL.EXCLUSAOLOGICA = 'N'
