/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.ws.rest.dto;

import br.com.elotech.tributos.dto.DebitoAutomaticoDTO;
import br.com.elotech.tributos.dto.DebitoAutomaticoIdDTO;
import br.com.elotech.tributos.dto.DebitoDTO;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;

public class DebitosToDebitoAutomatico
implements Function<DebitoDTO, DebitoAutomaticoDTO> {
    @Override
    public DebitoAutomaticoDTO apply(DebitoDTO debitoDTO) {
        DebitoAutomaticoIdDTO pk = DebitoAutomaticoIdDTO.builder().tipoCadastro(debitoDTO.getTipoCadastro()).cadastroGeral(debitoDTO.getCadastroGeral()).entidade(debitoDTO.getEntidade()).exercicio(debitoDTO.getExercicio()).guiaRecolhimento(debitoDTO.getGuiaRecolhimento()).subDivida(debitoDTO.getSubDivida()).build();
        return DebitoAutomaticoDTO.builder().pk(pk).descricaoGuia(debitoDTO.getDescricaoGuia()).nome(debitoDTO.getNome()).pessoa(debitoDTO.getPessoa()).valor(debitoDTO.getValor()).build();
    }

    public List<DebitoAutomaticoDTO> agruparESomar(List<DebitoDTO> debitosDto) {
        Comparator<DebitoAutomaticoIdDTO> orderComparator = Comparator.comparing(DebitoAutomaticoIdDTO::getExercicio).thenComparing(DebitoAutomaticoIdDTO::getGuiaRecolhimento).thenComparing(DebitoAutomaticoIdDTO::getSubDivida);
        return debitosDto.stream().map(arg_0 -> this.apply(arg_0)).collect(Collectors.groupingBy(DebitoAutomaticoDTO::getPk, this.somandoValor())).values().stream().map(Optional::get).sorted((o1, o2) -> orderComparator.compare(o1.getPk(), o2.getPk())).collect(Collectors.toList());
    }

    private Collector<DebitoAutomaticoDTO, ?, Optional<DebitoAutomaticoDTO>> somandoValor() {
        return Collectors.reducing((t, u) -> {
            t.setValor(t.getValor().add(u.getValor()));
            return t;
        });
    }
}

