/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.exception;

import br.com.elotech.tributos.dto.DebitoEmAbertoDTO;
import br.com.elotech.tributos.dto.DebitoParcelaTributoDTO;

/*
 * Exception performing whole class analysis ignored.
 */
public class GeraBoletoException
extends RuntimeException {
    private static final String SITUACAO_PARCELA_INVALIDA = "N\u00e3o \u00e9 poss\u00edvel emitir boleto para d\u00e9bito em %s. Exerc\u00edcio %d, D\u00edvida %d, SubDivida %d, Parcela %d.";
    private static final String GUIA_NAO_EMITE_BOLETO = "D\u00edvida %d do exerc\u00edcio %d configurada para n\u00e3o emitir boleto.";
    private static final String PROCESSO_APROVACAO = "D\u00e9bito possui processo de aprova\u00e7\u00e3o pendente: Cadastro: %d/%d, D\u00edvida: %d, Sub: %d e Parcela: %d.";
    private static final String DEBITO_NAO_ENCONTRADO = "N\u00e3o foi encontrado d\u00e9bito dispon\u00edvel para gera\u00e7\u00e3o do boleto.";
    private static final String AJUIZAMENTO_ELETRONICO = "Esta parcela pertence a um Ajuizamento eletr\u00f4nico, portanto, s\u00f3 pode ser emitida atrav\u00e9s da tela de (re)parcelamento. Cadastro: %d/%d, D\u00edvida: %d, Sub: %d e Parcela: %d.";

    public GeraBoletoException(String descricao) {
        super(descricao);
    }

    public static GeraBoletoException debitoAjuizadoEletronicamente(DebitoEmAbertoDTO debitoParcelaReceitaDTO) {
        return GeraBoletoException.message((String)String.format("Esta parcela pertence a um Ajuizamento eletr\u00f4nico, portanto, s\u00f3 pode ser emitida atrav\u00e9s da tela de (re)parcelamento. Cadastro: %d/%d, D\u00edvida: %d, Sub: %d e Parcela: %d.", debitoParcelaReceitaDTO.getTipoCadastro(), debitoParcelaReceitaDTO.getCadastroGeral(), debitoParcelaReceitaDTO.getDivida(), debitoParcelaReceitaDTO.getSubDivida(), debitoParcelaReceitaDTO.getParcela()));
    }

    public static GeraBoletoException debitoNaoEmiteBoleto() {
        return new GeraBoletoException("N\u00e3o foi encontrado d\u00e9bito dispon\u00edvel para gera\u00e7\u00e3o do boleto.");
    }

    public static GeraBoletoException message(String message) {
        return new GeraBoletoException(message);
    }

    public static GeraBoletoException situacaoParcelaInvalida(String situacao, Long exercicio, Long divida, Long subDivida, Long parcela) {
        return GeraBoletoException.message((String)String.format("N\u00e3o \u00e9 poss\u00edvel emitir boleto para d\u00e9bito em %s. Exerc\u00edcio %d, D\u00edvida %d, SubDivida %d, Parcela %d.", situacao, exercicio, divida, subDivida, parcela));
    }

    public static GeraBoletoException guiaNaoEmiteBoleto(Long divida, Long exercicio) {
        return GeraBoletoException.message((String)String.format("D\u00edvida %d do exerc\u00edcio %d configurada para n\u00e3o emitir boleto.", divida, exercicio));
    }

    public static GeraBoletoException debitoPossuiProcessoAprovacao(DebitoParcelaTributoDTO debitoParcelaTributoDTO) {
        return GeraBoletoException.message((String)String.format("D\u00e9bito possui processo de aprova\u00e7\u00e3o pendente: Cadastro: %d/%d, D\u00edvida: %d, Sub: %d e Parcela: %d.", debitoParcelaTributoDTO.getTipoCadastro(), debitoParcelaTributoDTO.getCadastroGeral(), debitoParcelaTributoDTO.getDivida(), debitoParcelaTributoDTO.getSubDivida(), debitoParcelaTributoDTO.getParcela()));
    }
}

