/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.acrescimo.calculo;

import br.com.elotech.tributos.domain.BaseCorrecaoMonetaria;
import br.com.elotech.tributos.domain.BaseJurosCorrecao;
import br.com.elotech.tributos.domain.BaseMultaCorrecao;
import br.com.elotech.tributos.domain.DividaFormaPagamentoTributo;
import br.com.elotech.tributos.domain.FormaCorrecao;
import br.com.elotech.tributos.domain.FormaPagamento;
import br.com.elotech.tributos.domain.MudancaMonetaria;
import br.com.elotech.tributos.domain.TipoFormaPagamento;
import br.com.elotech.tributos.domain.Tributo;
import br.com.elotech.tributos.domain.acrescimo.FormaCalculo;
import br.com.elotech.tributos.domain.acrescimo.IndiceComposto;
import br.com.elotech.tributos.domain.acrescimo.TipoCorrecao;
import br.com.elotech.tributos.domain.acrescimo.ValorIndice;
import br.com.elotech.tributos.dto.DebitoEmAbertoDTO;
import br.com.elotech.tributos.dto.DividaDTO;
import br.com.elotech.tributos.dto.acrescimo.AcrescimoDTO;
import br.com.elotech.tributos.dto.acrescimo.DividaFormaPagamentoDTO;
import br.com.elotech.tributos.dto.acrescimo.EntidadeCorrecaoDTO;
import br.com.elotech.tributos.dto.acrescimo.ParametroCalculoAcrescimoDTO;
import br.com.elotech.tributos.service.DiaUtilService;
import br.com.elotech.tributos.service.FormaCorrecaoService;
import br.com.elotech.tributos.service.FormaPagamentoService;
import br.com.elotech.tributos.service.MudancaMonetariaService;
import br.com.elotech.tributos.service.TributoService;
import br.com.elotech.tributos.service.acrescimo.calculo.CalculoAcrescimoParamatroService;
import br.com.elotech.tributos.service.acrescimo.calculo.CalculoAcrescimoService;
import br.com.elotech.tributos.service.acrescimo.calculo.correcao.CalculoCorrecaoUtils;
import br.com.elotech.tributos.service.acrescimo.calculo.multa.CalculoMultaComum;
import br.com.elotech.tributos.service.acrescimo.calculo.multa.CalculoMultaEspecialService;
import br.com.elotech.tributos.util.CalculoUtils;
import br.com.elotech.tributos.util.CalculoValoresConstants;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.web.server.ResponseStatusException;

@Service
public class CalculoAcrescimoService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CalculoAcrescimoService.class);
    private final CalculoAcrescimoParamatroService calculoAcrescimoParamatroService;
    private final CalculoMultaEspecialService calculoMultaEspecialService;
    private final DiaUtilService diaUtilService;
    private final MudancaMonetariaService mudancaMonetariaService;
    private final FormaPagamentoService formaPagamentoService;
    private final FormaCorrecaoService formaCorrecaoService;
    private final TributoService tributoService;
    private static final Boolean NAO_ARREDONDA = Boolean.FALSE;
    private static final BigDecimal DIVISOR_100 = BigDecimal.valueOf(100L);
    private static final Set<TipoFormaPagamento> COTA_UNICA = EnumSet.of(TipoFormaPagamento.COTA_UNICA, TipoFormaPagamento.TRES_PARCELAS);

    public CalculoAcrescimoService(CalculoAcrescimoParamatroService calculoAcrescimoParamatroService, CalculoMultaEspecialService calculoMultaEspecialService, DiaUtilService diaUtilService, MudancaMonetariaService mudancaMonetariaService, FormaPagamentoService formaPagamentoService, FormaCorrecaoService formaCorrecaoService, TributoService tributoService) {
        this.calculoAcrescimoParamatroService = calculoAcrescimoParamatroService;
        this.calculoMultaEspecialService = calculoMultaEspecialService;
        this.diaUtilService = diaUtilService;
        this.mudancaMonetariaService = mudancaMonetariaService;
        this.formaPagamentoService = formaPagamentoService;
        this.formaCorrecaoService = formaCorrecaoService;
        this.tributoService = tributoService;
    }

    private BigDecimal getValorFinal(BigDecimal valor, Boolean arredondaPorPartesNoCalculo) {
        return arredondaPorPartesNoCalculo != false ? valor.setScale((int)CalculoValoresConstants.QUANTIDADE_CASAS_DECIMAIS, 4) : valor;
    }

    private BigDecimal calculaBaseCompostaCorrecao(AcrescimoDTO dados, BigDecimal valorParaCalculo, Boolean calculaBaseComposta, ParametroCalculoAcrescimoDTO parametros) {
        if (parametros.getEntidadeCorrecao().getBaseCorrecaoMonetaria().equals((Object)BaseCorrecaoMonetaria.PRINCIPAL_MULTA) || parametros.getEntidadeCorrecao().getBaseCorrecaoMonetaria().equals((Object)BaseCorrecaoMonetaria.PRINCIPAL_JUROS_MULTA)) {
            valorParaCalculo = valorParaCalculo.add(this.calcularMulta(dados, Boolean.valueOf(calculaBaseComposta == false), parametros));
        }
        if (parametros.getEntidadeCorrecao().getBaseCorrecaoMonetaria().equals((Object)BaseCorrecaoMonetaria.PRINCIPAL_JUROS) || parametros.getEntidadeCorrecao().getBaseCorrecaoMonetaria().equals((Object)BaseCorrecaoMonetaria.PRINCIPAL_JUROS_MULTA)) {
            valorParaCalculo = valorParaCalculo.add(this.calcularJuros(dados, Boolean.valueOf(calculaBaseComposta == false), parametros));
        }
        return valorParaCalculo;
    }

    private LocalDate atualizaDataBaseCalculo(IndiceComposto lastIndiceComposto, IndiceComposto indiceComposto, LocalDate dataBaseCalculo) {
        if (Objects.isNull(lastIndiceComposto) || indiceComposto.equals((Object)lastIndiceComposto) && !indiceComposto.getSobreporPeriodo().booleanValue()) {
            switch (1.$SwitchMap$br$com$elotech$tributos$domain$acrescimo$PeriodoCorrecao[indiceComposto.getIndiceCorrecao().getPeriodoCorrecao().ordinal()]) {
                case 1: {
                    return dataBaseCalculo.plusDays(1L);
                }
                case 2: {
                    return dataBaseCalculo.plusMonths(1L);
                }
                case 3: {
                    return dataBaseCalculo.plusYears(1L);
                }
            }
        }
        return dataBaseCalculo;
    }

    private BigDecimal calcularCorrecao(AcrescimoDTO dados, Boolean calculaBaseComposta, ParametroCalculoAcrescimoDTO parametros) {
        if (!parametros.getEntidadeCorrecao().getEntidadeCorrecaoIndiceCorrecao().incideNaSituacao(dados.getSituacaoLegal()).booleanValue() || Objects.nonNull(dados.getTributo()) && !parametros.getTributo().getIncideCorrecao().booleanValue()) {
            return this.getValorFinal(dados.getValorCorrecao(), NAO_ARREDONDA);
        }
        BigDecimal valorParaCalculo = dados.getValorOriginal();
        if (calculaBaseComposta.booleanValue()) {
            valorParaCalculo = this.calculaBaseCompostaCorrecao(dados, valorParaCalculo, calculaBaseComposta, parametros);
            dados.setValor(valorParaCalculo);
        }
        BigDecimal valorRetorno = calculaBaseComposta != false ? dados.getValorCorrecao() : BigDecimal.ZERO;
        ValorIndice valorIndiceCorrecao = null;
        LocalDate dataBaseCalculo = this.getDataCorrecao(dados, parametros);
        LocalDate dataPagamento = CalculoCorrecaoUtils.novaDataPagamento((FormaCorrecao)parametros.getFormaCorrecao(), (LocalDate)dataBaseCalculo, (LocalDate)dados.getDataReferencia());
        IndiceComposto lastIndiceComposto = null;
        IndiceComposto indiceComposto = null;
        FormaCalculo formaCalculo = null;
        while (dataBaseCalculo.isBefore(dataPagamento)) {
            indiceComposto = CalculoCorrecaoUtils.getIndiceCompostoByData((FormaCorrecao)parametros.getFormaCorrecao(), (LocalDate)dataBaseCalculo);
            formaCalculo = indiceComposto.getIndiceCorrecao().getFormaCalculo();
            valorIndiceCorrecao = CalculoCorrecaoUtils.getValorIndice((FormaCorrecao)parametros.getFormaCorrecao(), lastIndiceComposto, (IndiceComposto)indiceComposto, (LocalDate)dataBaseCalculo);
            lastIndiceComposto = indiceComposto;
            valorRetorno = valorRetorno.add(formaCalculo.getCalculoCorrecao().calculoValorCorrecao(valorParaCalculo.add(!formaCalculo.equals((Object)FormaCalculo.VALOR_ATUAL) ? valorRetorno : BigDecimal.ZERO), dataBaseCalculo, dataPagamento, indiceComposto, valorIndiceCorrecao, parametros.getCorrecoesMonetarias()));
            dataBaseCalculo = this.atualizaDataBaseCalculo(lastIndiceComposto, indiceComposto, dataBaseCalculo);
            if (!FormaCalculo.VARIACAO.equals((Object)formaCalculo) && !FormaCalculo.VALOR_ATUAL.equals((Object)formaCalculo)) continue;
            dataBaseCalculo = indiceComposto.getDataFinal().plusDays(1L);
        }
        if (calculaBaseComposta.booleanValue() && parametros.getFormaCorrecao().getAgregaAoValorDoPrincipal().booleanValue()) {
            dados.setValor(dados.getValor().add(this.getValorFinal(valorRetorno, parametros.getEntidadeCorrecao().getArredondaPorPartesNoCalculo())));
            return BigDecimal.ZERO;
        }
        return this.getValorFinal(valorRetorno, parametros.getEntidadeCorrecao().getArredondaPorPartesNoCalculo());
    }

    private LocalDate getDataCorrecao(AcrescimoDTO dados, ParametroCalculoAcrescimoDTO parametros) {
        if (TipoCorrecao.DATA_LANCAMENTO.equals((Object)parametros.getFormaCorrecao().getTipoCorrecao())) {
            return dados.getDataLancamento();
        }
        return dados.getDataVencimento();
    }

    private BigDecimal calculaBaseCompostaJuros(AcrescimoDTO dados, BigDecimal valorParaCalculo, Boolean calculaBaseComposta, ParametroCalculoAcrescimoDTO parametros) {
        if (parametros.getEntidadeCorrecao().getBaseJuros().equals((Object)BaseJurosCorrecao.PRINCIPAL_CORRECAO) || parametros.getEntidadeCorrecao().getBaseJuros().equals((Object)BaseJurosCorrecao.PRINCIPAL_CORRECAO_MULTA)) {
            valorParaCalculo = valorParaCalculo.add(this.calcularCorrecao(dados, Boolean.valueOf(calculaBaseComposta == false), parametros));
        }
        if (parametros.getEntidadeCorrecao().getBaseJuros().equals((Object)BaseJurosCorrecao.PRINCIPAL_MULTA) || parametros.getEntidadeCorrecao().getBaseJuros().equals((Object)BaseJurosCorrecao.PRINCIPAL_CORRECAO_MULTA)) {
            valorParaCalculo = valorParaCalculo.add(this.calcularMulta(dados, Boolean.valueOf(calculaBaseComposta == false), parametros));
        }
        return valorParaCalculo;
    }

    private BigDecimal calcularJuros(AcrescimoDTO dados, Boolean calculaBaseComposta, ParametroCalculoAcrescimoDTO parametros) {
        Assert.notNull((Object)parametros.getEntidadeCorrecao().getMesJuros(), (String)String.format("Entidade corre\u00e7\u00e3o sem m\u00eas juros configurado %s", parametros.getEntidadeCorrecao()));
        Assert.notNull((Object)parametros.getEntidadeCorrecao().getJuroMora(), (String)String.format("Entidade corre\u00e7\u00e3o sem juros mora configurado %s", parametros.getEntidadeCorrecao()));
        if (!dados.getDataReferencia().isAfter(dados.getDataVencimento())) {
            return this.getValorFinal(dados.getValorJuros(), NAO_ARREDONDA);
        }
        if (!parametros.getEntidadeCorrecao().getEntidadeCorrecaoIndiceJuros().incideNaSituacao(dados.getSituacaoLegal()).booleanValue() || Objects.nonNull(dados.getTributo()) && !parametros.getTributo().getIncideJuros().booleanValue()) {
            return this.getValorFinal(dados.getValorJuros(), NAO_ARREDONDA);
        }
        BigDecimal valorParaCalculo = dados.getValorOriginal();
        if (calculaBaseComposta.booleanValue()) {
            valorParaCalculo = this.calculaBaseCompostaJuros(dados, valorParaCalculo, calculaBaseComposta, parametros);
        }
        BigDecimal aliquotaVariavel = new BigDecimal(parametros.getEntidadeCorrecao().getMesJuros().getCalculoJuros().calculaAliquota(dados.getDataVencimento(), dados.getDataReferencia()));
        BigDecimal valorRetorno = valorParaCalculo.multiply(parametros.getEntidadeCorrecao().getJuroMora()).multiply(aliquotaVariavel).divide(DIVISOR_100);
        return this.getValorFinal(valorRetorno, parametros.getEntidadeCorrecao().getArredondaPorPartesNoCalculo());
    }

    private BigDecimal calculaBaseCompostaMulta(AcrescimoDTO dados, BigDecimal valorParaCalculo, Boolean calculaBaseComposta, ParametroCalculoAcrescimoDTO parametros) {
        if (parametros.getEntidadeCorrecao().getBaseMulta().equals((Object)BaseMultaCorrecao.PRINCIPAL_CORRECAO) || parametros.getEntidadeCorrecao().getBaseMulta().equals((Object)BaseMultaCorrecao.PRINCIPAL_CORRECAO_JUROS)) {
            valorParaCalculo = valorParaCalculo.add(this.calcularCorrecao(dados, Boolean.valueOf(calculaBaseComposta == false), parametros));
        }
        if (parametros.getEntidadeCorrecao().getBaseMulta().equals((Object)BaseMultaCorrecao.PRINCIPAL_JUROS) || parametros.getEntidadeCorrecao().getBaseMulta().equals((Object)BaseMultaCorrecao.PRINCIPAL_CORRECAO_JUROS)) {
            valorParaCalculo = valorParaCalculo.add(this.calcularJuros(dados, Boolean.valueOf(calculaBaseComposta == false), parametros));
        }
        return valorParaCalculo;
    }

    private BigDecimal calcularMulta(AcrescimoDTO dados, Boolean calculaBaseComposta, ParametroCalculoAcrescimoDTO parametros) {
        BigDecimal percentualMultaComum;
        Long diasAtraso;
        if (!parametros.getEntidadeCorrecao().getEntidadeCorrecaoIndiceMulta().incideNaSituacao(dados.getSituacaoLegal()).booleanValue() || Objects.nonNull(dados.getTributo()) && !parametros.getTributo().getIncideMulta().booleanValue()) {
            return this.getValorFinal(dados.getValorMulta(), NAO_ARREDONDA);
        }
        BigDecimal valorParaCalculo = dados.getValorOriginal();
        if (calculaBaseComposta.booleanValue()) {
            valorParaCalculo = this.calculaBaseCompostaMulta(dados, valorParaCalculo, calculaBaseComposta, parametros);
        }
        if ((diasAtraso = this.diaUtilService.countDiasAtraso(dados.getDataVencimento(), dados.getDataReferencia(), parametros.getEntidadeCorrecao().getMultaDias())) <= 0L) {
            return this.getValorFinal(dados.getValorMulta(), NAO_ARREDONDA);
        }
        BigDecimal percentualMulta = percentualMultaComum = CalculoMultaComum.calculaValorMulta((List)parametros.getEntidadeCorrecao().getCorrecaoMulta(), (Long)diasAtraso, (Boolean)dados.getSituacaoLegal().isDividaAtivaOrJuizo(), (Boolean)dados.getParcelado());
        if (!parametros.getEntidadeCorrecao().getSobreporMulta().booleanValue()) {
            BigDecimal percentualMultaEspecial = this.calculoMultaEspecialService.calculaValorMultaEspecial(parametros.getEntidadeCorrecao().getCorrecaoMultaEspecial(), dados.getDataVencimento(), dados.getDataReferencia(), parametros.getEntidadeCorrecao().getMultaDias());
            percentualMulta = percentualMultaComum.add(percentualMultaEspecial);
        }
        BigDecimal valorRetorno = valorParaCalculo.multiply(percentualMulta).divide(DIVISOR_100);
        return this.getValorFinal(valorRetorno, parametros.getEntidadeCorrecao().getArredondaPorPartesNoCalculo());
    }

    public EntidadeCorrecaoDTO getEntidadeCorrecao(Long entidade, Long exercicio, Optional<Long> divida) {
        if (Objects.isNull(entidade) || Objects.isNull(exercicio)) {
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "N\u00e3o foi poss\u00edvel realizar o c\u00e1lculo pois n\u00e3o foram informados os dados da entidade e do exerc\u00edcio.");
        }
        return this.calculoAcrescimoParamatroService.getEntidadeCorrecao(entidade, exercicio, divida);
    }

    private Boolean podeCalcularAcrescimos(AcrescimoDTO dados, ParametroCalculoAcrescimoDTO parametros) {
        return (parametros.getFormaCorrecao().getTipoCorrecao().equals((Object)TipoCorrecao.DATA_VENCIMENTO) && dados.getDataReferencia().isAfter(dados.getDataVencimento()) || parametros.getFormaCorrecao().getTipoCorrecao().equals((Object)TipoCorrecao.DATA_LANCAMENTO)) && !Arrays.asList(TipoFormaPagamento.COTA_UNICA, TipoFormaPagamento.TRES_PARCELAS).contains(parametros.getFormaPagamento().getTipoFormaPagamento());
    }

    private void verificaDataVencimento(AcrescimoDTO dados) {
        LocalDate proximoDiaUtil;
        if (!this.diaUtilService.diaUtil(dados.getDataVencimento()).booleanValue() && Objects.nonNull(proximoDiaUtil = this.diaUtilService.diaUtilProximo(dados.getDataVencimento())) && !dados.getDataVencimento().isAfter(dados.getDataReferencia()) && !dados.getDataReferencia().isAfter(proximoDiaUtil)) {
            dados.setDataVencimentoOriginal(dados.getDataVencimento());
            dados.setDataVencimento(proximoDiaUtil);
        }
    }

    private DividaFormaPagamentoTributo getDividaFormaPagamentoTributo(AcrescimoDTO dados, ParametroCalculoAcrescimoDTO parametros) {
        if (Objects.nonNull(parametros.getDividaFormaPagamento())) {
            return parametros.getDividaFormaPagamento().getFormasPagamentoTributo().stream().filter(tributo -> tributo.getId().getTributo().compareToIgnoreCase(dados.getTributo()) == 0).findFirst().orElse(null);
        }
        return null;
    }

    private Boolean possuiDesconto(AcrescimoDTO dados, ParametroCalculoAcrescimoDTO parametros, LocalDate proximoDiaUtil) {
        return Objects.nonNull(parametros.getDividaFormaPagamento()) && (parametros.getDividaFormaPagamento().getVencimento().isAfter(dados.getDataReferencia()) && COTA_UNICA.contains(parametros.getFormaPagamento().getTipoFormaPagamento()) || !COTA_UNICA.contains(parametros.getFormaPagamento().getTipoFormaPagamento()) && proximoDiaUtil.compareTo(dados.getDataReferencia()) >= 0);
    }

    private void calculaValorDesconto(AcrescimoDTO dados, ParametroCalculoAcrescimoDTO parametros) {
        DividaFormaPagamentoTributo dividaFormaPagamentoTributo;
        LocalDate proximoDiaUtil;
        LocalDate localDate = proximoDiaUtil = this.diaUtilService.diaUtil(dados.getDataVencimento()) != false ? dados.getDataVencimento() : this.diaUtilService.diaUtilProximo(dados.getDataVencimento());
        if (dados.getDescontoParcelamento().compareTo(BigDecimal.ZERO) > 0 && (dados.getDataReferencia().isBefore(proximoDiaUtil) || COTA_UNICA.contains(parametros.getFormaPagamento().getTipoFormaPagamento()))) {
            dados.setValorDescontoPrincipal(CalculoUtils.arredonda((BigDecimal)dados.getValor().multiply(dados.getDescontoParcelamento()).divide(DIVISOR_100)));
        }
        if (Objects.nonNull(dividaFormaPagamentoTributo = this.getDividaFormaPagamentoTributo(dados, parametros)) && dividaFormaPagamentoTributo.possuiDesconto().booleanValue() && parametros.getFormaPagamento().getId().compareTo(0L) > 0) {
            if (this.possuiDesconto(dados, parametros, proximoDiaUtil).booleanValue()) {
                dados.setValorDescontoPrincipal(dados.getValorDescontoPrincipal().add(CalculoUtils.arredonda((BigDecimal)dados.getValor().multiply(dividaFormaPagamentoTributo.getDesconto()).divide(DIVISOR_100))));
            }
            if (dividaFormaPagamentoTributo.getDescontoJuros().compareTo(BigDecimal.ZERO) > 0) {
                dados.setValorDescontoJuros(dados.getValorDescontoJuros().add(CalculoUtils.arredonda((BigDecimal)dados.getValorJuros().multiply(dividaFormaPagamentoTributo.getDescontoJuros()).divide(DIVISOR_100))));
            }
            if (dividaFormaPagamentoTributo.getDescontoMulta().compareTo(BigDecimal.ZERO) > 0) {
                dados.setValorDescontoMulta(dados.getValorDescontoMulta().add(CalculoUtils.arredonda((BigDecimal)dados.getValorMulta().multiply(dividaFormaPagamentoTributo.getDescontoMulta()).divide(DIVISOR_100))));
            }
            if (dividaFormaPagamentoTributo.getDescontoCorrecao().compareTo(BigDecimal.ZERO) > 0) {
                dados.setValorDescontoCorrecao(dados.getValorDescontoCorrecao().add(CalculoUtils.arredonda((BigDecimal)dados.getValorCorrecao().multiply(dividaFormaPagamentoTributo.getDescontoCorrecao()).divide(DIVISOR_100))));
            }
        }
    }

    @Transactional(readOnly=true)
    public AcrescimoDTO calculaAcrescimos(AcrescimoDTO dados) {
        ParametroCalculoAcrescimoDTO parametros = this.loadParamsCalculo(dados);
        if (parametros.getFormaCorrecao().getConverteMoeda().booleanValue()) {
            dados.setValor(CalculoCorrecaoUtils.converteMoeda((BigDecimal)dados.getValor(), (LocalDate)dados.getDataLancamento(), (LocalDate)dados.getDataVencimento(), (FormaCorrecao)parametros.getFormaCorrecao()));
            log.trace("Converteu moeda");
        }
        if (Objects.nonNull(parametros.getCorrecoesMonetarias())) {
            parametros.getCorrecoesMonetarias().forEach(mudancaMonetaria -> {
                this.calculaCorrecaoMonetaria(dados, mudancaMonetaria);
                log.trace("Calculou Correcao monetaria {}", (Object)mudancaMonetaria.getId());
            });
        }
        dados.setValorOriginal(dados.getValor());
        dados.setDataVencimentoOriginal(dados.getDataVencimento());
        if (this.podeCalcularAcrescimos(dados, parametros).booleanValue()) {
            this.verificaDataVencimento(dados);
            log.trace("Verificou Data de vencimento ");
            dados.setValorCorrecao(CalculoUtils.arredonda((BigDecimal)this.calcularCorrecao(dados, Boolean.TRUE, parametros)));
            log.trace("Calculou Corre\u00e7\u00e3o");
            dados.setValorMulta(CalculoUtils.arredonda((BigDecimal)this.calcularMulta(dados, Boolean.TRUE, parametros)));
            log.trace("Calculou Multa");
            dados.setValorJuros(CalculoUtils.arredonda((BigDecimal)this.calcularJuros(dados, Boolean.TRUE, parametros)));
            log.trace("Calculou Juros");
            dados.setValor(CalculoUtils.arredonda((BigDecimal)dados.getValor()));
            log.trace("Arredondou valor");
            dados.setDataVencimento(dados.getDataVencimentoOriginal());
        }
        if (dados.getCalculaValorDesconto().booleanValue()) {
            this.calculaValorDesconto(dados, parametros);
            log.trace("Calculou desconto");
        }
        return dados;
    }

    @Transactional
    public List<AcrescimoDTO> calculaAcrescimos(List<AcrescimoDTO> dados) {
        for (AcrescimoDTO dto : dados) {
            this.calculaAcrescimos(dto);
        }
        return dados;
    }

    @Transactional(readOnly=true)
    public List<DebitoEmAbertoDTO> calculaAcrescimos(List<DebitoEmAbertoDTO> params, Long formaPagamento) {
        return params.stream().map(debito -> {
            AcrescimoDTO valorAcrescimo = this.calculaAcrescimos(AcrescimoDTO.of((DebitoEmAbertoDTO)debito, (Long)formaPagamento));
            debito.setValorPrincipal(valorAcrescimo.getValor());
            debito.setValorJuros(valorAcrescimo.getValorJuros());
            debito.setValorMulta(valorAcrescimo.getValorMulta());
            debito.setValorCorrecao(valorAcrescimo.getValorCorrecao());
            debito.setValorDescontoPrincipal(valorAcrescimo.getValorDescontoPrincipal());
            debito.setValorDescontoJuros(valorAcrescimo.getValorDescontoJuros());
            debito.setValorDescontoMulta(valorAcrescimo.getValorDescontoMulta());
            debito.setValorDescontoCorrecao(valorAcrescimo.getValorDescontoCorrecao());
            return debito;
        }).collect(Collectors.toList());
    }

    private ParametroCalculoAcrescimoDTO loadParamsCalculo(AcrescimoDTO dados) {
        ParametroCalculoAcrescimoDTO parametros = new ParametroCalculoAcrescimoDTO();
        parametros.setEntidadeCorrecao(this.loadEntidadeCorrecao(dados));
        log.trace("Carregou entidade corre\u00e7\u00e3o.");
        parametros.setTributo(this.loadTributo(dados));
        log.trace("Carregou tributo.");
        parametros.setFormaCorrecao(this.loadFormaCorrecao(dados, parametros.getEntidadeCorrecao()));
        log.trace("Carregou forma corre\u00e7\u00e3o.");
        parametros.setFormaPagamento(this.loadFormaPagamento(dados));
        log.trace("Carregou forma pagamento.");
        parametros.setCorrecoesMonetarias(this.mudancaMonetariaService.findByRsql(Optional.empty()));
        log.trace("Carregou corre\u00e7\u00f5es monetarias.");
        parametros.setDividaFormaPagamento(this.loadDividaFormaPagamento(dados));
        log.trace("Carregou divida forma pagamento.");
        return parametros;
    }

    private EntidadeCorrecaoDTO loadEntidadeCorrecao(AcrescimoDTO dados) {
        return this.getEntidadeCorrecao(dados.getEntidade(), dados.getExercicio(), Optional.ofNullable(dados.getDivida()).map(DividaDTO::getDivida));
    }

    private FormaPagamento loadFormaPagamento(AcrescimoDTO dados) {
        return this.formaPagamentoService.findOne(dados.getFormaPagamento());
    }

    private DividaFormaPagamentoDTO loadDividaFormaPagamento(AcrescimoDTO dados) {
        return this.calculoAcrescimoParamatroService.getDividaFormaPagamento(dados.getEntidade(), dados.getExercicio(), dados.getDivida().getDivida(), dados.getFormaPagamento());
    }

    private FormaCorrecao loadFormaCorrecao(AcrescimoDTO dados, EntidadeCorrecaoDTO entidadeCorrecao) {
        FormaCorrecao entity = this.formaCorrecaoService.findOne(dados.getFormaCorrecao());
        return Objects.nonNull(entity) ? entity : entidadeCorrecao.getFormaCorrecao();
    }

    private Tributo loadTributo(AcrescimoDTO dados) {
        return this.tributoService.findByEntidadeAndExercicioAndTributo(dados.getEntidade(), dados.getExercicio(), dados.getTributo());
    }

    private void calculaCorrecaoMonetaria(AcrescimoDTO dados, MudancaMonetaria mudancaMonetaria) {
        if (mudancaMonetaria.getValorMonetario().compareTo(BigDecimal.ZERO) > 0 && mudancaMonetaria.getData().isAfter(dados.getDataVencimento()) && mudancaMonetaria.getData().compareTo(dados.getDataReferencia()) <= 0) {
            dados.setValor(dados.getValor().divide(mudancaMonetaria.getValorMonetario(), (int)CalculoValoresConstants.DEZESSEIS_CASAS_DECIMAIS, 6));
        }
    }
}

