/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.service.support.ReadOnlyService;
import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.Imobiliaria;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.dto.ImobiliariaDTO;
import br.com.elotech.tributos.repository.ImobiliariaRepository;
import br.com.elotech.tributos.service.CadastroGeralService;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class ImobiliariaService
extends ReadOnlyService<Imobiliaria, Long> {
    private final ImobiliariaRepository imobiliariaRepository;
    private final CadastroGeralService cadastroGeralService;

    public ImobiliariaService(ImobiliariaRepository imobiliariaRepository, CadastroGeralService cadastroGeralService) {
        this.imobiliariaRepository = imobiliariaRepository;
        this.cadastroGeralService = cadastroGeralService;
    }

    public Page<ImobiliariaDTO> getImobiliarias(String search, Pageable pageable) {
        Page imobiliariasPaged = this.findByRsql(search, pageable);
        return imobiliariasPaged.map(ImobiliariaDTO::of);
    }

    public ImobiliariaDTO getResumo(Long id) {
        Imobiliaria imobiliariasCadastro = (Imobiliaria)this.imobiliariaRepository.findById((Object)id).orElseThrow(() -> new EloValidationException("N\u00e3o foi poss\u00edvel encontrar os dados da imobili\u00e1ria."));
        return ImobiliariaDTO.of((Imobiliaria)imobiliariasCadastro);
    }

    public void delete(Long id) {
        if (Boolean.TRUE.equals(this.imobiliariaRepository.hasCadastroVinculado(id))) {
            throw new EloValidationException("N\u00e3o \u00e9 poss\u00edvel remover esta Imobili\u00e1ria pois existem cadastros vinculados.");
        }
        this.imobiliariaRepository.deleteById((Object)id);
    }

    private void validaVinculoPessoaImobiliaria(ImobiliariaDTO imobiliariaDTO) {
        List imobiliarias = this.imobiliariaRepository.findByPessoaIdAndCadastroGeralExclusaoLogicaFalse(imobiliariaDTO.getPessoa().getId()).stream().filter(imobiliaria -> !imobiliaria.getId().equals(imobiliariaDTO.getId())).collect(Collectors.toList());
        if (!imobiliarias.isEmpty()) {
            throw new EloValidationException(String.format("Pessoa j\u00e1 vinculada com outra imobili\u00e1ria %d", ((Imobiliaria)imobiliarias.get(0)).getId()));
        }
    }

    public ImobiliariaDTO save(ImobiliariaDTO imobiliariaDTO) {
        Imobiliaria imobiliaria = new Imobiliaria();
        imobiliaria.setId(imobiliariaDTO.getId());
        imobiliaria.setPessoa(imobiliariaDTO.getPessoa());
        imobiliaria.setCadastroGeral(this.buscaCadastroGeral(imobiliariaDTO));
        imobiliaria.setAtivo(imobiliariaDTO.getAtivo());
        this.validaVinculoPessoaImobiliaria(imobiliariaDTO);
        return ImobiliariaDTO.of((Imobiliaria)((Imobiliaria)this.imobiliariaRepository.save((Object)imobiliaria)));
    }

    public ImobiliariaDTO edit(Long id, ImobiliariaDTO imobiliariaDTO) {
        Imobiliaria imobiliaria = (Imobiliaria)this.imobiliariaRepository.findById((Object)id).orElseThrow(() -> new EloValidationException(String.format("Imobili\u00e1ria %d n\u00e3o encontrada!", id)));
        imobiliaria.setCadastroGeral(this.buscaCadastroGeral(imobiliariaDTO));
        imobiliaria.setPessoa(imobiliariaDTO.getPessoa());
        imobiliaria.setAtivo(imobiliariaDTO.getAtivo());
        this.validaVinculoPessoaImobiliaria(imobiliariaDTO);
        return ImobiliariaDTO.of((Imobiliaria)((Imobiliaria)this.imobiliariaRepository.save((Object)imobiliaria)));
    }

    private CadastroGeral buscaCadastroGeral(ImobiliariaDTO imobiliariaDTO) {
        if (Objects.nonNull(imobiliariaDTO.getTipoCadastro()) && Objects.nonNull(imobiliariaDTO.getCadastroGeral())) {
            return (CadastroGeral)this.cadastroGeralService.findByTipoCadastroAndCadastroGeral(TipoCadastro.fromValue((Long)imobiliariaDTO.getTipoCadastro()), imobiliariaDTO.getCadastroGeral()).orElseThrow(() -> new EloValidationException(String.format("Cadastro %d/%d n\u00e3o encontrado!", imobiliariaDTO.getTipoCadastro(), imobiliariaDTO.getCadastroGeral())));
        }
        return null;
    }
}

