/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.service.support.ReadOnlyService;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.domain.rural.CadastroRural;
import br.com.elotech.tributos.dto.CadastroGeralSearchParamsDTO;
import br.com.elotech.tributos.dto.CadastroRuralRowDTO;
import br.com.elotech.tributos.dto.CadastroSearchDTO;
import br.com.elotech.tributos.hibernatesearch.domain.HibernateSearchParams;
import br.com.elotech.tributos.hibernatesearch.facet.FacetCadastroRural;
import br.com.elotech.tributos.service.HibernateSearchService;
import java.util.Arrays;
import java.util.List;
import org.apache.lucene.search.Query;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class CadastroRuralService
extends ReadOnlyService<CadastroRural, Long> {
    private final HibernateSearchService hibernateSearchService;

    public CadastroRuralService(HibernateSearchService hibernateSearchService) {
        this.hibernateSearchService = hibernateSearchService;
    }

    public CadastroSearchDTO<CadastroRuralRowDTO> searchCadastrosRurais(CadastroGeralSearchParamsDTO searchParams, Pageable pageable) {
        List<String> searchFields = Arrays.asList("cadastroGeral", "cep", "pessoa.nome", "pessoa.cnpjCpf", "proprietarios.pessoa.nome", "proprietarios.pessoa.cnpjCpf", "logradouro.logradouro", "logradouroDescricao", "bairro.bairro", "bairroDescricao", "complemento", "nomePropriedade", "endereco", "distrito.id", "distrito.descricao", "setor.setor", "setor.apelido", "lote");
        HibernateSearchParams hibernateSearchParams = new HibernateSearchParams(this.getEm(), CadastroRural.class, pageable, searchParams.getSearch(), searchFields, Arrays.asList(FacetCadastroRural.values()));
        Query query = hibernateSearchParams.getQueryBuilder().bool().must(hibernateSearchParams.createQueryFromSearchFields()).must(hibernateSearchParams.createQueryWithSpecificField("tipoCadastroDescricao", TipoCadastro.RURAL.getDescricao())).createQuery();
        return this.hibernateSearchService.geraCadastroSearchDTO(query, hibernateSearchParams, searchParams.getFacets(), CadastroRuralRowDTO::from);
    }
}

