/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.enumerable.common.ModuloEnum;
import br.com.elotech.core.rsql.RsqlSpecification;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.Bloqueto;
import br.com.elotech.tributos.domain.ParametroEntidadeExercicio;
import br.com.elotech.tributos.domain.ParametroEntidadeExercicioEnum;
import br.com.elotech.tributos.domain.pagamento.BaixaAutomaticaDetalhe;
import br.com.elotech.tributos.domain.pagamento.BaixaAutomaticaDetalheId;
import br.com.elotech.tributos.domain.pagamento.PagamentoLote;
import br.com.elotech.tributos.domain.pagamento.PagamentoLoteId;
import br.com.elotech.tributos.dto.BaixaAutomaticaCadastroDTO;
import br.com.elotech.tributos.dto.pagamento.BaixaAutomaticaDetalheDTO;
import br.com.elotech.tributos.dto.pagamento.QuantidadeInconsistenciaLoteDTO;
import br.com.elotech.tributos.repository.BaixaAutomaticaDetalheRepository;
import br.com.elotech.tributos.service.ParametroEntidadeExercicioService;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class BaixaAutomaticaDetalheService
extends CrudService<BaixaAutomaticaDetalhe, BaixaAutomaticaDetalheId> {
    private final BaixaAutomaticaDetalheRepository baixaAutomaticaDetalheRepository;
    private final ParametroEntidadeExercicioService parametroEntidadeExercicioService;

    public BaixaAutomaticaDetalheService(BaixaAutomaticaDetalheRepository baixaAutomaticaDetalheRepository, ParametroEntidadeExercicioService parametroEntidadeExercicioService) {
        this.baixaAutomaticaDetalheRepository = baixaAutomaticaDetalheRepository;
        this.parametroEntidadeExercicioService = parametroEntidadeExercicioService;
    }

    public QuantidadeInconsistenciaLoteDTO countInconsistenciasLote(Long entidade, Long exercicio, Long lote) {
        return QuantidadeInconsistenciaLoteDTO.of((Long)this.baixaAutomaticaDetalheRepository.countInconsistenciasLote(entidade, exercicio, lote));
    }

    public List<BaixaAutomaticaDetalhe> findByPagamentoLote(PagamentoLote pagamentoLote) {
        List baixasAutomaticaDetalhe = this.baixaAutomaticaDetalheRepository.findByPagamentoLote(pagamentoLote);
        baixasAutomaticaDetalhe.sort(Comparator.comparing(baixaAutomaticaDetalhe -> baixaAutomaticaDetalhe.getId().getSequenciaArquivo()));
        return baixasAutomaticaDetalhe;
    }

    public Page<BaixaAutomaticaDetalheDTO> findAllBaixaAutomaticaDetalhes(Optional<String> search, Pageable pageable) {
        Page result = search.isPresent() ? this.baixaAutomaticaDetalheRepository.findAll((Specification)new RsqlSpecification(this.getEm(), search.get(), Optional.empty()), pageable) : this.baixaAutomaticaDetalheRepository.findAll(pageable);
        return result.map(BaixaAutomaticaDetalheDTO::of);
    }

    public Optional<Bloqueto> getBoletoPagoSuperSimples(String sequencia) {
        return this.baixaAutomaticaDetalheRepository.getBoletoPagoSuperSimples(sequencia);
    }

    public BaixaAutomaticaCadastroDTO findCadastroSuperSimples(String cnpj) {
        return this.baixaAutomaticaDetalheRepository.findCadastroMobiliarioByCnpj(cnpj).orElseGet(() -> this.baixaAutomaticaDetalheRepository.findCadastroMobiliarioByCnpjRaiz(cnpj).orElseGet(() -> this.baixaAutomaticaDetalheRepository.findCadastroAvulsoByCnpj(cnpj).orElse(null)));
    }

    public BaixaAutomaticaCadastroDTO findCadastroSiafi(String cnpj) {
        return this.baixaAutomaticaDetalheRepository.findCadastroMobiliarioByCnpj(cnpj).orElseGet(() -> this.baixaAutomaticaDetalheRepository.findCadastroMobiliarioByCnpjRaiz(cnpj).orElseGet(() -> {
            Boolean permiteBuscaAvulsaSiafi = this.parametroEntidadeExercicioService.findByModuloAndParametro(ModuloEnum.MODULO_TRIBUTARIO, ParametroEntidadeExercicioEnum.BUSCA_AVULSO_SIAFI).map(ParametroEntidadeExercicio::getValor).map("S"::equals).orElse(Boolean.FALSE);
            return permiteBuscaAvulsaSiafi != false ? (BaixaAutomaticaCadastroDTO)this.baixaAutomaticaDetalheRepository.findCadastroAvulsoByCnpj(cnpj).orElse(null) : null;
        }));
    }

    public Boolean todasSequenciasBaixadas(PagamentoLoteId pagamentoLoteId) {
        return this.baixaAutomaticaDetalheRepository.todasSequenciasBaixadas(pagamentoLoteId.getEntidade(), pagamentoLoteId.getExercicio(), pagamentoLoteId.getLote());
    }
}

