/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource.requerimento;

import br.com.elotech.core.resource.support.CrudResource;
import br.com.elotech.tributos.domain.requerimento.Requerimento;
import br.com.elotech.tributos.domain.requerimento.RequerimentoId;
import br.com.elotech.tributos.dto.requerimento.RequerimentoDTO;
import br.com.elotech.tributos.dto.requerimento.RequerimentoListagemDTO;
import br.com.elotech.tributos.service.requerimento.RequerimentoService;
import java.io.Serializable;
import javax.validation.Valid;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/requerimentos"})
public class RequerimentoResource
extends CrudResource<Requerimento, RequerimentoId> {
    private final RequerimentoService requerimentoService;

    public RequerimentoResource(RequerimentoService requerimentoService) {
        this.requerimentoService = requerimentoService;
    }

    @GetMapping(value={"/search"})
    public ResponseEntity<Page<RequerimentoListagemDTO>> findAllListagem(@RequestParam(value="search", required=false) String search, Pageable pageable) {
        Page result = this.getService().findByRsql(search, pageable);
        return ResponseEntity.ok((Object)result.map(RequerimentoListagemDTO::from));
    }

    @GetMapping(value={"/id/{entidade}/{exercicio}/{requerimento}"})
    public ResponseEntity<Requerimento> findById(@PathVariable Long entidade, @PathVariable Long exercicio, @PathVariable Long requerimento) {
        return ResponseEntity.ok((Object)this.getService().findOne((Serializable)RequerimentoId.from((Long)entidade, (Long)exercicio, (Long)requerimento)));
    }

    @PostMapping(value={"/gerar"})
    public ResponseEntity<RequerimentoId> gerarRequerimento(@RequestBody @Valid RequerimentoDTO requerimentoDTO) {
        return ResponseEntity.ok((Object)this.requerimentoService.gerar(requerimentoDTO));
    }
}

