/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource.integracaocontabil;

import br.com.elotech.tributos.dto.integracaocontabil.DiarioArrecadacaoItemDTO;
import br.com.elotech.tributos.dto.integracaocontabil.FiltroDiarioArrecadacaoDTO;
import br.com.elotech.tributos.dto.integracaocontabil.TotalizadorDiarioArrecadacaoDTO;
import br.com.elotech.tributos.service.integracaocontabil.DiarioArrecadacaoService;
import javax.validation.Valid;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/diario-arrecadacao"})
public class DiarioArrecadacaoResource {
    private final DiarioArrecadacaoService diarioArrecadacaoService;

    public DiarioArrecadacaoResource(DiarioArrecadacaoService diarioArrecadacaoService) {
        this.diarioArrecadacaoService = diarioArrecadacaoService;
    }

    @PostMapping(value={"/consulta"})
    public ResponseEntity<Page<DiarioArrecadacaoItemDTO>> findDiariosArrecadacao(@RequestBody @Valid FiltroDiarioArrecadacaoDTO filtro, Pageable pageable) {
        return ResponseEntity.ok((Object)this.diarioArrecadacaoService.findDiariosArrecadacao(filtro, pageable));
    }

    @PostMapping(value={"/totalizador"})
    public ResponseEntity<TotalizadorDiarioArrecadacaoDTO> getTotalizador(@RequestBody @Valid FiltroDiarioArrecadacaoDTO filtro) {
        return ResponseEntity.ok((Object)this.diarioArrecadacaoService.getTotalizador(filtro));
    }
}

