/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource;

import br.com.elotech.tributos.domain.ConsultaDebito;
import br.com.elotech.tributos.dto.ConsultaDebitoItemDTO;
import br.com.elotech.tributos.dto.ConsultaDebitoValoresDTO;
import br.com.elotech.tributos.dto.FiltroConsultaDebitoDTO;
import br.com.elotech.tributos.service.ConsultaDebitoBatchService;
import br.com.elotech.tributos.service.DebitoService;
import br.com.elotech.tributos.service.batch.ConsultaDebitoJobStarter;
import com.fasterxml.jackson.core.JsonProcessingException;
import javax.validation.Valid;
import org.springframework.batch.core.JobParametersInvalidException;
import org.springframework.batch.core.repository.JobExecutionAlreadyRunningException;
import org.springframework.batch.core.repository.JobInstanceAlreadyCompleteException;
import org.springframework.batch.core.repository.JobRestartException;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.repository.query.Param;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/consulta-debito"})
public class ConsultaDebitoResource {
    private final ConsultaDebitoJobStarter consultaDebitoJobStarter;
    private final ConsultaDebitoBatchService consultaDebitoBatchService;
    private final DebitoService debitoService;

    public ConsultaDebitoResource(ConsultaDebitoJobStarter consultaDebitoJobStarter, ConsultaDebitoBatchService consultaDebitoBatchService, DebitoService debitoService) {
        this.consultaDebitoJobStarter = consultaDebitoJobStarter;
        this.consultaDebitoBatchService = consultaDebitoBatchService;
        this.debitoService = debitoService;
    }

    @PostMapping
    public ResponseEntity<ConsultaDebito> consultarDebito(@Valid @RequestBody FiltroConsultaDebitoDTO filtro) throws JobParametersInvalidException, JobExecutionAlreadyRunningException, JobRestartException, JobInstanceAlreadyCompleteException, JsonProcessingException {
        this.debitoService.totalDebitosConstituidos(filtro);
        this.consultaDebitoJobStarter.startJob(filtro);
        return ResponseEntity.ok().build();
    }

    @GetMapping(value={"/{idConsulta}"}, params={"tipoAgrupamento"})
    public ResponseEntity<Page<ConsultaDebitoItemDTO>> findDebitos(@PathVariable Long idConsulta, @Param(value="tipoAgrupamento") String tipoAgrupamento, Pageable pageable) {
        return ResponseEntity.ok((Object)this.consultaDebitoBatchService.getDebitos(idConsulta, tipoAgrupamento, pageable));
    }

    @GetMapping(value={"/{idConsulta}/filtro"})
    public ResponseEntity<FiltroConsultaDebitoDTO> getFiltro(@PathVariable Long idConsulta) throws JsonProcessingException {
        return ResponseEntity.ok((Object)this.consultaDebitoBatchService.getFiltro(idConsulta));
    }

    @GetMapping(value={"/{idConsulta}/resumo"})
    public ResponseEntity<ConsultaDebitoValoresDTO> getResumo(@PathVariable Long idConsulta) {
        return ResponseEntity.ok((Object)this.consultaDebitoBatchService.getResumo(idConsulta));
    }
}

