/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.repository.integracaocontabil;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.tributos.domain.TipoOperacaoTce;
import br.com.elotech.tributos.dto.integracaocontabil.DiarioArrecadacaoConsultaDTO;
import br.com.elotech.tributos.dto.integracaocontabil.DiarioArrecadacaoItemDTO;
import br.com.elotech.tributos.dto.integracaocontabil.FiltroDiarioArrecadacaoDTO;
import br.com.elotech.tributos.dto.integracaocontabil.TotalizadorDiarioArrecadacaoDTO;
import br.com.elotech.tributos.util.SqlUtils;
import java.sql.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class DiarioArrecadacaoRepository {
    private static final String QUERY_DIARIO = "br/com/elotech/tributos/repository/integracaocontabil/find-diario-arrecadacao.sql";
    private static final String ENTIDADE = "entidade";
    private static final String DATA_ARRECADACAO = "dataarrecadacao";
    private static final String SELECT_CLAUSE = "lotecontabil.datalote as dataArrecadacao,\n       lotecontabil.tipolote as tipoMovimento,\n       pessoa.cnpj_cpf as cpfCnpj,\n       pessoa.nome,\n       debito.tipocadastro,\n       debito.cadastrogeral,\n       debito.iddebito,\n       receitatipo.tiporeceita as idTipoTributo,\n       receitatipo.descricao as descricaoTipoTributo,\n       operacaolote.codigotce as codigoTipoOperacaoDeducao,\n       operacaolote.descricao as descricaoTipoOperacaoDeducao,\n       itemcontabil.idtipooperacaodeducao as idTipoOperacaoDeducao,\n       itemcontabil.situacaolegal as situacaoLegalDebito,\n       itemcontabil.classificacaotributo,\n       itemcontabil.valortributo,\n       itemcontabil.valordeducao";
    private static final String ORDERBY_CLAUSE = "order by pessoa.nome,\n       debito.cadastrogeral,\n       receitatipo.tiporeceita,\n       debito.exercicio,\n       debito.guiarecolhimento,\n       debito.subdivida";
    private static final String SELECT_TOTAL_CLAUSE = "sum(coalesce(itemcontabil.valortributo, 0)) as valorTributo,\n       sum(coalesce(itemcontabil.valordeducao, 0)) as valorDeducao";
    private final NamedParameterJdbcTemplate namedParameterJdbcTemplate;

    public DiarioArrecadacaoRepository(NamedParameterJdbcTemplate namedParameterJdbcTemplate) {
        this.namedParameterJdbcTemplate = namedParameterJdbcTemplate;
    }

    public Page<DiarioArrecadacaoItemDTO> findDiariosArrecadacao(FiltroDiarioArrecadacaoDTO filtro, Long entidade, TipoOperacaoTce tipoOperacaoTcePadrao, Pageable pageable) {
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue(ENTIDADE, (Object)entidade);
        parameters.addValue(DATA_ARRECADACAO, (Object)Date.valueOf(filtro.getDataArrecadacao()));
        String sql = String.format(FileUtils.readResourceAsString((String)QUERY_DIARIO), SELECT_CLAUSE, filtro.buildWhereClause(), ORDERBY_CLAUSE);
        String sqlCountTotal = String.format("select count(*) as total from (%s) count_query", sql);
        Long total = (Long)this.namedParameterJdbcTemplate.queryForObject(sqlCountTotal, (SqlParameterSource)parameters, (rs, rowNum) -> rs.getLong("total"));
        String sqlWithPagination = SqlUtils.withPagination((String)sql, (Pageable)pageable, (DataSource)this.namedParameterJdbcTemplate.getJdbcTemplate().getDataSource());
        List resultQuery = this.namedParameterJdbcTemplate.query(sqlWithPagination, (SqlParameterSource)parameters, (RowMapper)new ElotechBeanPropertyRowMapper(DiarioArrecadacaoConsultaDTO.class));
        List diarios = resultQuery.stream().map(result -> DiarioArrecadacaoItemDTO.of((DiarioArrecadacaoConsultaDTO)result, (TipoOperacaoTce)tipoOperacaoTcePadrao)).collect(Collectors.toList());
        return new PageImpl(diarios, pageable, total.longValue());
    }

    public TotalizadorDiarioArrecadacaoDTO getTotalizador(FiltroDiarioArrecadacaoDTO filtro, Long entidade) {
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue(ENTIDADE, (Object)entidade);
        parameters.addValue(DATA_ARRECADACAO, (Object)Date.valueOf(filtro.getDataArrecadacao()));
        String sql = String.format(FileUtils.readResourceAsString((String)QUERY_DIARIO), SELECT_TOTAL_CLAUSE, filtro.buildWhereClause(), "");
        return (TotalizadorDiarioArrecadacaoDTO)this.namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)new ElotechBeanPropertyRowMapper(TotalizadorDiarioArrecadacaoDTO.class));
    }
}

